# Microsoft.AspNetCore.Mvc.Diagnostics

``` diff
+namespace Microsoft.AspNetCore.Mvc.Diagnostics {
+    public sealed class AfterActionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterAction";
+        public AfterActionEventData(ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public HttpContext HttpContext { get; }
+        public RouteData RouteData { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterActionFilterOnActionExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecuted";
+        public AfterActionFilterOnActionExecutedEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutedContext ActionExecutedContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterActionFilterOnActionExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecuting";
+        public AfterActionFilterOnActionExecutingEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutingContext ActionExecutingContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterActionFilterOnActionExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnActionExecution";
+        public AfterActionFilterOnActionExecutionEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutedContext ActionExecutedContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterActionResultEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterActionResult";
+        public AfterActionResultEventData(ActionContext actionContext, IActionResult result);
+        public ActionContext ActionContext { get; }
+        protected override int Count { get; }
+        public IActionResult Result { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterAuthorizationFilterOnAuthorizationEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnAuthorization";
+        public AfterAuthorizationFilterOnAuthorizationEventData(ActionDescriptor actionDescriptor, AuthorizationFilterContext authorizationContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public AuthorizationFilterContext AuthorizationContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterControllerActionMethodEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterControllerActionMethod";
+        public AfterControllerActionMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, object controller, IActionResult result);
+        public ActionContext ActionContext { get; }
+        public IReadOnlyDictionary<string, object> Arguments { get; }
+        public object Controller { get; }
+        protected override int Count { get; }
+        public IActionResult Result { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterExceptionFilterOnExceptionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnException";
+        public AfterExceptionFilterOnExceptionEventData(ActionDescriptor actionDescriptor, ExceptionContext exceptionContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public ExceptionContext ExceptionContext { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterHandlerMethodEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterHandlerMethod";
+        public AfterHandlerMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, HandlerMethodDescriptor handlerMethodDescriptor, object instance, IActionResult result);
+        public ActionContext ActionContext { get; }
+        public IReadOnlyDictionary<string, object> Arguments { get; }
+        protected override int Count { get; }
+        public HandlerMethodDescriptor HandlerMethodDescriptor { get; }
+        public object Instance { get; }
+        public IActionResult Result { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterPageFilterOnPageHandlerExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecuted";
+        public AfterPageFilterOnPageHandlerExecutedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerExecutedContext HandlerExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterPageFilterOnPageHandlerExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecuting";
+        public AfterPageFilterOnPageHandlerExecutingEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerExecutingContext HandlerExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterPageFilterOnPageHandlerExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecution";
+        public AfterPageFilterOnPageHandlerExecutionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IAsyncPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IAsyncPageFilter Filter { get; }
+        public PageHandlerExecutedContext HandlerExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterPageFilterOnPageHandlerSelectedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerSelected";
+        public AfterPageFilterOnPageHandlerSelectedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerSelectedContext HandlerSelectedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterPageFilterOnPageHandlerSelectionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerSelection";
+        public AfterPageFilterOnPageHandlerSelectionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IAsyncPageFilter Filter { get; }
+        public PageHandlerSelectedContext HandlerSelectedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResourceFilterOnResourceExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecuted";
+        public AfterResourceFilterOnResourceExecutedEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutedContext ResourceExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResourceFilterOnResourceExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecuting";
+        public AfterResourceFilterOnResourceExecutingEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutingContext ResourceExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResourceFilterOnResourceExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResourceExecution";
+        public AfterResourceFilterOnResourceExecutionEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutedContext ResourceExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResultFilterOnResultExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecuted";
+        public AfterResultFilterOnResultExecutedEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutedContext ResultExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResultFilterOnResultExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecuting";
+        public AfterResultFilterOnResultExecutingEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutingContext ResultExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterResultFilterOnResultExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnResultExecution";
+        public AfterResultFilterOnResultExecutionEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutedContext ResultExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class AfterViewComponentEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterViewComponent";
+        public AfterViewComponentEventData(ActionDescriptor actionDescriptor, ViewComponentContext viewComponentContext, IViewComponentResult viewComponentResult, object viewComponent);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public object ViewComponent { get; }
+        public ViewComponentContext ViewComponentContext { get; }
+        public IViewComponentResult ViewComponentResult { get; }
+    }
+    public sealed class AfterViewEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.AfterView";
+        public AfterViewEventData(IView view, ViewContext viewContext);
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public IView View { get; }
+        public ViewContext ViewContext { get; }
+    }
+    public sealed class AfterViewPageEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.Razor.AfterViewPage";
+        public AfterViewPageEventData(IRazorPage page, ViewContext viewContext, ActionDescriptor actionDescriptor, HttpContext httpContext);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public HttpContext HttpContext { get; }
+        public IRazorPage Page { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public ViewContext ViewContext { get; }
+    }
+    public sealed class BeforeActionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeAction";
+        public BeforeActionEventData(ActionDescriptor actionDescriptor, HttpContext httpContext, RouteData routeData);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public HttpContext HttpContext { get; }
+        public RouteData RouteData { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeActionFilterOnActionExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecuted";
+        public BeforeActionFilterOnActionExecutedEventData(ActionDescriptor actionDescriptor, ActionExecutedContext actionExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutedContext ActionExecutedContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeActionFilterOnActionExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecuting";
+        public BeforeActionFilterOnActionExecutingEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutingContext ActionExecutingContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeActionFilterOnActionExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnActionExecution";
+        public BeforeActionFilterOnActionExecutionEventData(ActionDescriptor actionDescriptor, ActionExecutingContext actionExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public ActionExecutingContext ActionExecutingContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeActionResultEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeActionResult";
+        public BeforeActionResultEventData(ActionContext actionContext, IActionResult result);
+        public ActionContext ActionContext { get; }
+        protected override int Count { get; }
+        public IActionResult Result { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeAuthorizationFilterOnAuthorizationEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnAuthorization";
+        public BeforeAuthorizationFilterOnAuthorizationEventData(ActionDescriptor actionDescriptor, AuthorizationFilterContext authorizationContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        public AuthorizationFilterContext AuthorizationContext { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeControllerActionMethodEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeControllerActionMethod";
+        public BeforeControllerActionMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> actionArguments, object controller);
+        public IReadOnlyDictionary<string, object> ActionArguments { get; }
+        public ActionContext ActionContext { get; }
+        public object Controller { get; }
+        protected sealed override int Count { get; }
+        protected sealed override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeExceptionFilterOnException : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnException";
+        public BeforeExceptionFilterOnException(ActionDescriptor actionDescriptor, ExceptionContext exceptionContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public ExceptionContext ExceptionContext { get; }
+        public IFilterMetadata Filter { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeHandlerMethodEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeHandlerMethod";
+        public BeforeHandlerMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, HandlerMethodDescriptor handlerMethodDescriptor, object instance);
+        public ActionContext ActionContext { get; }
+        public IReadOnlyDictionary<string, object> Arguments { get; }
+        protected override int Count { get; }
+        public HandlerMethodDescriptor HandlerMethodDescriptor { get; }
+        public object Instance { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforePageFilterOnPageHandlerExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecuted";
+        public BeforePageFilterOnPageHandlerExecutedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerExecutedContext HandlerExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforePageFilterOnPageHandlerExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecuting";
+        public BeforePageFilterOnPageHandlerExecutingEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerExecutingContext HandlerExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforePageFilterOnPageHandlerExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecution";
+        public BeforePageFilterOnPageHandlerExecutionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutionContext, IAsyncPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IAsyncPageFilter Filter { get; }
+        public PageHandlerExecutingContext HandlerExecutionContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforePageFilterOnPageHandlerSelectedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerSelected";
+        public BeforePageFilterOnPageHandlerSelectedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IPageFilter Filter { get; }
+        public PageHandlerSelectedContext HandlerSelectedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforePageFilterOnPageHandlerSelectionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerSelection";
+        public BeforePageFilterOnPageHandlerSelectionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);
+        public CompiledPageActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IAsyncPageFilter Filter { get; }
+        public PageHandlerSelectedContext HandlerSelectedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResourceFilterOnResourceExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecuted";
+        public BeforeResourceFilterOnResourceExecutedEventData(ActionDescriptor actionDescriptor, ResourceExecutedContext resourceExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutedContext ResourceExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResourceFilterOnResourceExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecuting";
+        public BeforeResourceFilterOnResourceExecutingEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutingContext ResourceExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResourceFilterOnResourceExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResourceExecution";
+        public BeforeResourceFilterOnResourceExecutionEventData(ActionDescriptor actionDescriptor, ResourceExecutingContext resourceExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResourceExecutingContext ResourceExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResultFilterOnResultExecutedEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecuted";
+        public BeforeResultFilterOnResultExecutedEventData(ActionDescriptor actionDescriptor, ResultExecutedContext resultExecutedContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutedContext ResultExecutedContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResultFilterOnResultExecutingEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecuting";
+        public BeforeResultFilterOnResultExecutingEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutingContext ResultExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeResultFilterOnResultExecutionEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnResultExecution";
+        public BeforeResultFilterOnResultExecutionEventData(ActionDescriptor actionDescriptor, ResultExecutingContext resultExecutingContext, IFilterMetadata filter);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public IFilterMetadata Filter { get; }
+        public ResultExecutingContext ResultExecutingContext { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+    }
+    public sealed class BeforeViewComponentEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeViewComponent";
+        public BeforeViewComponentEventData(ActionDescriptor actionDescriptor, ViewComponentContext viewComponentContext, object viewComponent);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public object ViewComponent { get; }
+        public ViewComponentContext ViewComponentContext { get; }
+    }
+    public sealed class BeforeViewEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeView";
+        public BeforeViewEventData(IView view, ViewContext viewContext);
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public IView View { get; }
+        public ViewContext ViewContext { get; }
+    }
+    public sealed class BeforeViewPageEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.Razor.BeforeViewPage";
+        public BeforeViewPageEventData(IRazorPage page, ViewContext viewContext, ActionDescriptor actionDescriptor, HttpContext httpContext);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        public HttpContext HttpContext { get; }
+        public IRazorPage Page { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public ViewContext ViewContext { get; }
+    }
+    public abstract class EventData : IEnumerable, IEnumerable<KeyValuePair<string, object>>, IReadOnlyCollection<KeyValuePair<string, object>>, IReadOnlyList<KeyValuePair<string, object>> {
+        protected const string EventNamespace = "Microsoft.AspNetCore.Mvc.";
+        protected EventData();
+        protected abstract int Count { get; }
+        int System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Count { get; }
+        KeyValuePair<string, object> System.Collections.Generic.IReadOnlyList<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.this[int index] { get; }
+        protected abstract KeyValuePair<string, object> this[int index] { get; }
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+            public KeyValuePair<string, object> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+        }
+    }
+    public sealed class ViewComponentAfterViewExecuteEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.ViewComponentAfterViewExecute";
+        public ViewComponentAfterViewExecuteEventData(ActionDescriptor actionDescriptor, ViewComponentContext viewComponentContext, IView view);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public IView View { get; }
+        public ViewComponentContext ViewComponentContext { get; }
+    }
+    public sealed class ViewComponentBeforeViewExecuteEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.ViewComponentBeforeViewExecute";
+        public ViewComponentBeforeViewExecuteEventData(ActionDescriptor actionDescriptor, ViewComponentContext viewComponentContext, IView view);
+        public ActionDescriptor ActionDescriptor { get; }
+        protected override int Count { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public IView View { get; }
+        public ViewComponentContext ViewComponentContext { get; }
+    }
+    public sealed class ViewFoundEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.ViewFound";
+        public ViewFoundEventData(ActionContext actionContext, bool isMainPage, ActionResult result, string viewName, IView view);
+        public ActionContext ActionContext { get; }
+        protected override int Count { get; }
+        public bool IsMainPage { get; }
+        public ActionResult Result { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public IView View { get; }
+        public string ViewName { get; }
+    }
+    public sealed class ViewNotFoundEventData : EventData {
+        public const string EventName = "Microsoft.AspNetCore.Mvc.ViewNotFound";
+        public ViewNotFoundEventData(ActionContext actionContext, bool isMainPage, ActionResult result, string viewName, IEnumerable<string> searchedLocations);
+        public ActionContext ActionContext { get; }
+        protected override int Count { get; }
+        public bool IsMainPage { get; }
+        public ActionResult Result { get; }
+        public IEnumerable<string> SearchedLocations { get; }
+        protected override KeyValuePair<string, object> this[int index] { get; }
+        public string ViewName { get; }
+    }
+}
```

