# .NET Core 3.1  Known Issues

This document lists known issues for **.NET Core 3.1 Preview 1 and beyond releases** which may be encountered during usage.

## .NET Core

* Snap : Issue with Running .NET Core 3.1 applications on Ubuntu 20.10 or 20.04 https://github.com/dotnet/core/issues/6161
* Visual Studio 16.4 Preview 2 may uninstall .NET Core 3.0 when installed with the .NET Core 3.1 SDK. We recommend you re-install or repair the [.NET Core 3.0 SDK](https://dotnet.microsoft.com/download/dotnet/3.0) if this happens.

### .NET Core 3.1.26
Users/Developers may see missing template for Winforms Control library in Visual Studio (16.11) with latest servicing update. Users may also see following error when trying to create Winforms Control library via command line interface (CLI) command **dotnet -new winformslib**.

Error reading template from _file: /WinFormsLibrary-CSharp/.template.config/template.json | Error = After parsing a value an unexpected character was encountered: ". Path 'symbols.Framework.choices[0].description', line 34, position 10.
No templates found matching: 'winformslib'._

As a workaround, users can install .NET 3.1 SDK online to unblock themselves. However, this may mislead users that they are creating out of support “.NET core 3.0 “ application as shown in below picture but the actual application created is targeting .NET 3.1.

![3126-image](https://user-images.githubusercontent.com/94140381/173151704-0c516b95-59c2-447f-9182-f7a45c4b63e3.png)


### .NET Core 3.1.20

Between the time of 10/12/2021 10:00AM PST and 10/14/2021 10:00AM PST the .NET Core 3.1.20 update was available as an automatic update on Microsoft Update to operating systems Windows Server 2012 R2, Windows Server 2016, Windows Server version 1709, Windows Server version 1803, Windows Server 2019, Windows Server version 1903, Windows Server version 1909, Windows Server version 2004, and Windows Server version 20H2 for the x64 architecture.  Systems that are configured to take automatic updates from Microsoft Update with these operating systems and with any of the .NET Core versions 3.1.10 through 3.1.19 installed may have been updated to 3.1.20 during this time.  The .NET Core 3.1.20 is no longer available as an automatic update, but will continue to be available through Microsoft Update WSUS and Microsoft Catalog. 

### .NET Core 3.1.2

When a .NET Core application uses both System.Data.SqlClient and a .NETFramework library which requires System.Data, the .NET Core 3.1.2 runtime can cause the application to fail with an exception like the following:

*System.IO.FileLoadException: Could not load file or assembly 'System.Data.SqlClient, Version=4.6.1.1, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a'. The located assembly's manifest definition does not match the assembly reference. <br>
System.IO.FileNotFoundException: Could not load file or assembly 'System.Data.SqlClient, Version=4.6.1.1, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a'. The system cannot find the file specified.*
 
To fix this, update the application to use the System.Data.SqlClient package version 4.8.1.


### .NET Core 3.1.2 SDK (3.1.102 SDK)

Packages built out of dotnet/corefx but part of the "Microsoft.AspNetCore.App" Shared Framework don't exist in the targeting pack for 3.1.2. Due to this, after upgrading to 3.1.2, apps which were able to compile against some assemblies can no longer compile. This will have an impact on both .NET Core as well as ASP.NET Core.

List of affected assemblies 
* System.Diagnostics.EventLog
* System.IO.Pipelines
* System.Security.AccessControl
* System.Security.Cryptography.Cng
* System.Security.Cryptography.Xml
* System.Security.Permissions
* System.Security.Principal.Windows
* System.Windows.Extensions

Current workaround for this issue is to add an explicit PackageReference to the packages corresponding to above mentioned assemblies. 
You can find more information about this issue on [dotnet/aspnetcore](https://github.com/dotnet/aspnetcore/issues/19133)
A fix for this will be available in a future servicing release of 3.1.X.


### .NET Core 3.1.1 SDK (3.1.101 SDK)
- **ASP.NET Core runtime issue on systems other than Windows x-64 ([aspnet/Announcements/401](https://github.com/aspnet/Announcements/issues/401))**

    When using the 3.1.101 SDK to build an application and then deploying to a runtime environment other than 64-bit Windows, people may see a runtime exception failing to load certain dependencies.  This can be worked around by adding a `PackageReference` directly to the package that fails to load.

    More information can be found in the referenced issue.

### .NET Core 3.1.0 SDK (3.1.100 SDK)

- **ASP.NET Core workloads may use older dependencies for libraries that are present in the Targeting Pack ([aspnet/Announcements/398](https://github.com/aspnet/Announcements/issues/398))** 

    When using the 3.1.100 SDK, people who are building ASP.NET Core workloads may encounter an error where lower versioned dependencies that are referenced by the application aren't removed correctly. The most common occurrence of this issue is when hosting with IIS, where there is mismatch between two libraries causing a `NullReferenceException`. 
    
    Workarounds and more information are in the referenced issue.

### .NET Core installation on macOS Catalina (10.15)

macOS Catalina introduced new security features which affect the .NET Core installers. If you run the installer after downloading using a web browser, a warning dialog will open stating the package `"...can't be opened because Apple cannot check it for malicious software."`, and the installation will be stopped.

To override this behavior, go to Settings : Security & Privacy and choose "Open Anyway" next to the dotnet installer text.

We are working to update our installers for the new Catalina requirements. These will be released during an upcoming monthly update.

## .NET Core 3.1 SDK, all releases

## ASP.NET Core

### 3.1.0

* **[RESOLVED] The 3.1.0 Hosting Bundle for Windows installs a .NET Core Runtime incorrectly branded "3.1.0 Preview 3".**

This is a cosmetic bug: the hosting bundle is expected to function normally.

This is fixed with 3.1.1. More information at [dotnet/core#3962](https://github.com/dotnet/core/issues/3962).

The Hosting Bundle briefly shows that it is installing "Microsoft .NET Core Runtime - 3.1.0 Preview 3". That string is also visible in Add/Remove Programs after the install completes. This is **not** the old November 2019 3.1.0 Preview 3 Runtime. The Hosting Bundle is installing a more recent build of 3.1.0 that has incorrect branding.

* **[RESOLVED] If the 3.1.0 SDK and Hosting Bundle were previously installed on Windows, installing the 3.1.0 .NET Core Runtime directly may remove important files such as `hostpolicy.dll`.**

To fix this, repair the .NET Core Runtime installation. (Execute the installer again and click Repair, or find the .NET Core Runtime 3.1.0 installation in Add/Remove Programs, select Modify, then click Repair.)

This is fixed with 3.1.1. More information at [dotnet/core#3962](https://github.com/dotnet/core/issues/3962) and [dotnet/runtime#703](https://github.com/dotnet/runtime/issues/703).

Missing this file can cause errors like the following, for example when running `dotnet --info`:

> A fatal error was encountered. The library 'hostpolicy.dll' required to execute the application was not found in 'C:\Program Files\dotnet\shared\Microsoft.NETCore.App\3.1.0'.

### Preview1

* **[RESOLVED] Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation package is missing MSBuild targets to correctly enable runtime compilation**

Due to an package authoring error, the `Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation` is missing build targets that are required to for runtime compilation to work. 
Users of this package will see errors along the lines of `"System.InvalidOperationException: Cannot find reference assembly '...' file for package '...'*`

To resolve this issue, add the following contents to the your project file:

```xml
  <PropertyGroup>
    <PreserveCompilationContext>true</PreserveCompilationContext>
    <PreserveCompilationReferences>true</PreserveCompilationReferences>
    <GenerateRazorHostingAssemblyInfo>true</GenerateRazorHostingAssemblyInfo>
    <RazorUpToDateReloadFileTypes>$(RazorUpToDateReloadFileTypes.Replace('.cshtml', ''))</RazorUpToDateReloadFileTypes>
    <AddCshtmlFilesToDotNetWatchList>false</AddCshtmlFilesToDotNetWatchList>
  </PropertyGroup>
```
This issue has been resolved in 3.1 Preview 2. 
