# .NET Core 3.1.20 - October 12 , 2021

The .NET Core Runtime 3.1.20, .NET Core SDK 3.1.414 and [.NET Core SDK 3.1.120](3.1.120.md) releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.414
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.20 is being deployed to Azure App Services and the deployment is expected to complete later in September 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.414](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.120](3.1.120.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.20 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release
* [EFCore](https://github.com/dotnet/efcore/pulls?q=milestone%3A3.1.20++is%3Aclosed+label%3Aservicing-approved+)
* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A3.1.20++is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6794](https://github.com/dotnet/core/issues/6794) for your questions and comments.

## Known Issue

Between the time of 10/12/2021 10:00AM PST and 10/14/2021 10:00AM PST the .NET Core 3.1.20 update was available as an automatic update on Microsoft Update to operating systems Windows Server 2012 R2, Windows Server 2016, Windows Server version 1709, Windows Server version 1803, Windows Server 2019, Windows Server version 1903, Windows Server version 1909, Windows Server version 2004, and Windows Server version 20H2 for the x64 architecture.  Systems that are configured to take automatic updates from Microsoft Update with these operating systems and with any of the .NET Core versions 3.1.10 through 3.1.19 installed may have been updated to 3.1.20 during this time.  The .NET Core 3.1.20 is no longer available as an automatic update, but will continue to be available through Microsoft Update WSUS and Microsoft Catalog. 

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver  | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.20.nupkg
Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
Microsoft.NETCore.Platforms | 3.1.9.nupkg
Microsoft.NETCore.Platforms | 3.1.9.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.20.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.20.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.20.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.20.nupkg
dotnet-sql-cache | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.20.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.20.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.20.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.20.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.20.nupkg
Microsoft.Extensions.Identity.Core | 3.1.20.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.20.nupkg
Microsoft.AspNetCore.TestHost | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.20.nupkg
Microsoft.dotnet-openapi | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.20.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.20.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.20.nupkg
Microsoft.AspNetCore.Metadata | 3.1.20.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.20.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.20.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.20.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.20.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.20.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.20.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.20.nupkg
Microsoft.AspNetCore.Owin | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.20.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.20.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.20.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.20.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.20.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.20.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.20.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.20.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.20.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.20.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.20.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.20.nupkg
Microsoft.AspNetCore.Components | 3.1.20.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.20.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.20.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.20.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.20.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.20.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.20.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.20.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.20.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.20.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.20.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.20.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.20.nupkg
Microsoft.AspNetCore.Authorization | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.20.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.20.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.20.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.20.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.20.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.20.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.20.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.20.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.20.nupkg
Microsoft.NET.Sdk.Razor | 3.1.20.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.20.nupkg
Microsoft.Data.Sqlite | 3.1.20.nupkg
Microsoft.Data.Sqlite.Core | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.20.nupkg
dotnet-ef | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.20.nupkg
Microsoft.EntityFrameworkCore | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.20.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.20.nupkg
Microsoft.JSInterop | 3.1.20.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.20.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.20.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.20.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.20.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.20.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.20.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.20.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.20.nupkg
Microsoft.Extensions.Http.Polly | 3.1.20.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.20.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.20.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.20.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.20.nupkg
Microsoft.Extensions.Primitives | 3.1.20.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.20.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.20.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.20.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.20.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.20.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.20.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.20.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.20.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.20.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.20.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.20.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.20.nupkg
Microsoft.Extensions.Hosting | 3.1.20.nupkg
Microsoft.Extensions.Localization | 3.1.20.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.20.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.20.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.20.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.20.nupkg
Microsoft.Extensions.Configuration | 3.1.20.nupkg
Microsoft.Extensions.WebEncoders | 3.1.20.nupkg
Microsoft.Extensions.ObjectPool | 3.1.20.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.20.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.20.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.20.nupkg
Microsoft.Extensions.Options | 3.1.20.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.20.nupkg
Microsoft.Extensions.Logging.Console | 3.1.20.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.20.nupkg
Microsoft.Extensions.Http | 3.1.20.nupkg
Microsoft.Extensions.Logging | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.20.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.20.nupkg
Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.20.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.20.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.20.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.20.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.20.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.20.nupkg




[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.20/3.1.20.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.20-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.20-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/october-2021-updates/



[//]: # ( Runtime 3.1.20)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84cf3448-5d42-407c-a74d-ce3e21b60d0f/a792a4c1b0e492c4f46e99eb9db0c9be/dotnet-runtime-3.1.20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c35bc8c9-fb21-4165-b26f-2b8b243fe0df/c5f126fb858a2c847b1b39a8f7085144/dotnet-runtime-3.1.20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/909e5d0b-8cac-47cf-8f21-a502d3b38da4/50704d23fe2eecc240bed41827ea5054/dotnet-runtime-3.1.20-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/053a4ee3-0d81-4873-accb-3e01f9a07e3e/b0c8419339aea43b7e22e6725773a71e/dotnet-runtime-3.1.20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e22ce067-99cb-4e59-8623-97fab16a0f5e/9d4825680d3f3a1850bbd3acb9ee9d28/dotnet-runtime-3.1.20-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/55e76de0-b547-49c7-bdcd-12838224599e/c9b70778e5c3749b5e35fde0bf324ee3/dotnet-runtime-3.1.20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/259731a8-e26b-43df-8c07-eb63e50bd74a/9aa4c334a0f71e5b821e102392777845/dotnet-runtime-3.1.20-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/f0eab31c-0a27-4f9f-80d6-2b03eded2614/198af340def5c0863615f2d9f0edc5e4/dotnet-runtime-3.1.20-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8f1a8283-54b1-46d0-96c3-02949986baba/5d1b2bf23eb9addb9a372f32f6992b25/dotnet-runtime-3.1.20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/22fbcca7-1ba8-401a-aff6-f7ddc9c88ec9/144db198000b42acf58e6c8ae74e5cb7/dotnet-runtime-3.1.20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9d7b9779-9a92-463d-8881-ac140f2dccbb/f8ec3af2889c0c9346ba493fc43c912d/dotnet-runtime-3.1.20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1fa4d7b3-34ce-43fe-8e60-4bb94221326a/024e2949a7ef91b663c3b662b0a1e313/dotnet-runtime-3.1.20-win-x86.zip

[//]: # ( WindowsDesktop 3.1.20)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93c69a29-d379-4a5d-bb9e-3116cc14de41/907bbc52446d8bb7baa0c6faebde1d44/windowsdesktop-runtime-3.1.20-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/30dcb1c4-79da-495c-9947-a3bb8efc9d99/76a3de29f61f9785ee57c2a74c3a6418/windowsdesktop-runtime-3.1.20-win-x86.exe

[//]: # ( ASP 3.1.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0843b54f-ea69-4699-a4c1-b65ec93b4109/a74ca56e6099318bdbc55dc72e3bf69a/aspnetcore-runtime-3.1.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/477965bb-c3b1-446b-8820-bc0c29089509/7089af417d80f03812b22d7101b0d136/aspnetcore-runtime-3.1.20-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab11f8ae-07a7-4f26-bea0-6e9cc6c110d8/109da2ecd38c62bc31e74c622f029d51/aspnetcore-runtime-3.1.20-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/525fe2bc-fdd8-4785-b615-933c1cd020ce/167ca8c28edce56034e8f2a9832dcbf0/aspnetcore-runtime-3.1.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63827c97-af9b-4c3b-a9df-5ed97c51cbe1/e07ed23d466369c90c96340c882f08fe/aspnetcore-runtime-3.1.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ab7fc21-bb27-4a77-ac24-3d5b832327b2/e041c63a25c0833bc78efb45b74bf598/aspnetcore-runtime-3.1.20-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/e820f2c7-b0e0-46f3-b1f4-a71cb62e2ad4/1b32fd0e76ceb74da4d9834fb531806a/aspnetcore-runtime-3.1.20-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dad6553b-3005-4b9f-b91e-ca759c9a36c3/9c63c8b6932a468180060a6a5fa24a00/aspnetcore-runtime-3.1.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a267675-3581-4151-9e62-ffa0bc24dade/f0627c5443e03cb2b56598792225eb73/aspnetcore-runtime-3.1.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d6afcfef-2eca-4d92-b988-60cab2816623/9f6e693cdf5007c8b943971af7498f59/aspnetcore-runtime-3.1.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/383bcfc7-942d-4866-b398-b24a1dfc1f8f/35f48f8cafb4aa4ae6e2e0bb07f90de7/aspnetcore-runtime-3.1.20-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/99800e2a-a5c0-4340-9379-e911e60fb879/1582a935b900bc4c8e337b594e8e7d56/dotnet-hosting-3.1.20-win.exe

[//]: # ( SDK 3.1.414)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cefd43b6-16ac-4435-bcc6-594ebb0441cf/7d064f0f61c4174f620eafe97484e6cb/dotnet-sdk-3.1.414-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/040f982b-bd08-496f-ae52-a60361a79546/7d572611a4177c48d868e0516ac192dc/dotnet-sdk-3.1.414-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b01a6d93-4dac-40fb-b41f-2f7c0611221c/150e708ce15e350574ae5c99e83bbeaf/dotnet-sdk-3.1.414-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d34e1a17-40d4-442d-b0e2-dc297a8742ef/e8bd62b16712bb759ed29145bde51676/dotnet-sdk-3.1.414-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/47970ff1-77b2-4ad8-998e-29bfa469ffda/12809f01e1a397788165687980691d97/dotnet-sdk-3.1.414-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0517421d-3300-42c7-a420-e42d55068126/76b722e65c0745962156e622ed76501c/dotnet-sdk-3.1.414-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32edabcb-6ae1-436b-af5c-baf9889f225c/126c998e534f5eb911338cb1b52e2e31/dotnet-sdk-3.1.414-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9bd0d0ca-e14a-4d58-8e2b-337333dc4558/57a1b44a1ce488452197587bd775a36c/dotnet-sdk-3.1.414-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/89a2a9ff-0cff-493c-badd-112cd7d62576/bc233fa29900c6c3c280f4d1ba1240f4/dotnet-sdk-3.1.414-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c3cb15c9-11c5-4e80-aebb-9d3a50c5ee0d/0c5ab97d1600fe1702535742e100ddda/dotnet-sdk-3.1.414-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4298a151-4622-4e47-9f5b-e5b9a6ebd705/0b2967a7bc9faed2f8f6231b29c2b4be/dotnet-sdk-3.1.414-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5328a3b8-96a6-4785-99ad-c63efeb7e1ab/09165ce210269f6d3f8f1348c0022596/dotnet-sdk-3.1.414-win-x86.zip
