# .NET Core 3.1.25 - May 10, 2022

.NET Core 3.1.25 and .NET Core SDK 3.1.419 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.419
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.419](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.25 release carries security fixes.

# Microsoft Security Advisory CVE-2022-29117 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can manipulate cookies and cause a Denial of Service.

# Microsoft Security Advisory CVE-2022-29145 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can cause a denial of service when HTML forms are parsed.

# Microsoft Security Advisory CVE-2022-23267 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can cause a Denial of Service via excess memory allocations through HttpClient.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7447](https://github.com/dotnet/core/issues/7447) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.25/3.1.25.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.25-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.25-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/may-2022-update/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
Microsoft.NETCore.App.Host.linux-arm| 3.1.25.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 3.1.25.nupkg
Microsoft.NETCore.App.Host.win-arm| 3.1.25.nupkg
Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
Microsoft.NETCore.App.Host.linux-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Host.win-x86| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.25.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.25.nupkg
Microsoft.NETCore.App.Host.win-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 3.1.25.nupkg
Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.25.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
Microsoft.Extensions.DependencyModel| 3.1.25.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.25.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 3.1.25.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.25.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.25.nupkg
Microsoft.NETCore.App.Host.osx-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Host.win-arm64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 3.1.25.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.25.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.25.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.25.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.25.nupkg
Microsoft.Extensions.Identity.Stores| 3.1.25.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.25.nupkg
Microsoft.Extensions.ApiDescription.Client| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.25.nupkg
Microsoft.AspNetCore.Identity.UI| 3.1.25.nupkg
Microsoft.AspNetCore.Metadata| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.25.nupkg
Microsoft.AspNetCore.Mvc.Testing| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Client| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Common| 3.1.25.nupkg
Microsoft.AspNetCore.HeaderPropagation| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.25.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Identity.Core| 3.1.25.nupkg
Microsoft.Extensions.ApiDescription.Server| 3.1.25.nupkg
Microsoft.DotNet.Web.ItemTemplates| 3.1.25.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.25.nupkg
Microsoft.dotnet-openapi| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.25.nupkg
Microsoft.AspNetCore.NodeServices| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.25.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.25.nupkg
Microsoft.AspNetCore.Owin| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.25.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.25.nupkg
Microsoft.AspNetCore.Components.Authorization| 3.1.25.nupkg
Microsoft.AspNetCore.Components| 3.1.25.nupkg
AspNetCoreRuntime.3.1.x86| 3.1.25.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.25.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.25.nupkg
Microsoft.AspNetCore.JsonPatch| 3.1.25.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 3.1.25.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.25.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.25.nupkg
Microsoft.AspNetCore.Authorization| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.Google| 3.1.25.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 3.1.25.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.25.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.25.nupkg
Microsoft.AspNetCore.TestHost| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.25.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.25.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 3.1.25.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.25.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.25.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.25.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.25.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.25.nupkg
Microsoft.AspNetCore.DataProtection| 3.1.25.nupkg
Microsoft.AspNetCore.Components.Web| 3.1.25.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.25.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.25.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.25.nupkg
AspNetCoreRuntime.3.1.x64| 3.1.25.nupkg
dotnet-sql-cache| 3.1.25.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.25.nupkg
Microsoft.AspNetCore.Http.Features| 3.1.25.nupkg
Microsoft.AspNetCore.SpaServices| 3.1.25.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.25.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.25.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.25.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 3.1.25.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.25.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 3.1.25.nupkg
Microsoft.AspNetCore.Components.Forms| 3.1.25.nupkg
Microsoft.AspNetCore.Components.Analyzers| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.25.nupkg
Microsoft.DotNet.Common.ItemTemplates| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.25.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.25.nupkg
Microsoft.AspNetCore.Razor.Language| 3.1.25.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.25.nupkg
Microsoft.NET.Sdk.Razor| 3.1.25.nupkg
Microsoft.CodeAnalysis.Razor| 3.1.25.nupkg
Microsoft.Data.Sqlite| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Design| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Tools| 3.1.25.nupkg
Microsoft.Data.Sqlite.Core| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Relational| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 3.1.25.nupkg
Microsoft.EntityFrameworkCore| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Proxies| 3.1.25.nupkg
dotnet-ef| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.InMemory| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.25.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 3.1.25.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.25.nupkg
Microsoft.Extensions.Configuration.Xml| 3.1.25.nupkg
Microsoft.Extensions.Configuration.Json| 3.1.25.nupkg
Microsoft.Extensions.Configuration| 3.1.25.nupkg
Microsoft.Extensions.Primitives| 3.1.25.nupkg
Microsoft.Extensions.Options| 3.1.25.nupkg
Microsoft.Extensions.Logging.TraceSource| 3.1.25.nupkg
Microsoft.Extensions.Logging.EventLog| 3.1.25.nupkg
Microsoft.Extensions.Hosting.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.25.nupkg
Microsoft.Extensions.DiagnosticAdapter| 3.1.25.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.25.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.25.nupkg
Microsoft.Extensions.Configuration.Binder| 3.1.25.nupkg
Microsoft.Extensions.Caching.SqlServer| 3.1.25.nupkg
Microsoft.Extensions.WebEncoders| 3.1.25.nupkg
Microsoft.Extensions.ObjectPool| 3.1.25.nupkg
Microsoft.Extensions.Logging.Console| 3.1.25.nupkg
Microsoft.Extensions.Logging.Debug| 3.1.25.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 3.1.25.nupkg
Microsoft.Extensions.Localization| 3.1.25.nupkg
Microsoft.Extensions.Logging| 3.1.25.nupkg
Microsoft.JSInterop| 3.1.25.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Configuration.UserSecrets| 3.1.25.nupkg
Microsoft.Extensions.Configuration.CommandLine| 3.1.25.nupkg
Microsoft.Extensions.Caching.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Configuration.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Caching.Memory| 3.1.25.nupkg
Microsoft.Extensions.Logging.Configuration| 3.1.25.nupkg
Microsoft.Extensions.Http.Polly| 3.1.25.nupkg
Microsoft.Extensions.Localization.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.DependencyInjection| 3.1.25.nupkg
Microsoft.Extensions.Configuration.FileExtensions| 3.1.25.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.25.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.25.nupkg
Microsoft.Extensions.Logging.EventSource| 3.1.25.nupkg
Microsoft.Extensions.FileProviders.Physical| 3.1.25.nupkg
Microsoft.Extensions.Logging.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.FileProviders.Abstractions| 3.1.25.nupkg
Microsoft.Extensions.Configuration.Ini| 3.1.25.nupkg
Microsoft.Extensions.FileProviders.Composite| 3.1.25.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.25.nupkg
Microsoft.Extensions.FileProviders.Embedded| 3.1.25.nupkg
Microsoft.Extensions.FileSystemGlobbing| 3.1.25.nupkg
Microsoft.Extensions.Options.DataAnnotations| 3.1.25.nupkg
Microsoft.Extensions.Hosting| 3.1.25.nupkg
Microsoft.Extensions.Hosting.Systemd| 3.1.25.nupkg
Microsoft.Extensions.Http| 3.1.25.nupkg
Microsoft.Extensions.Hosting.WindowsServices| 3.1.25.nupkg


[//]: # ( Runtime 3.1.25)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01155c4c-9efa-411d-b70e-aceb4c305595/5b81478429abfeb58feeaf09c9ee8d64/dotnet-runtime-3.1.25-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e2b0459-f6b0-4d6c-b485-79f874a00cd3/5329533a7a79f9147e0758e51f5d5e0b/dotnet-runtime-3.1.25-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45b8a615-48f1-4986-8711-4a8d8dae7de5/f9f8cfb782c6824034589aa194280a1d/dotnet-runtime-3.1.25-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cb30893-67b4-48a4-b0e8-7b2a48ce716c/8b5c01cec47fe5174f1be3fa5df19d22/dotnet-runtime-3.1.25-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e74046f6-ee72-4619-8648-2d31ca1cbacf/6c634a9ac8d2df9ec76f278b37e22dc7/dotnet-runtime-3.1.25-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2f988db8-aa82-4fe2-8282-ed93ebd7ef44/653ca061e65afb24f9dd8f0fac46cdfb/dotnet-runtime-3.1.25-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88ee839f-9be2-454b-8334-d364f4b50040/4f4fb205983737f13f3a28995ab4fdab/dotnet-runtime-3.1.25-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d8db6c7a-b618-48f6-b854-0d2324bcfa15/0375d73258a1eb92023a790ce0ea3176/dotnet-runtime-3.1.25-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/53711efb-5204-408d-a12f-956141dc35f8/a60251c1d3660ef0aa4641f527385cff/dotnet-runtime-3.1.25-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/49b479a6-0bbd-43d4-a35e-93946b3699be/868cf29d5eb8fcaaafc83d4ec26df987/dotnet-runtime-3.1.25-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3d271d46-de33-408d-952a-3f076312b7fb/3eb64059b9d34d45b1316d7d8c23d488/dotnet-runtime-3.1.25-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d45f473c-635c-45d8-b92d-c10d91f19092/f4dd083ffe5113d03c15b88e2defac4b/dotnet-runtime-3.1.25-win-x86.zip

[//]: # ( WindowsDesktop 3.1.25)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b1c43147-5635-40e4-b5b2-49075772b8db/d1cc338cf20775e487a52879c103df2a/windowsdesktop-runtime-3.1.25-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d696e537-033e-4a2e-902f-0daf743b4c14/d60e6abafc1235b6d75410ab9ce5cec4/windowsdesktop-runtime-3.1.25-win-x86.exe

[//]: # ( ASP 3.1.25)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d680e7d5-3139-47ec-818b-3223283bf3b6/271bb7aa5faa8034a189b07f9f43ae5a/aspnetcore-runtime-3.1.25-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b48947af-04a3-400f-aa2b-08e5079fd95b/a0d2bd903730864cfa3254a20658aa33/aspnetcore-runtime-3.1.25-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98f7b459-9b10-4807-bb1f-74c4358f500e/b83bab625bcc0780521b934fa20a12b0/aspnetcore-runtime-3.1.25-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4782e20f-fa18-4dd6-9194-e2917ce7f20a/26d2e3f3dd33716893a24c0e0a547dd7/aspnetcore-runtime-3.1.25-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f50a1fa-5fba-4d48-ae5e-dfa009528c60/d188c4e048b701b01604553167c14c5f/aspnetcore-runtime-3.1.25-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f16995c-7258-4ba8-8caf-79c9442eff85/71fabf0bf937fea08cf774199860a84f/aspnetcore-runtime-3.1.25-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8c4eca1f-fa81-4493-8277-80abee4ee5ca/276c8459a5e5545366c6f3350d61cb61/aspnetcore-runtime-3.1.25-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7ab51957-c8c3-475b-97dc-40dfced11c46/0ad0962f5673110b780347496666af45/aspnetcore-runtime-3.1.25-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/86f4cdab-52c5-40a0-80b3-ade2ca52a06b/a549aa2ff9739d06e14bdfc502ac536f/aspnetcore-runtime-3.1.25-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cda623da-6f26-45fd-8841-db3be1ce541a/6a68535557de2064f7347a43952518c3/aspnetcore-runtime-3.1.25-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b979eb17-8be6-4d51-b8eb-a61ba3ba54df/709ecd70359565db312412098b8f9653/aspnetcore-runtime-3.1.25-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1c12a7f4-1e3b-4d0c-a0f8-a03950187940/15abf24d5330aca4429b6212892ca2ae/dotnet-hosting-3.1.25-win.exe

[//]: # ( SDK 3.1.419)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/077c85dd-4bb4-45d9-8cc7-4913ab0307d1/444453aee99210cbd2b966fba8c11cb6/dotnet-sdk-3.1.419-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6aaec6b7-3d0c-4f00-a8a0-a53c4844525b/e932447b5c2e854bcae25942a2113af2/dotnet-sdk-3.1.419-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51cfcaef-9d14-4fd3-a021-35e63232210c/ecc4f8c408034b505b2195dabb12653a/dotnet-sdk-3.1.419-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5dcee8cc-68e4-4b4f-8288-5ea8f95053ba/86c39872e9e206b9e103367de6b8f596/dotnet-sdk-3.1.419-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/338f2399-a9bd-42ec-9222-05890bd9cc6c/1aee26a2836eea457e937cd4087e2a04/dotnet-sdk-3.1.419-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2e8eaaf3-99c7-4c85-8453-a47907642495/a5e53dc81c5ffbd5341f84688e77b87b/dotnet-sdk-3.1.419-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6833f33e-7945-4ca3-995f-4c4339c52499/978faa82ec814695756ddfd16b93fe0b/dotnet-sdk-3.1.419-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/e928a702-bf60-4d0d-838b-64fe54daf7f4/e267c46904e47007d29ea31a15d304b7/dotnet-sdk-3.1.419-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5c201d4c-7d2e-4814-89ec-6c5ef533c5ce/1882c3649dd6d55f2b9fc9e906408528/dotnet-sdk-3.1.419-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e6252a07-fabd-4190-b1c7-e3ec2d9362ec/3eac33d83158b0a56e841c825f628f8d/dotnet-sdk-3.1.419-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7c051010-2618-4ccb-a9b0-9a8241f895e1/386db4cebfd34347bbef1c2d839bc62b/dotnet-sdk-3.1.419-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/626da701-eea5-44ce-86ef-7f95bb0f0369/8118a2c4badaa93f017e5bca4662b9ab/dotnet-sdk-3.1.419-win-x86.zip
