# .NET Core 3.1.27 - July 12, 2022

.NET Core 3.1.27 and .NET Core SDK 3.1.421 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.421
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.9 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.9 | [3.1.421](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.27 release carries reliability and non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7596](https://github.com/dotnet/core/issues/7596) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.27/3.1.27.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.27-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.27-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/july-2022-updates/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.27.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.27.nupkg
Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.27.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
Microsoft.NETCore.App.Host.linux-arm| 3.1.27.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.27.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Host.osx-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Host.win-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 3.1.27.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.27.nupkg
Microsoft.NETCore.App.Host.win-arm| 3.1.27.nupkg
Microsoft.NETCore.App.Host.win-x86| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.27.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 3.1.27.nupkg
Microsoft.NETCore.App.Host.win-arm64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 3.1.27.nupkg
Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.27.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.27.nupkg
Microsoft.NETCore.App.Host.linux-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.27.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 3.1.27.nupkg
Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.27.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 3.1.27.nupkg
Microsoft.AspNetCore.Components.Web| 3.1.27.nupkg
Microsoft.AspNetCore.DataProtection| 3.1.27.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.27.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.27.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.27.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.27.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.27.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.27.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.27.nupkg
dotnet-sql-cache| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.27.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.27.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 3.1.27.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.27.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 3.1.27.nupkg
Microsoft.AspNetCore.JsonPatch| 3.1.27.nupkg
Microsoft.AspNetCore.Mvc.Testing| 3.1.27.nupkg
Microsoft.AspNetCore.NodeServices| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.27.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.27.nupkg
Microsoft.Extensions.ApiDescription.Server| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.27.nupkg
AspNetCoreRuntime.3.1.x64| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.Google| 3.1.27.nupkg
Microsoft.AspNetCore.Components.Analyzers| 3.1.27.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.27.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.27.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.27.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 3.1.27.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.27.nupkg
Microsoft.AspNetCore.Metadata| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.27.nupkg
Microsoft.AspNetCore.TestHost| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.27.nupkg
AspNetCoreRuntime.3.1.x86| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.27.nupkg
Microsoft.AspNetCore.Components.Forms| 3.1.27.nupkg
Microsoft.AspNetCore.Identity.UI| 3.1.27.nupkg
Microsoft.AspNetCore.Owin| 3.1.27.nupkg
Microsoft.Extensions.ApiDescription.Client| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.27.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.27.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.27.nupkg
Microsoft.AspNetCore.Authorization| 3.1.27.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 3.1.27.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.27.nupkg
Microsoft.AspNetCore.HeaderPropagation| 3.1.27.nupkg
Microsoft.AspNetCore.Http.Features| 3.1.27.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.27.nupkg
Microsoft.AspNetCore.SpaServices| 3.1.27.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.27.nupkg
Microsoft.DotNet.Web.ItemTemplates| 3.1.27.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.27.nupkg
Microsoft.Extensions.Identity.Core| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.27.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.27.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.27.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.27.nupkg
Microsoft.AspNetCore.Components| 3.1.27.nupkg
Microsoft.AspNetCore.Components.Authorization| 3.1.27.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Client| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Common| 3.1.27.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.27.nupkg
Microsoft.dotnet-openapi| 3.1.27.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.27.nupkg
Microsoft.Extensions.Identity.Stores| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.27.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.27.nupkg
Microsoft.DotNet.Common.ItemTemplates| 3.1.27.nupkg
Microsoft.AspNetCore.Razor.Language| 3.1.27.nupkg
Microsoft.NET.Sdk.Razor| 3.1.27.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.27.nupkg
Microsoft.CodeAnalysis.Razor| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Relational| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Proxies| 3.1.27.nupkg
Microsoft.EntityFrameworkCore| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.27.nupkg
Microsoft.Data.Sqlite| 3.1.27.nupkg
Microsoft.Data.Sqlite.Core| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.InMemory| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Tools| 3.1.27.nupkg
dotnet-ef| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Design| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.27.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 3.1.27.nupkg
Microsoft.Extensions.Configuration.FileExtensions| 3.1.27.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.27.nupkg
Microsoft.Extensions.Configuration.Xml| 3.1.27.nupkg
Microsoft.Extensions.FileProviders.Embedded| 3.1.27.nupkg
Microsoft.Extensions.FileSystemGlobbing| 3.1.27.nupkg
Microsoft.Extensions.Http| 3.1.27.nupkg
Microsoft.Extensions.Logging.Debug| 3.1.27.nupkg
Microsoft.Extensions.Logging.TraceSource| 3.1.27.nupkg
Microsoft.Extensions.Options.DataAnnotations| 3.1.27.nupkg
Microsoft.Extensions.Primitives| 3.1.27.nupkg
Microsoft.Extensions.Configuration.Binder| 3.1.27.nupkg
Microsoft.Extensions.FileProviders.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Hosting.Systemd| 3.1.27.nupkg
Microsoft.Extensions.Localization| 3.1.27.nupkg
Microsoft.Extensions.Logging.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.ObjectPool| 3.1.27.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.27.nupkg
Microsoft.Extensions.Configuration| 3.1.27.nupkg
Microsoft.Extensions.Configuration.Json| 3.1.27.nupkg
Microsoft.Extensions.DiagnosticAdapter| 3.1.27.nupkg
Microsoft.Extensions.FileProviders.Physical| 3.1.27.nupkg
Microsoft.Extensions.Hosting.WindowsServices| 3.1.27.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.27.nupkg
Microsoft.JSInterop| 3.1.27.nupkg
Microsoft.Extensions.Configuration.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.27.nupkg
Microsoft.Extensions.Configuration.Ini| 3.1.27.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Logging.Console| 3.1.27.nupkg
Microsoft.Extensions.Logging.EventLog| 3.1.27.nupkg
Microsoft.Extensions.Caching.SqlServer| 3.1.27.nupkg
Microsoft.Extensions.Configuration.CommandLine| 3.1.27.nupkg
Microsoft.Extensions.DependencyInjection| 3.1.27.nupkg
Microsoft.Extensions.Logging| 3.1.27.nupkg
Microsoft.Extensions.Logging.Configuration| 3.1.27.nupkg
Microsoft.Extensions.Logging.EventSource| 3.1.27.nupkg
Microsoft.Extensions.Caching.Memory| 3.1.27.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.27.nupkg
Microsoft.Extensions.FileProviders.Composite| 3.1.27.nupkg
Microsoft.Extensions.Hosting| 3.1.27.nupkg
Microsoft.Extensions.Http.Polly| 3.1.27.nupkg
Microsoft.Extensions.Options| 3.1.27.nupkg
Microsoft.Extensions.WebEncoders| 3.1.27.nupkg
Microsoft.Extensions.Caching.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.27.nupkg
Microsoft.Extensions.Configuration.UserSecrets| 3.1.27.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.27.nupkg
Microsoft.Extensions.Hosting.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Localization.Abstractions| 3.1.27.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 3.1.27.nupkg

[//]: # ( Runtime 3.1.27)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/56641ffc-ee80-4d05-8733-fe59db86331f/d03b4b544471be6a93e96e2a94e10380/dotnet-runtime-3.1.27-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/176b2fbe-87b7-44cd-bbc5-b2d3f17cff6b/c9bfdf9048440f26ae9497e16f0afdcd/dotnet-runtime-3.1.27-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ba404c2-75e5-4149-84ed-b2291c39daaa/1b3e665f27b53ea5f6655515613cae86/dotnet-runtime-3.1.27-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c81651de-ca08-4a6f-9a27-135ec1196081/1b04ef0d6fc1dc5dcf98cd183d43f60e/dotnet-runtime-3.1.27-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26fcc6c4-0154-4b67-bfe0-85af31f06e7a/b17c38beb93d1642cc8f04d1f18908a4/dotnet-runtime-3.1.27-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6fd59baf-bbfa-4017-ac0f-5929b83a8fd3/04b1e1d38049c135426f2724fb11d837/dotnet-runtime-3.1.27-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/963cb9fe-b572-4564-8c72-69f76f5d60af/d20c13a367a68a9a7157267935e901fd/dotnet-runtime-3.1.27-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7b5a6188-d851-4ecb-b3f6-66147b7aba91/bebbbe83234cb428a026949bd771c830/dotnet-runtime-3.1.27-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/97686fcc-3dd0-4834-86d5-310d2e6e1853/47acefcb760b6747829f62b98322a9ff/dotnet-runtime-3.1.27-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c645644-6531-4cf4-99cc-a1817b23ecd7/1ecb1829d19a3e02f5d09864c68cd9c2/dotnet-runtime-3.1.27-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1e030d32-24fb-4d29-8184-9c2ee22d0d9f/a5f8421029c6631ee75fe1c23eff1134/dotnet-runtime-3.1.27-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c28fd175-b74b-4c46-81b3-a3b108551e8e/d36986389781e2667b7e04c2142f98f1/dotnet-runtime-3.1.27-win-x86.zip

[//]: # ( WindowsDesktop 3.1.27)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/60789643-4d4e-4770-8a8f-570a834c7ca5/1195f4b1ee94d16a107040a5ae511845/windowsdesktop-runtime-3.1.27-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6e16ee29-4486-4c4e-8090-2afd3b372532/f1643131475e45c9b6d1e064860cd93e/windowsdesktop-runtime-3.1.27-win-x86.exe

[//]: # ( ASP 3.1.27)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e40dcc5-1c7f-4df3-bbcd-e41fca511201/8e5995747aabbe0562cffa4300e3202c/aspnetcore-runtime-3.1.27-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9f87af5-813a-44f0-9c3b-133c386aad57/0440655cb7a8384f34fb450670ddffdd/aspnetcore-runtime-3.1.27-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa4ecc81-151c-44d2-b9fa-e971f97a29d3/9aa2adf78521114fd4a08ef8ff1903f3/aspnetcore-runtime-3.1.27-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d38bdc34-7a10-48af-8de5-a3434f572a9c/87e2d4f76e1a39a9c057fa7efbb4de2b/aspnetcore-runtime-3.1.27-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1d2cc21-97e0-45a6-8e56-419468d6029f/bd71225f2b7dad7dc44272d303276e7f/aspnetcore-runtime-3.1.27-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88aef7c5-da62-4f2a-abec-01ab93c0f369/1d0f82d981b6e4d2ff8a6a009a43cbc8/aspnetcore-runtime-3.1.27-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9cfef39b-cc0e-48c1-a471-921d1bb6699a/a733943c094cf71e6c3743788fc7a8bf/aspnetcore-runtime-3.1.27-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1d80895b-b1d7-43d5-b863-f2a485455bb1/a5c91169e0672abf1af72cffd22016c3/aspnetcore-runtime-3.1.27-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/08ddfe04-e817-4f3c-8acf-147e35a7a314/478bde18a9e48feddf4d3553175a6b2f/aspnetcore-runtime-3.1.27-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ac9a2c08-7104-4e28-b502-9847b3897f00/be15857aeee4e7e7e8b22ded4a468ec4/aspnetcore-runtime-3.1.27-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/714a06af-9597-4451-b7ec-28cbcfec309c/9547a75795611fb1bbc34275bd7c0be1/aspnetcore-runtime-3.1.27-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/f569cc3f-3f9e-4303-af34-026991fa7a7b/1f8fd7dc844fa422cbf6972fb26056f9/dotnet-hosting-3.1.27-win.exe

[//]: # ( SDK 3.1.421)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/564f08f3-230e-4476-8ebe-7e1f02dceae4/9da37442bde3f45300c65e9f71e1b24a/dotnet-sdk-3.1.421-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3aa1ef77-157e-4c54-bdc6-1cf589f3e3d1/590f24f95d808144bc18caa0c45b7d9f/dotnet-sdk-3.1.421-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06d65a7d-0809-4d05-b6b6-e51478cf5914/248f03bda444cafc8881f4d632fa487b/dotnet-sdk-3.1.421-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9de47381-6c20-4f80-a907-261d35f6157d/bab9b2f375d647e22a14251529328868/dotnet-sdk-3.1.421-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/554d7570-8f07-430b-8820-30e388b0e175/dfb532ec3c00082737b3621afa1b4b89/dotnet-sdk-3.1.421-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6b3a6c1a-17c7-4eb4-94ce-596eab8fe120/e4552bf7c2b80df104820530f69770bd/dotnet-sdk-3.1.421-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4fb4204-2b47-4459-875b-00a27a98c970/28d7b1a062bf85bc944fa403e96c5d73/dotnet-sdk-3.1.421-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/cb0bc11c-8d29-4ddd-b178-6ddef06f921f/1d31fe9c1ae411479ea4f0be39ff4bd9/dotnet-sdk-3.1.421-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7dd306b7-8f62-49cb-b8fc-a562cc6d1afe/612e47585185e30214d71a768bad0e8e/dotnet-sdk-3.1.421-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d0864a1f-ab8e-40f8-987c-03c8a997eb7f/2c1da5ba360d68be666e945005b5bc64/dotnet-sdk-3.1.421-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/49e06ca8-e7ce-41ad-b427-b1578e48818f/1cbb8b037ee3560c1c75941c56dbf6da/dotnet-sdk-3.1.421-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ab6d164b-0523-4436-a932-b5a0b612e5c2/0f689e78acbe0d0f6ca5e90d8a20f9f4/dotnet-sdk-3.1.421-win-x86.zip