# .NET Core 3.1.3 - March 24, 2020

[.NET Core 3.1.3](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.3 and .NET Core SDK 3.1.103.

* [Blog Roundup][dotnet-blog]
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#changes-in-313)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.103 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.103, the following command will show that you're running version `3.1.103` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4453](https://github.com/dotnet/core/issues/4453) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [ARM64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [ARM64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.4 | [3.1.103](#downloads) |
| Windows | Visual Studio 2019 version 16.5 | [3.1.201](3.1.201-download.md) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* [dotnet/core/samples](https://hub.docker.com/_/microsoft-dotnet-core-samples)
* [dotnet/aspnetcore](https://hub.docker.com/_/microsoft-dotnet-core-aspnet)

### Azure App Services

* .NET Core 3.1.3 is being deployed to Azure App Services and the deployment is expected to complete later in April 2020.


## Changes in 3.1.3

.NET Core 3.1.3 release carries only non-security fixes.

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.1.3+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.1.3+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.1.3+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:3.1.3+label:servicing-approved)

### macOS Notarization Change
  Running "dotnet build" will generate dll instead of binary on macOS. This is a planned change to not use the AppHost by default on macOS because of [notarization requirements](https://docs.microsoft.com/dotnet/core/install/macos-notarization-issues). If you want to opt into using the AppHost, please use following:
```
<PropertyGroup>
  <UseAppHost>true</UseAppHost>
</PropertyGroup>
```

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.3/3.1.3.md
[snap-install]: 3.1.3-install-instructions.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.3-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2020/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/



[//]: # ( Runtime 3.1.3)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c11e9248-404f-4e5b-bd99-175079419d6f/83902a43e06f9fb4e45a4c6a6d5afc0b/dotnet-runtime-3.1.3-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aec14e02-5c01-4447-b3f4-fa205b7c0603/7beea31e0c9faa20f5d692537cde54a5/dotnet-runtime-3.1.3-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93de0067-b54a-4fbe-ad70-4aa3b2fa675c/50387419d478163c7ecdc82d9769fd64/dotnet-runtime-3.1.3-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1229b766-b66b-478e-b49d-59c46e21cad9/0e9a1cf3c56ef85c8fff20abc6db780c/dotnet-runtime-3.1.3-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1d419e7-4312-4464-b272-27bee7676560/22e7bb584ff56f3089c85d98b21c0445/dotnet-runtime-3.1.3-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/482ac70d-c70d-4ec7-86d7-6842d20ca428/f7abefda6b8f210e77a3d25bf0433352/dotnet-runtime-3.1.3-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6adeeaf9-e591-4a3c-bc34-9cf3b7c60f9b/75826932f66a9afb6f6e2115ded1355b/dotnet-runtime-3.1.3-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78ce7c46-80c4-49f5-9ac1-8a79a6ee694f/c4200e8f91358db114f5ae5cd09f5347/dotnet-runtime-3.1.3-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/5f7470b1-553c-4c8d-8ed7-9d16dad93407/9175abdac90de477bbd658db7c3fd2d3/dotnet-runtime-3.1.3-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/945df1ae-989b-4909-9d40-6b93e34cfa94/91f6c347203ad24bed374bf692e3a379/dotnet-runtime-3.1.3-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f6387d06-5958-4935-ba28-183bb1f8ec7f/a9ccb4d10faec396135e6b967b7037da/dotnet-runtime-3.1.3-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9afebfd7-7719-4612-b15b-79b67b725b42/b93c5514f58eed2e66fc30d0e88aafcb/dotnet-runtime-3.1.3-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/19b0ea97-68b0-49e7-8d77-5d87f703f3d6/81d7c9b2fb74070fcaa0bf0e087c5486/dotnet-runtime-3.1.3-win-x86.zip

[//]: # ( WindowsDesktop )
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5954c748-86a1-4823-9e7d-d35f6039317a/169e82cbf6fdeb678c5558c5d0a83834/windowsdesktop-runtime-3.1.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7cd5c874-5d11-4e72-81f0-4a005d956708/0eb310169770c893407169fc3abaac4f/windowsdesktop-runtime-3.1.3-win-x86.exe

[//]: # ( ASP 3.1.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b68cde83-05c7-4421-ad9a-3e6f2cc53824/876dbfc9b4521d3ca89a226c6438ffc1/aspnetcore-runtime-3.1.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5c6e9d7-25b9-47ac-9d67-35ac65211ad3/c8f4ccd0dc02ca8229ba43ecbe84294b/aspnetcore-runtime-3.1.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53bc7d99-4ce8-4885-845d-19834a1bb3d7/26d4e527943258427809e107364ee237/aspnetcore-runtime-3.1.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf913e5d-120b-4404-8b63-6dafb01ec1b1/14c903afa12dbca00ff1a2b11ef2c0ce/aspnetcore-runtime-3.1.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7faca87b-7526-4dcd-ae23-4559d2c51ce3/7db1f314c733191ea43e1757e3b2583d/aspnetcore-runtime-3.1.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2ad068a-1e52-4e46-baa9-8fc4d52bb797/ee2c76d98fc124cfd6214030529412bc/aspnetcore-runtime-3.1.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/5df1edd1-4cf7-4b70-9f41-6196e655b53b/d5ce4462d55bcf74e3cf4fcc3984d4a5/aspnetcore-runtime-3.1.3-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b970ea4-cae6-4e36-a0a1-86a7efa9958e/0633df1e7f959795278c0c55afc2daa3/aspnetcore-runtime-3.1.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e47eda4e-2956-491a-a4c7-0ffa27b31be0/eb828ea191c5cc1c31be9f4dbbf32dec/aspnetcore-runtime-3.1.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/afec5ced-6298-4e54-add1-1d2e02d950f9/3a8064ac78eaf651c0030e8a96d4bd83/aspnetcore-runtime-3.1.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8741b459-2cdd-4fe5-b602-5dca5879a5f6/edef22b74f4ad080562d8be833a00efc/aspnetcore-runtime-3.1.3-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ff658e5a-c017-4a63-9ffe-e53865963848/15875eef1f0b8e25974846e4a4518135/dotnet-hosting-3.1.3-win.exe

[//]: # ( SDK 3.1.103 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7eb8b77b-e7e9-44ea-8a4e-e560ef639958/ee3565807f13ea0cf62e7a6bd8a58221/dotnet-sdk-3.1.103-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2231ea64-1835-4e2f-bcff-f611bd803786/3e492dc64e6c3e6ca977e1e2abace10a/dotnet-sdk-3.1.103-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96f425ef-7b6e-4bfc-87f5-c2fd9516e878/ed017cdd38dd233fec13dd0567417d39/dotnet-sdk-3.1.103-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4acde034-669e-4d98-86ac-6214ebb36ff9/7e3cf7e4c323840c49ad7c3e4e2c7755/dotnet-sdk-3.1.103-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d200c4ea-dc59-43d7-80f4-04d277c3c60b/ecf4c1b9c84f1ee887afbdf02ea60c3f/dotnet-sdk-3.1.103-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22dff1c7-ed29-4b69-8191-18563bfed550/441fb1596f0be0582d417a3af6604855/dotnet-sdk-3.1.103-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e59d0df5-a4d2-4726-9f4d-3d301c377441/c8592b2dc1b2ec9d2d05d1fd2814e9e8/dotnet-sdk-3.1.103-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/263590b0-667b-4e22-8c84-88af71296092/8390c4375fbfe49b09daf85aeed9fcda/dotnet-sdk-3.1.103-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2e20b6fb-d05b-4dbc-bda1-5be5cba9e759/32bbf60d86a169acd5864b856e977ede/dotnet-sdk-3.1.103-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d880d085-20e5-4216-96b2-78d06252ce89/82c04dd312a40541d1311028a97e5cc1/dotnet-sdk-3.1.103-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/44a6238f-4e36-4aba-885f-18052df89b7f/07750e35430fe24b13811ba3350b6e7f/dotnet-sdk-3.1.103-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9e845978-0626-4b95-937b-4ee0f1d3c5a8/977226d5e43baaf88c8d85a981b40c58/dotnet-sdk-3.1.103-win-x86.zip

[//]: # ( Symbols )
