# .NET Core 3.1.0 Preview 2 - November 04, 2019

[.NET Core 3.1.0 Preview 2](https://dotnet.microsoft.com/download/dotnet/3.1) is available for download and usage in your environment. This release includes .NET Core 3.1.0 Preview 2 and .NET Core SDK 3.1.100 Preview 2.

* [Blog Roundup](#blog-roundup)
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.1)
* [Changes in this release](#notable-changes-in-310-preview-2)
* [Known issues](../3.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

The .NET Core SDK 3.1.100 Preview 2 includes .NET Core 3.1 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.1.100 preview, the following command will show that you're running version `3.1.100-preview2-014569` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #3744](https://github.com/dotnet/core/issues/3744) for your questions and comments.

## Blog Roundup

* [.NET Core 3.1 Preview 2][dotnet-blog]
* [ASP.NET Core][aspnet-blog]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 Preview 2 requires Visual Studio 2019 16.4 Preview 3 to take full advantage of all its features. .NET Core 3.1 Preview 2 will not work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

**Known Issue:** Visual Studio 16.4 Preview 3 may uninstall .NET Core 3.0 when installed the .NET Core 3.1 SDK. We recommend you re-install or repair the [.NET Core 3.0 SDK](https://dotnet.microsoft.com/download/dotnet/3.0) if this happens. 


## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)

## Notable Changes in 3.1.0 Preview 2

Here is list of some of the additions and updates we're excited to bring in Preview 2. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* CoreCLR: [bugs][coreclr_bugs] | [features][coreclr_features]
* CoreFX: [bugs][corefx_bugs] | [features][corefx_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/preview/3.1.0-preview2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md
[snap-install]: 3.1.0-preview2-install-instructions.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1-preview-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1-preview-2/

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview2+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.1+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement

[//]: # ( Runtime 3.1.0-preview2.19525.6)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/c89f2d8a-f497-4ec6-b5f1-358b3e2432a7/b182d8bdacb2b88451da0a47ce4a18bc/dotnet-apphost-pack-3.1.0-preview2.19525.6-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f0012aef-9283-4326-aa51-c658f2df684c/1925c15e8d2f6f732287564b2fbb2608/dotnet-apphost-pack-3.1.0-preview2.19525.6-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/a03d8cd1-6b91-4cb5-81d5-45adf65aec77/dcedc51936441038ded0ade8a31ad56e/dotnet-host-3.1.0-preview2.19525.6-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/30a7810b-cb7f-4377-9e46-9db875637699/2dd0afd204dc43f42ded34565640cc11/dotnet-host-3.1.0-preview2.19525.6-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/f344a3ff-4519-4aa0-be3b-16e894666fb3/1ab085b1ee75b1ba95a714ac2b67e8fb/dotnet-hostfxr-3.1.0-preview2.19525.6-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/174f777c-bbc1-409a-b51e-c0d2250d0a79/46a625142acc9d2d0bd0f13acfea3d1d/dotnet-hostfxr-3.1.0-preview2.19525.6-x64.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7e27e2a5-9ede-4a0b-8387-a5c44fd8b50a/985a970be392d1bb4cdebc844e32ee13/dotnet-hosting-3.1.0-preview2.19528.8-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37515e6a-0a74-4390-88d5-9ea9652ea78a/f55d1e68fb7b54c4a29064e790c08e82/dotnet-runtime-3.1.0-preview2.19525.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45ef007b-3673-45d7-9469-174f2803bfaa/fddebc8ec9f6f97d8d817d8ac8cbe40c/dotnet-runtime-3.1.0-preview2.19525.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad8f0d23-e460-4532-9a96-a9a0ff30c9e4/48d5ba07a631f826883251aaff052641/dotnet-runtime-3.1.0-preview2.19525.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19c96f8a-ffd4-4ccb-8782-593a554a9e27/76af54284b02822f3a51dcb00ce047ef/dotnet-runtime-3.1.0-preview2.19525.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5e2601a0-098a-465e-af04-c1e5f89edac4/5def2619786cb2d4c885c6750024e814/dotnet-runtime-3.1.0-preview2.19525.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95ab461f-cad7-4202-a99f-29d06be271db/8ee8ef495930c1830474144c9cbe8425/dotnet-runtime-3.1.0-preview2.19525.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5ef32ef-be96-4dea-bd86-977ec45bd159/9084385ee5ba825fb55996e5a61309c8/dotnet-runtime-3.1.0-preview2.19525.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a24b85c2-27c4-4418-aa2e-a9a27d4e6a79/a047506706c3ca50792103649cda18a2/dotnet-runtime-3.1.0-preview2.19525.6-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5edf195b-e862-4d1a-be83-0647d1221103/ad679931c06ddda5411def5d5ca48f0c/dotnet-runtime-3.1.0-preview2.19525.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/66a6f4c9-6674-486d-9cca-579525f65ffb/ea8fce75c79f984de5f0e89589484ca7/dotnet-runtime-3.1.0-preview2.19525.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3f750d63-dc32-4f9f-9627-5ed761b2bfe5/dbf2228783a84a76ac3604ad04c49afe/dotnet-runtime-3.1.0-preview2.19525.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6079aca0-1ee6-4e2c-a85f-285357ef8a83/7799fcc2d19f9d1cb486e054f5306f9f/dotnet-runtime-3.1.0-preview2.19525.6-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/d2a3a991-4175-453a-a3c8-01e21b2d08a8/41829ba3b2aaf146e843e428bcc4dc3e/dotnet-runtime-3.1.0-preview2.19525.6-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/17b70fd0-2b1f-4448-a4d5-28efe7fe115b/c975d2870e091e3fd334d36fe218180c/dotnet-runtime-3.1.0-preview2.19525.6-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/88f18c17-7815-4fb8-aefc-c6e567fc7b9e/75a4b6d00fbc1a5d4307f95457dbe9b8/dotnet-runtime-deps-3.1.0-preview2.19525.6-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/fcddfef8-5c64-4387-ba91-9f94d092f910/d70dab38f6fdb5781c7d08543e5eee9e/dotnet-runtime-deps-3.1.0-preview2.19525.6-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/60253eb5-b7e8-4a1b-9cb5-f424603dd96c/95e6725c4980fb8f19d13a5183f12f7a/dotnet-runtime-deps-3.1.0-preview2.19525.6-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f8bfa870-7cd7-49aa-b85f-dd5359285cc4/6cdf74017f6402f94aad47429f3d87b6/dotnet-runtime-deps-3.1.0-preview2.19525.6-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6f6e23f0-3d48-41cc-a977-7e91acbbc8e1/78799710edd4a56dd80c166539bb5eeb/dotnet-runtime-deps-3.1.0-preview2.19525.6-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/26c7d181-9bfd-43ba-a297-7d260ba0b8a9/fbc2f829514fff10489085aaedec5c1e/dotnet-runtime-deps-3.1.0-preview2.19525.6-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/282788e7-dda0-49f2-8d29-b54f9ae92af6/15e2cc96574eb2963bee348161db3840/dotnet-runtime-deps-3.1.0-preview2.19525.6-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e98a8229-3c08-4f4e-9247-ce4de55df975/6049dc87c9657c820923001d6babf009/dotnet-targeting-pack-3.1.0-preview2.19525.6-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c7174696-7241-4e17-bd21-7028ae4b59a8/e32568277bb3d11d66fd331f7a9b7be0/dotnet-targeting-pack-3.1.0-preview2.19525.6-x64.rpm
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/167f2f9d-1b1b-4e44-b4a8-1518efe764d6/877eeeae2a0c9c7159647759c526f715/windowsdesktop-runtime-3.1.0-preview2.19525.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/19160e04-1d89-4e01-b865-170d7f0371e8/56268af21bd84934ef1d6def63417d68/windowsdesktop-runtime-3.1.0-preview2.19525.6-win-x86.exe

[//]: # ( ASP 3.1.0-preview2.19528.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6859fb0b-f745-4bbc-80b3-8519e91c0211/b09fddb1bd63a59b533153479088705e/aspnetcore-runtime-3.1.0-preview2.19528.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8082a589-b816-43b7-ba26-bce339fd5436/d0e5a63b767e25971ac34a3ce712dd23/aspnetcore-runtime-3.1.0-preview2.19528.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f112318-fc61-4405-b616-ab6e3fef5154/f53918791c9b420d21e85599f6ac3a0b/aspnetcore-runtime-3.1.0-preview2.19528.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/476a6956-9b31-43f6-bc06-e43e090c1d29/2ffe100cd8c6f4a8793745fbd0fdeb20/aspnetcore-runtime-3.1.0-preview2.19528.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/465714e1-48dd-4ff6-a2b7-d6331794dcb3/73a41666ca7fbe330a15efecda4509ef/aspnetcore-runtime-3.1.0-preview2.19528.8-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/01d88959-f68a-47b8-b794-e0a37c243d33/5b70fd1e82ea0a84eba68b11433fd2c8/aspnetcore-runtime-3.1.0-preview2.19528.8-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8f101640-ad24-4c6e-be85-7a68541421a9/eca46cf2c648012ebf8461fc1a351631/aspnetcore-runtime-3.1.0-preview2.19528.8-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/10e9645f-408b-42d9-84d2-0385dc5b9d8e/4dfe73622c27826403f4349e0f2f1edf/aspnetcore-runtime-3.1.0-preview2.19528.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/94ad3071-868a-47c5-8b45-0c9ce3a1cffb/0a775d3601b136441534e00a4ad3ce90/aspnetcore-runtime-3.1.0-preview2.19528.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a456b549-a42d-462b-ad54-fbd2765b76cc/e351aa362d2cb2d43c8f463c2b48d8c6/aspnetcore-runtime-3.1.0-preview2.19528.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eda223c6-3c79-46fb-b699-5cb83ecbdf68/82f5dc0ef1bd661879bd638d61851e70/aspnetcore-runtime-3.1.0-preview2.19528.8-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/2869dc17-197d-4f5c-8b7f-402c92cf404e/26a7890b01c30893fb5e6940bc6fcd48/aspnetcore-runtime-3.1.0-preview2.19528.8-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f9d561b6-ad0d-4b1a-be2b-052584f00520/aa7fe52c5c4768857fdefff4bcdc2807/aspnetcore-runtime-3.1.0-preview2.19528.8-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/64dd71ba-dd50-445f-9b01-f6d21219269f/428c006b31a04c598ee8b0a5b1651c1c/aspnetcore-targeting-pack-3.1.0-preview2.19528.8.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/d963de53-0890-4eef-87c5-ef7213ff53d9/8e6a88a7f70da92544e361268ed54afe/aspnetcore-targeting-pack-3.1.0-preview2.19528.8.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7e27e2a5-9ede-4a0b-8387-a5c44fd8b50a/985a970be392d1bb4cdebc844e32ee13/dotnet-hosting-3.1.0-preview2.19528.8-win.exe

[//]: # ( SDK 3.1.100-preview2-014569 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5bfd9b63-28f6-4f3d-a6e4-7f0484c45676/10bb6e66dbf26be198adf757fdeecdb1/dotnet-sdk-3.1.100-preview2-014569-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8ddbc47-4fe0-4a92-897a-38e6f7ca8e05/6288d9250287b56214179afb984bd947/dotnet-sdk-3.1.100-preview2-014569-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2215959a-9da2-470c-9c85-ae254cf4c189/d6631389adb5c4ca23a2cdfff0feec2f/dotnet-sdk-3.1.100-preview2-014569-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cea4281b-84fa-428a-a73a-f0c3b89a9590/249ddf191b2dd37c4a53ac3bc383ec8a/dotnet-sdk-3.1.100-preview2-014569-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c1173b3e-3a33-43eb-b58b-95746bd185e2/d5bd9faa976ded5ff5a7b213ab04ea3c/dotnet-sdk-3.1.100-preview2-014569-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10849a7b-0617-49c9-96a2-d5b342648605/ec035ba49342820c1a47485ce325f51c/dotnet-sdk-3.1.100-preview2-014569-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bd36fba6-f0e1-43ce-94a5-429c471f5abb/4cd685437d2443bf81a92de43d8719cb/dotnet-sdk-3.1.100-preview2-014569-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/168a3f42-9e80-44d2-a11d-c673ed4ceb94/1d93750f031ee560dc9ec7b04ce52cf6/dotnet-sdk-3.1.100-preview2-014569-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5099acf7-57e9-4587-b1df-452c39d078bb/2b48609f08a05ddf0cde1eb405a306e0/dotnet-sdk-3.1.100-preview2-014569-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ed1ec86a-b4e2-4ab1-9b3d-05ca4dfb84a7/77a64d861398884947add508f3d5b735/dotnet-sdk-3.1.100-preview2-014569-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9a9ab60e-75f4-44a3-bdc3-21de80fe27d6/7fcf311ce316542af827015e5457b6b9/dotnet-sdk-3.1.100-preview2-014569-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/76f5f5b5-3ea9-49be-bd92-566e9a61375f/39cbfd29696a1d79e894f57812e8a438/dotnet-sdk-3.1.100-preview2-014569-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/0ce05952-110b-476e-86d6-14707cec0c76/cab1597c6fbfb6395202d92ac77108d6/dotnet-sdk-3.1.100-preview2-014569-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c648b18a-652c-457c-ae2e-7e1694ce836b/14071cdedf699aa813186a03da93c9c9/dotnet-sdk-3.1.100-preview2-014569-x64.rpm
