# .NET 5.0.10 - September 14, 2021

The .NET 5.0.10, .NET 5.0.401 SDK  and [.NET SDK 5.0.207](5.0.207.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm32][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.401
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.10 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/pulls?q=milestone%3A5.0.10+is%3Aclosed+label%3Aservicing-approved)
* [WindowsDesktop](https://github.com/dotnet/windowsdesktop/pulls?q=milestone%3A5.0.10+is%3Aclosed+label%3Aservicing-approved)
* [Arcade](https://github.com/dotnet/arcade/pulls?q=milestone%3A5.0.10+is%3Aclosed+label%3Aservicing-approved)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6687](https://github.com/dotnet/core/issues/6687) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.10.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.10-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.10-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/september-2021-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.10xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.10.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.10.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.10.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.10.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.10.nupkg
Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.10.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.10.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.10.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
Microsoft.NETCore.Platforms | 5.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.10.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.10.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.10.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.10.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.10.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.10.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.10.nupkg
Microsoft.Extensions.ObjectPool | 5.0.10.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.10.nupkg
Microsoft.Extensions.Identity.Core | 5.0.10.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.10.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.10.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.10.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.10.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.10.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.10.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.10.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.10.nupkg
dotnet-sql-cache | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.10.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.10.nupkg
Microsoft.dotnet-openapi | 5.0.10.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.10.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.10.nupkg
Microsoft.JSInterop | 5.0.10.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.10.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.10.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.10.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.10.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.10.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.10.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.10.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.10.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.10.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.10.nupkg
Microsoft.AspNetCore.Authorization | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.10.nupkg
Microsoft.AspNetCore.TestHost | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.10.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.10.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.10.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.10.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.10.nupkg
Microsoft.AspNetCore.Components | 5.0.10.nupkg
Microsoft.AspNetCore.Owin | 5.0.10.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.10.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.10.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.10.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.10.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.10.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.10.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.10.nupkg
Microsoft.Extensions.WebEncoders | 5.0.10.nupkg
Microsoft.Extensions.Localization | 5.0.10.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.10.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.10.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.10.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.10.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.10.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.10.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.10.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.10.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.10.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.10.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.10.nupkg
Microsoft.AspNetCore.Metadata | 5.0.10.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.10.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.10.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.10.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.10.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.10.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.10.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.10.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.10.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.10.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.10.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.10.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.10.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.10.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.10.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.10.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.10.nupkg
Microsoft.EntityFrameworkCore | 5.0.10.nupkg
Microsoft.Data.Sqlite | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.10.nupkg
dotnet-ef | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.10.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.10.nupkg
Microsoft.Data.Sqlite.Core | 5.0.10.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Edge | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateSearch.Common | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Utils | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.401-servicing.21404.12.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.Core | 5.0.401-servicing.21404.12.nupkg
Microsoft.TemplateEngine.IDE | 5.0.401-servicing.21404.12.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.10.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.10.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.10.nupkg


[//]: # ( Runtime 5.0.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/142ca547-55c2-4b0e-946c-dc30c555fc50/b26a3a9218f49a913c749dc6eb493ab9/dotnet-runtime-5.0.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99d1c6f0-ab17-42aa-834b-a54aa112bd3f/fdb07756e0ba625a60697f208950817e/dotnet-runtime-5.0.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2f1bce6-0d63-48a0-82f0-cb72982e2dc1/21770b33bea847a4c7d6c53ff814d666/dotnet-runtime-5.0.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f1511ac-61e2-40e5-8030-7493c1b0a4b2/f405a7bac235b73fd544ab492641187a/dotnet-runtime-5.0.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f1e3cb9-cdf2-4adc-bcc3-31cd52481b08/ffb85bc6b87dc70765de2f66e061be1a/dotnet-runtime-5.0.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bb93b65-658d-4c6c-b4e2-32ec2a3d8aa6/ca3a11e65bcbc6dbb30330a54fcc1059/dotnet-runtime-5.0.10-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0a1577a6-a7f1-4da0-ae64-9003ff8badb5/3b3a9291a0bdcb5591afab9e842272db/dotnet-runtime-5.0.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7358d713-f1f5-40c3-877d-1181bad92414/0a92ccada1f5ec96b99458def5ea354e/dotnet-runtime-5.0.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3a90bf5-65ed-4941-8429-5af6f0498510/700f817199c527d68f9348cbf87840e3/dotnet-runtime-5.0.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/75aa56a0-41af-471b-8f52-10effacf4a57/dfab419662069806eab1d8e0df11890d/dotnet-runtime-5.0.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9f93e474-1bad-4c66-8445-57a2ef6983d6/b49e4837fc4851a0c85da41d70495c13/dotnet-runtime-5.0.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e285f4d2-03b3-44b3-960c-4897d24b36a6/3e2458ba37e913aad84394253c0a50da/dotnet-runtime-5.0.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c28d0535-cb4c-45f7-a709-7fe5ead90735/a266d0f95f4fe11e2da4afd7b5353009/dotnet-runtime-5.0.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/95a92e1e-b378-4427-9830-8d5acaffeec4/27e8325097b16ff5b8e9846b7a289cc3/dotnet-runtime-5.0.10-win-x86.zip

[//]: # ( WindowsDesktop 5.0.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/20b2a5e9-2a9d-4856-be13-198b58121829/7d46975c9facb1e185d9b26b690f4f23/windowsdesktop-runtime-5.0.10-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/78fa839b-2d86-4ece-9d97-5b9fe6fb66fa/10d406c0d247470daa80691d3b3460a6/windowsdesktop-runtime-5.0.10-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7ed142ef-5738-4eea-bdd3-9210c5dd4973/ce3d680c487b178a828c5c3edd9ec685/windowsdesktop-runtime-5.0.10-win-x86.exe

[//]: # ( ASP 5.0.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7155f514-7899-4fc8-98ea-9f08f75b5523/348df0133f0ba0b81f5f984d6c55b748/aspnetcore-runtime-5.0.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ce6cf91-6aff-4565-87df-d20212418009/e3a924fa1192637dcd7379c1109e14e0/aspnetcore-runtime-5.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89fcfe21-7239-483c-bcfb-61057afec532/63a73333fbb69159ade943f104cfc363/aspnetcore-runtime-5.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5dc73750-ff87-4882-85aa-fed91b5cdaf7/4741c00ddbe1cc4c17e29878c0cd2aa5/aspnetcore-runtime-5.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a256de3f-b516-437f-a480-d66499a84aad/0fe47b7f0eee95bfaa5c6515ae0dd893/aspnetcore-runtime-5.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20984ce7-f18d-414a-9a16-bf05cd0cc7a1/ca5ab821884e7e3b3b4febf9f7a4b50e/aspnetcore-runtime-5.0.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd84e4c7-8267-4b4e-843e-f25a01dfbe15/1191a8b6422be4390b47cef54fba8790/aspnetcore-runtime-5.0.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ab961f8e-14c4-41ce-af2f-864fb8aa83ff/86f460a0c4c2071d9c4307f9b56d92c1/aspnetcore-runtime-5.0.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/69a4b292-6680-46b6-a067-eaf5b4a7ed1e/a14fa32031441812288c113bee953c8d/aspnetcore-runtime-5.0.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0db94a33-1682-4f52-b935-cb4c28c11b6b/74528bafc65548a82a9ece361d8a8262/aspnetcore-runtime-5.0.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1ddcc549-d626-4cda-bf0d-0b9f5571db0c/14dfffdcb7cd11f7001fccf6a4a54de2/aspnetcore-runtime-5.0.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/65c29806-52ef-4f27-8dc2-20fbd2275638/5ea07dd6d765f21f19caf58153a64b56/aspnetcore-runtime-5.0.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a0da9621-68f0-439a-b617-4697ee0669e3/38eb4aa6e879b9f06b73599ea2e1535f/dotnet-hosting-5.0.10-win.exe

[//]: # ( SDK 5.0.401)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce3cef63-ade6-4209-80f0-ac2815c5b282/e4a8b52aacf74d2a7d6d1cf5b9dca438/dotnet-sdk-5.0.401-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3795feca-e61d-4339-86a7-5e95aca2ad87/74300efb89e6664122f1f48c2beff734/dotnet-sdk-5.0.401-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78968187-5707-4b05-850a-00f914fc4a23/8d0abf2a642d7a7d2d66bf63522bf041/dotnet-sdk-5.0.401-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/01506271-784b-4865-a330-cfb0ff2735e4/7579379d352525b933b1270ae337fa97/dotnet-sdk-5.0.401-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a80a3834-c8a1-4012-b7d9-a3a5a1e4ba30/29e11d1acb7595d79ce48a5f1fb33c82/dotnet-sdk-5.0.401-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5972698f-ba44-4664-9c50-bdc69ca70fb7/1cf7d94425d8dd4d5789dfa978d61475/dotnet-sdk-5.0.401-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/01319962-2062-4c49-a28c-70b3748eba28/245475bc51c8b2f85d9b983ca56bb9f9/dotnet-sdk-5.0.401-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/846d5680-b804-4903-8d8d-255804bcfaeb/436101afc96998f75efb452f5ded3c1a/dotnet-sdk-5.0.401-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fe7149d-feaa-44c6-8a7e-a9cfc42b461f/93fdf8bbf05fc293a05abad93c717897/dotnet-sdk-5.0.401-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/96749964-676b-4737-a84d-2ef787f90137/9ea15b5a45c03b81002640f07fd0e8e0/dotnet-sdk-5.0.401-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/06e2d84d-963f-448a-bea4-c3f6c4145238/a9d0f10dffeba1e3a57916bf9b75ffa1/dotnet-sdk-5.0.401-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aa5eedba-8906-4e2b-96f8-1b4f06187460/e6757becd35f67b0897bcdda44baec93/dotnet-sdk-5.0.401-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7bb2b576-f96c-465d-80bf-0a3956e75f4c/4ba1f2657ac6eb4b725284028c4f8707/dotnet-sdk-5.0.401-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/98bdadc3-4512-4bc8-b3c7-1a0fb4fd633b/4278eeba61b580022fbb5eeaa5110cdb/dotnet-sdk-5.0.401-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/29a26d1c-d339-46ac-8498-1e8b47b5a019/519e114dd058dc59bbb4cd129348abbf/dotnet-sdk-5.0.401-win-x86.zip

