# .NET 5.0.15 - March 8, 2022

The .NET 5.0.15, .NET 5.0.406 SDK  and [.NET SDK 5.0.212](5.0.212.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.406
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Windows SDK Updates

.NET SDK 5.0.212 and 5.0.406 include performance improvements to the Windows SDK packages that provide access to Windows Runtime APIs. For more details, see the [C#/WinRT 1.5.0 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.5.0.220207.5).

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.15 release carries security fixes.

# Microsoft Security Advisory CVE-2022-24464 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a Denial of Service vulnerability, which exists in .NET 6.0, .NET 5.0, and .NET Core 3.1 when parsing certain types of http form requests.

# Microsoft Security Advisory CVE-2022-24512 | .NET Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0, and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Remote Code Execution vulnerability exists in .NET 6.0, .NET 5.0, and .NET CORE 3.1 where a stack buffer overrun occurs in .NET Double Parse routine.

# Microsoft Security Advisory CVE-2020-8927 | .NET Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 5.0 and .NET Core 3.1 where a buffer overflow exists in the Brotli library versions prior to 1.0.8.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

Release feature and bug lists:
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A5.0.15+is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7259](https://github.com/dotnet/core/issues/7259) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.15.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.15-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.15-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2022-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.15xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
 Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.15.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.15.nupkg
 Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.15.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.15.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.15.nupkg
 Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.win-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.15.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.win-x64 | 5.0.15.nupkg
 Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.15.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.win-arm | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.osx-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.win-arm | 5.0.15.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.15.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 System.IO.Pipelines.| 5.0.2.nupkg
 Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.win-x86 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.15.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.15.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.win-x86 | 5.0.15.nupkg
 runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-arm | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-arm | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Host.win-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.15.nupkg
 runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.15.nupkg
 runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.15.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.15.nupkg
 runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.15.nupkg
 Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.15.nupkg
 AspNetCoreRuntime.5.0.x64 | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.Facebook | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.15.nupkg
 Microsoft.AspNetCore.SpaServices.Extensions | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.15.nupkg
 Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.15.nupkg
 Microsoft.DotNet.Web.ItemTemplates | 5.0.15.nupkg
 Microsoft.Extensions.FileProviders.Embedded | 5.0.15.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.15.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.Google | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Common | 5.0.15.nupkg
 Microsoft.Extensions.ApiDescription.Client | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.15.nupkg
 Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.15.nupkg
 Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.15.nupkg
 Microsoft.AspNetCore.DataProtection.Extensions | 5.0.15.nupkg
 Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.15.nupkg
 Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.15.nupkg
 Microsoft.AspNetCore.Identity.UI | 5.0.15.nupkg
 Microsoft.AspNetCore.JsonPatch | 5.0.15.nupkg
 Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.Negotiate | 5.0.15.nupkg
 Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.15.nupkg
 Microsoft.JSInterop.WebAssembly | 5.0.15.nupkg
 Microsoft.Extensions.WebEncoders | 5.0.15.nupkg
 Microsoft.Extensions.Localization | 5.0.15.nupkg
 Microsoft.Extensions.ApiDescription.Server | 5.0.15.nupkg
 Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.15.nupkg
 Microsoft.AspNetCore.Owin | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.15.nupkg
 Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.15.nupkg
 Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.15.nupkg
 Microsoft.AspNetCore.Cryptography.Internal | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.Analyzers | 5.0.15.nupkg
 Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.15.nupkg
 Microsoft.AspNetCore.Authorization | 5.0.15.nupkg
 Microsoft.AspNetCore.Mvc.Testing | 5.0.15.nupkg
 Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.15.nupkg
 Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.15.nupkg
 Microsoft.AspNetCore.Metadata | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.15.nupkg
 Microsoft.AspNetCore.Http.Connections.Client | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.Certificate | 5.0.15.nupkg
 Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.15.nupkg
 dotnet-sql-cache | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.15.nupkg
 Microsoft.AspNetCore.DataProtection | 5.0.15.nupkg
 Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.15.nupkg
 Microsoft.AspNetCore.Http.Features | 5.0.15.nupkg
 Microsoft.AspNetCore.Http.Connections.Common | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.15.nupkg
 AspNetCoreRuntime.5.0.x86 | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.WsFederation | 5.0.15.nupkg
 Microsoft.AspNetCore.HeaderPropagation | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.15.nupkg
 Microsoft.AspNetCore.TestHost | 5.0.15.nupkg
 Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.WebAssembly | 5.0.15.nupkg
 Microsoft.AspNetCore.Components | 5.0.15.nupkg
 Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.15.nupkg
 Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.15.nupkg
 Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.15.nupkg
 Microsoft.CodeAnalysis.Razor | 5.0.15.nupkg
 Microsoft.Authentication.WebAssembly.Msal | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Client.Core | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.Client | 5.0.15.nupkg
 Microsoft.AspNetCore.Authentication.Twitter | 5.0.15.nupkg
 Microsoft.JSInterop | 5.0.15.nupkg
 Microsoft.Extensions.ObjectPool | 5.0.15.nupkg
 Microsoft.Extensions.Logging.AzureAppServices | 5.0.15.nupkg
 Microsoft.Extensions.Identity.Stores | 5.0.15.nupkg
 Microsoft.Extensions.Configuration.KeyPerFile | 5.0.15.nupkg
 Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.15.nupkg
 Microsoft.AspNetCore.Connections.Abstractions | 5.0.15.nupkg
 Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.15.nupkg
 Microsoft.dotnet-openapi | 5.0.15.nupkg
 Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.15.nupkg
 Microsoft.AspNetCore.Razor.Language | 5.0.15.nupkg
 Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.15.nupkg
 Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.15.nupkg
 Microsoft.Extensions.Localization.Abstractions | 5.0.15.nupkg
 Microsoft.Extensions.Identity.Core | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.Web | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.Forms | 5.0.15.nupkg
 Microsoft.AspNetCore.Components.Authorization | 5.0.15.nupkg
 Microsoft.AspNetCore.Identity.Specification.Tests | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Tools | 5.0.15.nupkg
 Microsoft.Data.Sqlite.Core | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.SqlServer | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Design | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Cosmos | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Analyzers | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.15.nupkg
 dotnet-ef | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.15.nupkg
 Microsoft.Data.Sqlite | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Abstractions | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Sqlite | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Relational | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.InMemory | 5.0.15.nupkg
 Microsoft.EntityFrameworkCore.Proxies | 5.0.15.nupkg




[//]: # ( Runtime 5.0.15)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7ee90c8-c54f-4793-a405-1050f365240c/ecc2da4c6d4b3e6611bda5e5a5bda9af/dotnet-runtime-5.0.15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28ff2ede-6f43-4486-b2ad-dd2bde9ea2f7/9267ee1e9941196b8d45c162fa1bcb5d/dotnet-runtime-5.0.15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c892c25d-1613-4569-bab0-a96702a1f39e/d083c3164e21f0f234eac60e07137e72/dotnet-runtime-5.0.15-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7698b563-f440-44c7-b959-b65e4ebc9cc6/701c84aa012c063072283a4d6bdda6aa/dotnet-runtime-5.0.15-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd5ec323-893c-4dd2-848a-b6c9559ae178/204ed4d65b9eade19ea74f982e8388ae/dotnet-runtime-5.0.15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/546d50b2-d85c-433f-b13b-b896f1bc1916/17d7bbb674bf67c3d490489b20a437b7/dotnet-runtime-5.0.15-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/aae7783c-c033-4308-ab45-7edf78d8945b/bef03269b50362c36a56a6f21693dd26/dotnet-runtime-5.0.15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb5d4972-5eb6-4e53-b422-86eae8d0162f/3fc69c296fad1c9867ce7873c1d90e8c/dotnet-runtime-5.0.15-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3e2738f0-0bc5-40ff-b0e0-52830cce27f3/06352486fb5dbc29703be3766f87e849/dotnet-runtime-5.0.15-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a17bbc0d-2f4a-4237-98e7-c994ddf1b23e/f4599fc0d88e8831a706849b638e9d02/dotnet-runtime-5.0.15-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/744a5a4b-c931-4365-9762-5154e999af13/51553f5bfe24e1f7d54abbfbb94d0c4c/dotnet-runtime-5.0.15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/188c7f17-73ca-477d-96a5-5bcb0970e751/71cc137bec1df3a712ce04fe92aa78dd/dotnet-runtime-5.0.15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5a3bc200-475f-46df-9e80-6955c5fa191d/d49c018dbb28af1182655cbed7abd620/dotnet-runtime-5.0.15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8d7983ed-db89-4247-b7e7-151fcbbfa18e/e34058f89799307e3c60771722b23a4d/dotnet-runtime-5.0.15-win-x86.zip

[//]: # ( WindowsDesktop 5.0.15)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/40bf47cb-146b-479f-a660-a85c1c9c469d/96f8b74576dd57d65e1726c48e61734d/windowsdesktop-runtime-5.0.15-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b1902c77-e022-4b3e-a01a-e8830df936ff/09d0957435bf8c37eae11b4962d4221b/windowsdesktop-runtime-5.0.15-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/51b9e073-e0db-4c82-bdb8-47a9c39896e2/d676baa1bbb643f50c6b41ca64110d2f/windowsdesktop-runtime-5.0.15-win-x86.exe

[//]: # ( ASP 5.0.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49f495c7-6d7d-44d6-94b3-ce3c633746f8/824a679ce2f0533c80ec466116f079ee/aspnetcore-runtime-5.0.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ff16615-7afa-4741-b0ee-d86c922cb16f/958f0ea0a0248668413fd3920a1f4057/aspnetcore-runtime-5.0.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0878c21-6570-4232-9095-942907cd1e50/22c306af1c4bb271bf776347737ff71a/aspnetcore-runtime-5.0.15-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65510b46-6757-47ee-9609-dd2b1f664524/325d150001b00258e5e2b2903ef93903/aspnetcore-runtime-5.0.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/832d30fb-5a14-40a5-b81c-2d354ebf37c8/6ace2bc70718075ad06649574c0148c8/aspnetcore-runtime-5.0.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f1f37dfc-3f5b-49c3-be73-aa0839066e06/3dfbd1c2b1cf93f085db7ead99d76051/aspnetcore-runtime-5.0.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b925ee34-662b-4597-8003-0e6f23bab46c/2d5d21e290d90c094b2d25a069e34957/aspnetcore-runtime-5.0.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/495009ce-ea17-47df-b6b7-06f1b5bfd80e/a398530d27de9c1d18258cbeff62c70d/aspnetcore-runtime-5.0.15-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/69b4d158-fadb-46d0-8b28-6c4ba2968926/c4d93beeb194b73c134b3c2824499467/aspnetcore-runtime-5.0.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ceba0d71-e720-4ddd-a95d-a7e99a25ba38/280e258ef461c9bbc3e418f5a15fbebe/aspnetcore-runtime-5.0.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df529041-2a11-440c-98a4-650606c07ac0/dec1cbf6e76b45dbcff75e19c50ca485/aspnetcore-runtime-5.0.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/87df4c6d-f98c-4e85-96fa-0fb20c6fd710/f9dbcb1a127292a07656e60553effeab/aspnetcore-runtime-5.0.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/d7d20e41-4bee-4f8a-a32c-278f0ef8ce1a/f5a0c59b42d01b9fc2115615c801866c/dotnet-hosting-5.0.15-win.exe

[//]: # ( SDK 5.0.406)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c48a0d4-02cc-4f2c-b1ae-2770e6cf5806/439af3e6ab59fbce0108ee65e151546c/dotnet-sdk-5.0.406-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4ae19f7-103c-4723-a1a2-f379226664a2/cb31a7dbd166b7e0003129c44845843b/dotnet-sdk-5.0.406-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e25f1354-5f26-4515-ac3b-33897e11988b/dec283116799c02a85f466dc58fb2e7e/dotnet-sdk-5.0.406-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3f5b8da-c7c4-4d3f-ba4a-5a77cb0c9cd4/b3d302b165dfab2b76659809e5d7e6b8/dotnet-sdk-5.0.406-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4669008d-2173-4955-998e-d1e6853343f9/1bd81a78eb3653c2214c97bd3a1c1be4/dotnet-sdk-5.0.406-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91bb8c05-d6d8-42a8-afbe-75301b1afa68/3ec127938c9b934044282a7c7e825f64/dotnet-sdk-5.0.406-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2df9ee92-0984-4719-95b8-6230b8f84421/204cd150802ea242deb65a579fc1057e/dotnet-sdk-5.0.406-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/045ed34f-4b45-4b3f-8eb4-030995b418f8/2447384cc7e66980d8a4cfb55f792e83/dotnet-sdk-5.0.406-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30247690-1b69-4f82-9ad8-7fccfa0b3202/c109249dd0a6490c4262fe3540b1f4eb/dotnet-sdk-5.0.406-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a961d426-8904-498b-9621-5e81439df297/068a8a599646b29adca45be52dc76fcf/dotnet-sdk-5.0.406-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/07e62418-b3ab-49bc-81d0-50677e4b366d/9ff648c210852abc4ab6b9b50b09b4fb/dotnet-sdk-5.0.406-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f92c52da-2ef6-44f2-a296-487f94c2c37a/258dc2e61ff8bec7d90aee3ca1e7d8a3/dotnet-sdk-5.0.406-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aa30e704-a085-4ed4-bcbd-9f3491b7722b/05a1aefc5c841a1faa7eae08a5cec110/dotnet-sdk-5.0.406-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0dda29b2-5245-4e93-a1d2-812c99a5b871/82bff65f8c1e63d15ab2667c988b9084/dotnet-sdk-5.0.406-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cff08980-479c-4fec-9593-84360f84a333/ee749a63de428ae92566bdc8384e9582/dotnet-sdk-5.0.406-win-x86.zip
