# .NET 5.0.213 SDK - April 12, 2022

The .NET SDK 5.0.213 release is available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz]  \|[Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.213
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 16.9](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7362](https://github.com/dotnet/core/issues/7362) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/5.0.16/5.0.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.16-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/april-2022-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.16xx+is%3Aclosed

[linux-packages]: ../install-linux.md


[//]: # ( Runtime 5.0.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2519cc01-d9b5-49b3-8c8a-616dd5b1a26a/d12111c61a2f9dd5de92bcb3e9a796a2/dotnet-runtime-5.0.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd28f2e1-3465-471c-9cef-7454ac84045c/a92b8f92aa2226b82c0e3e017b9d998f/dotnet-runtime-5.0.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3db37b52-731d-4a3d-92de-4ed2df3f4417/3b223f1008c9c4c2e5f3d064a3216154/dotnet-runtime-5.0.16-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfbaadfa-0b07-41e6-8ec6-cec603dcca75/f60a4066845a9e478e52290a5daffd31/dotnet-runtime-5.0.16-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2790cdf0-d66a-42dd-8782-1d6d796d1685/59f782d53e4848ff7b7a8900efe6e708/dotnet-runtime-5.0.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca089696-3890-4d4f-a0c9-969464d98957/a00e3c8fe65ba7d04f5ba32b53e843e2/dotnet-runtime-5.0.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0927672b-dd80-4ea4-a822-830a11e7b318/586b0004898a28a17ea7b8e1eae961bf/dotnet-runtime-5.0.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d71ccad0-68be-451e-9a41-c3dec9e5e76e/cdb89adc78b11236a556d03e4853baa2/dotnet-runtime-5.0.16-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b15ff0f-97aa-4870-8a72-7e9f2223037c/e41e44bc94854019155ee84efdb3200e/dotnet-runtime-5.0.16-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dfaef85b-1af8-4491-b73b-55479e2f2e32/1124913ad2ab47c461d2eb15497b20a4/dotnet-runtime-5.0.16-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/68b7e1d6-8d11-4d49-926a-23fadb7d1948/e754199aff44f4bb6740f2f75c550724/dotnet-runtime-5.0.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c711787-247a-476f-bd1a-0073173f1993/906bd1f9b1ef6bb7484514239b62887f/dotnet-runtime-5.0.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/121789df-fe97-4466-ac9a-a301342c1320/33c6b1133ba60345898afef5339028c3/dotnet-runtime-5.0.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d77c274f-774b-4351-a020-2885b70a02f8/2a590371b803dd568fcdc4cf3a284c5b/dotnet-runtime-5.0.16-win-x86.zip

[//]: # ( WindowsDesktop 5.0.16)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fd645c2a-048f-4ae3-93b3-1c4619c6b688/ab9774426dcb86ce73bb7b778a2ae101/windowsdesktop-runtime-5.0.16-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0fafe9b-958d-4bce-8ba4-6c67bd621644/a30d69b829fa1ad2312c7a75c111d821/windowsdesktop-runtime-5.0.16-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/426c1ce7-52d0-4002-af0c-76274a9be4b8/4c84f606549482e43b390122f12b291b/windowsdesktop-runtime-5.0.16-win-x86.exe

[//]: # ( ASP 5.0.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44d38590-0690-4b13-8b4d-7dae444e531d/ff6fe16b344c8f91fd86bdaa2f5ed904/aspnetcore-runtime-5.0.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7647ac91-2b3e-468a-b79f-7e42de4e8780/da52863dc49b8b0bdcc19ae98828f0cc/aspnetcore-runtime-5.0.16-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ae82136-619c-47b0-973e-fd6739ec5497/ca73398b1973d96be1bc9881e0955ee0/aspnetcore-runtime-5.0.16-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9951c969-2008-4cee-a4e0-5da93d0826ea/17840772b6769b4d30add0b5bfcd3b2f/aspnetcore-runtime-5.0.16-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ebe7eda-d977-4b32-ae08-dd5105d91d8f/a97e7de099ee9443176e651aaa4e3137/aspnetcore-runtime-5.0.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa584e5c-68f4-49e0-9a3d-79a52045b509/bc9bb7c98cfc975358b931cd5c2bf7a6/aspnetcore-runtime-5.0.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2c0c94a-ebe9-43db-8e29-eb3494ed1396/fe983fe0081a6f99e7078827b0528a13/aspnetcore-runtime-5.0.16-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0bb14e86-f182-4192-9e34-36fe253fe7b5/e944050767486bc53d6137f04a30fd05/aspnetcore-runtime-5.0.16-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8f5b182b-0c64-4ef2-907f-2a24bb3f6396/0e7e685b271b1a8eb2e41816f7004c80/aspnetcore-runtime-5.0.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3148cc92-65c1-4c86-af42-5d8f4552d288/cf5c57b8eb7ab20c3bfb4b3dafbc359a/aspnetcore-runtime-5.0.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fc2264d8-b8e4-400e-892d-5ea35893e01a/2810f8be21bd8584a3b932419e6f52d5/aspnetcore-runtime-5.0.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4f6cc26d-54c7-462d-847e-130b11a7ec26/fdc4ab1f0b49a0eb12d83b3f21962d2b/aspnetcore-runtime-5.0.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0e0baacc-0402-4e05-b8e8-c7a50f6efbe5/760f2852ea15c7717668d29f28c7454c/dotnet-hosting-5.0.16-win.exe

[//]: # ( SDK 5.0.213)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d6ce970-c836-4999-8d10-898799d327af/89082237c27c491f8e400b9d6994ad44/dotnet-sdk-5.0.213-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54057e5d-fb64-4fee-a144-827bfc68bdd5/409143cb410e1db163eb46d58947e5b1/dotnet-sdk-5.0.213-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/956ff2d4-4764-43c1-89b7-af84caf9295f/73ebfddc0cf091ef630d5ec736812f0a/dotnet-sdk-5.0.213-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b9b3957-0967-4665-b363-2a90e4724238/c635aa00aa2bd1cd533036ca501a24c7/dotnet-sdk-5.0.213-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d17180e4-92cf-4a9b-afb1-638c9c3ad6b4/0b09f0c7407a79b53b517dabb244d52f/dotnet-sdk-5.0.213-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e41511ea-95cf-4368-93ff-7542a0c6b55f/47c0ea771770f1589cc90409a1710fab/dotnet-sdk-5.0.213-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8c06c3a3-9a91-4645-988d-6e5b33d3ccce/13343999f478b744a4025848dcd842a4/dotnet-sdk-5.0.213-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ecc076df-fe6b-4d02-b9f3-76ae850aa301/953261b081ab125325cc11588c472f31/dotnet-sdk-5.0.213-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d0dc594-f561-4568-8f85-e8153df52f88/0890d66470a628e849e383e63c434c82/dotnet-sdk-5.0.213-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/5c7f3152-7e62-40b9-b5a1-5bcadc25532d/9091bb59ce7a6a32d96eb8e39dbeea73/dotnet-sdk-5.0.213-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b057352-902d-4b46-902f-06b0dc39bdd2/ded3eca95d53420cac0fcb1fc68a71f5/dotnet-sdk-5.0.213-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/47203379-6711-4e47-ad01-9ff4f91dd7f3/941e3a2d950f392f646cababb389af49/dotnet-sdk-5.0.213-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8baa093f-9a83-49a0-bd68-20f5b98d73aa/3a7d62eacef7644b8e72e5816a1bb045/dotnet-sdk-5.0.213-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3e412e4e-a703-4143-9f68-9a7192a63437/2beec22acd686f5b73f79ebe4419db5e/dotnet-sdk-5.0.213-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d681bf62-10b2-423f-809c-b31e36f7afd7/1cb7fe791898574b55d8d696fb7353eb/dotnet-sdk-5.0.213-win-x86.zip
