# .NET 5.0.17 - May 10, 2022

The .NET 5.0.17, .NET 5.0.408 SDK  and [.NET SDK 5.0.214](5.0.214.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.408
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Windows SDK Updates

.NET SDK 5.0.214 and 5.0.408 include performance improvements and bug fixes to the Windows SDK packages that provide access to Windows Runtime APIs. For more details, see the [C#/WinRT 1.6.1 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.6.3.220428.1).

## Visual Studio Compatibility

You need [Visual Studio 16.9](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.17 release carries security fixes.

# Microsoft Security Advisory CVE-2022-29117 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can manipulate cookies and cause a Denial of Service.

# Microsoft Security Advisory CVE-2022-29145 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can can cause a denial of service when HTML forms are parsed.

# Microsoft Security Advisory CVE-2022-23267 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 5.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0, .NET 5.0 and .NET Core 3.1 where a malicious client can cause a Denial of Service via excess memory allocations through HttpClient.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7447](https://github.com/dotnet/core/issues/7447) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.17.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.17-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.17-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/may-2022-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.17xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64| 5.0.17.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 5.0.17.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 5.0.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 5.0.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.win-arm| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 5.0.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-arm| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 5.0.17.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.win-x86| 5.0.17.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.win-x64| 5.0.17.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 5.0.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
Microsoft.NETCore.App.Host.win-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.osx-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 5.0.17.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 5.0.17.nupkg
Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 5.0.17.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.17.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 5.0.17.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 5.0.17.nupkg
Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 5.0.17.nupkg
AspNetCoreRuntime.5.0.x86| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 5.0.17.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0| 5.0.17.nupkg
Microsoft.DotNet.Web.ItemTemplates| 5.0.17.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 5.0.17.nupkg
Microsoft.Extensions.WebEncoders| 5.0.17.nupkg
Microsoft.Extensions.Localization| 5.0.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 5.0.17.nupkg
Microsoft.Extensions.ApiDescription.Server| 5.0.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 5.0.17.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 5.0.17.nupkg
Microsoft.dotnet-openapi| 5.0.17.nupkg
Microsoft.Authentication.WebAssembly.Msal| 5.0.17.nupkg
Microsoft.AspNetCore.TestHost| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 5.0.17.nupkg
Microsoft.JSInterop.WebAssembly| 5.0.17.nupkg
Microsoft.Extensions.ObjectPool| 5.0.17.nupkg
Microsoft.Extensions.Identity.Stores| 5.0.17.nupkg
Microsoft.Extensions.FileProviders.Embedded| 5.0.17.nupkg
Microsoft.AspNetCore.Components.Authorization| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 5.0.17.nupkg
Microsoft.Extensions.ApiDescription.Client| 5.0.17.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 5.0.17.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 5.0.17.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 5.0.17.nupkg
Microsoft.AspNetCore.Components.Web| 5.0.17.nupkg
Microsoft.AspNetCore.Components| 5.0.17.nupkg
Microsoft.AspNetCore.Mvc.Testing| 5.0.17.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 5.0.17.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 5.0.17.nupkg
Microsoft.AspNetCore.Identity.UI| 5.0.17.nupkg
Microsoft.AspNetCore.JsonPatch| 5.0.17.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 5.0.17.nupkg
Microsoft.AspNetCore.Metadata| 5.0.17.nupkg
AspNetCoreRuntime.5.0.x64| 5.0.17.nupkg
dotnet-sql-cache| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 5.0.17.nupkg
Microsoft.CodeAnalysis.Razor| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 5.0.17.nupkg
Microsoft.AspNetCore.Components.Analyzers| 5.0.17.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 5.0.17.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 5.0.17.nupkg
Microsoft.AspNetCore.Authorization| 5.0.17.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 5.0.17.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 5.0.17.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 5.0.17.nupkg
Microsoft.AspNetCore.Http.Features| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 5.0.17.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Common| 5.0.17.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 5.0.17.nupkg
Microsoft.AspNetCore.DataProtection| 5.0.17.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 5.0.17.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 5.0.17.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 5.0.17.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 5.0.17.nupkg
Microsoft.AspNetCore.HeaderPropagation| 5.0.17.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.Google| 5.0.17.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 5.0.17.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 5.0.17.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 5.0.17.nupkg
Microsoft.AspNetCore.SignalR.Client| 5.0.17.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 5.0.17.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic| 5.0.17.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 5.0.17.nupkg
Microsoft.AspNetCore.Razor.Language| 5.0.17.nupkg
Microsoft.JSInterop| 5.0.17.nupkg
Microsoft.Extensions.Identity.Core| 5.0.17.nupkg
Microsoft.Extensions.Localization.Abstractions| 5.0.17.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 5.0.17.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0| 5.0.17.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 5.0.17.nupkg
Microsoft.AspNetCore.Owin| 5.0.17.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 5.0.17.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 5.0.17.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 5.0.17.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 5.0.17.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 5.0.17.nupkg
Microsoft.AspNetCore.Components.Forms| 5.0.17.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 5.0.17.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 5.0.17.nupkg
Microsoft.EntityFrameworkCore| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Design| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 5.0.17.nupkg
Microsoft.Data.Sqlite| 5.0.17.nupkg
Microsoft.Data.Sqlite.Core| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Relational| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Tools| 5.0.17.nupkg
dotnet-ef| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Proxies| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.InMemory| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 5.0.17.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 5.0.17.nupkg


[//]: # ( Runtime 5.0.17)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf63c6b3-686f-42c1-bc6c-7d4fa5aa419c/cf21a114adde9ecbc66f17a693562c4f/dotnet-runtime-5.0.17-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6690730f-cf10-40f1-9d4d-4c0d002f22d0/e117133858f190c169873200b8d7b9d7/dotnet-runtime-5.0.17-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e24a7d87-8916-4bc0-bf50-4c8cb5b0c598/3031b1cc288d613dd15bebe939770777/dotnet-runtime-5.0.17-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4e5b8142-9035-4272-a85f-83d034c3385d/d2ed6ce8059e409390db4753d4964566/dotnet-runtime-5.0.17-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca2c996c-0de8-475c-a825-06e50947315f/dd638d00b482dde611149913befec583/dotnet-runtime-5.0.17-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e77438f6-865f-45e0-9a52-3e4b04aa609f/024a880ed4bfbfd3b9f222fec0b6aaff/dotnet-runtime-5.0.17-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/440c881c-037e-4b52-8864-9f8f29fccce2/c0ddeeed8c6ded143d6e603290031cba/dotnet-runtime-5.0.17-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39326cf0-dc7f-42a3-9f7a-fe30c75c7a7f/33cbce552148e13d47120fe4502f5b5e/dotnet-runtime-5.0.17-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b4d54071-c4ad-4ccb-a5c2-ecd51f414b03/29c661cf0fef3d4084e19e08b50629b3/dotnet-runtime-5.0.17-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5c3d6f54-3ada-4279-8b16-1f5076579153/013ac95db947899e1ee545287771f513/dotnet-runtime-5.0.17-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0832b5a-6900-442b-af79-6ffddddd6ba4/e2df0b25dd851ee0b38a86947dd0e42e/dotnet-runtime-5.0.17-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a81ee543-fafc-4c62-85a6-c9eab5d0ef8d/a533bf7448b59bf05788b18faada5311/dotnet-runtime-5.0.17-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/54683c13-6b04-4d7d-b4d4-1f055b50ea43/e99048e2840d57040e8312058853a5b9/dotnet-runtime-5.0.17-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/af4e7d6a-2484-4288-80a6-2e96b06e4331/c303434225858e18f08fca2ef166c634/dotnet-runtime-5.0.17-win-x86.zip

[//]: # ( WindowsDesktop 5.0.17)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/be25784a-4231-4c53-ba6e-869166ef523f/9602c6c0d358d31dc710fd0573fc39e0/windowsdesktop-runtime-5.0.17-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3aa4e942-42cd-4bf5-afe7-fc23bd9c69c5/64da54c8864e473c19a7d3de15790418/windowsdesktop-runtime-5.0.17-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b6fe5f2a-95f4-46f1-9824-f5994f10bc69/db5ec9b47ec877b5276f83a185fdb6a0/windowsdesktop-runtime-5.0.17-win-x86.exe

[//]: # ( ASP 5.0.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0a08e01-2992-45d1-9f93-3b9d538bb007/eb834b9711f525447d3178627983bc14/aspnetcore-runtime-5.0.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6eb8aee2-cbea-4c4f-9bb9-ea6229ec229b/d6c438e5071c359ad995134f0a33e731/aspnetcore-runtime-5.0.17-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d691fafb-e082-4deb-b623-1d4cf2a6eaf7/9f0512cbb44b249dc2bf0da4df707565/aspnetcore-runtime-5.0.17-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86c52cb6-b879-4f4e-8915-5c0deff38459/f245b67571115bf920f61d272a087213/aspnetcore-runtime-5.0.17-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ab34ea5-4c97-4fa1-8d36-c077b3e57cdc/d4caf10e195b3e5fe1a1879005685ee8/aspnetcore-runtime-5.0.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2b96f83-e22a-4fa6-a10e-709b3effac9a/0d6ade6c0ceebc8ef7dbf2b1a6d86f17/aspnetcore-runtime-5.0.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25e4817f-6fd0-46dc-be0d-d819445bac5c/a8fa228c872df683741c8a79745f8fb3/aspnetcore-runtime-5.0.17-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/79d9f1f9-6680-4c2e-b4b0-1e74d4da6754/93394e9d60939b24332f9e740bb6689b/aspnetcore-runtime-5.0.17-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3789ec90-2717-424f-8b9c-3adbbcea6c16/2085cc5ff077b8789ff938015392e406/aspnetcore-runtime-5.0.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e7aaaf4-810a-4735-b2da-b223c36148b6/51fb55fee20654c3d0ac6aa2e9f46f08/aspnetcore-runtime-5.0.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4bfa247d-321d-4b29-a34b-62320849059b/8df7a17d9aad4044efe9b5b1c423e82c/aspnetcore-runtime-5.0.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/953fa44d-909a-44bf-9910-3f1264a8643b/c403fe79c13dfbcfe45aa1edbfe4a235/aspnetcore-runtime-5.0.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/05726c49-3a3d-4862-9ff8-0660d9dc3c52/71c295f9287faad89e2d3233a38b44fb/dotnet-hosting-5.0.17-win.exe

[//]: # ( SDK 5.0.408)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4dd22f89-07fe-4de6-8590-a00733264a83/a9f2479b467851cbeb2269a8de0a39b9/dotnet-sdk-5.0.408-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4b71fac-a2fd-4516-ac58-100fb09d796a/e79d6c2a8040b59bf49c0d167ae70a7b/dotnet-sdk-5.0.408-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5cebae0-9ec5-4090-94b9-48bc852e3600/8fbf0ccebc1ed2c7b040818f3bf3d26f/dotnet-sdk-5.0.408-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e06359eb-25ee-443e-ba8d-4980ea6a9e2c/436e980ac9f10f92c505a0443a321cba/dotnet-sdk-5.0.408-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a88aeea9-218f-493d-8055-a56d019f0834/a27cca834652c142855d34e11a1e524b/dotnet-sdk-5.0.408-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/904da7d0-ff02-49db-bd6b-5ea615cbdfc5/966690e36643662dcc65e3ca2423041e/dotnet-sdk-5.0.408-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ae5ffa5a-4523-4e40-bd20-d39f2c254400/69d9bd457ae7113e15506075d5e83694/dotnet-sdk-5.0.408-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7ed34a57-4da0-4fb3-bd14-614996036744/22215f1d06b49f861f94d760881d6626/dotnet-sdk-5.0.408-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4aeecc7c-7ffa-418f-9362-cf5eb3ed0396/055d5e6064a9fdecd7d906f5f262373d/dotnet-sdk-5.0.408-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e321cfb2-03e9-445f-9302-b1e00c58ec33/fdcfd22a41bf72e3098045c326ce376a/dotnet-sdk-5.0.408-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/33997df6-04c9-4579-b062-3b496c0ce182/13cc79701db1ec95132c9c9aa26f19e4/dotnet-sdk-5.0.408-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/14ccbee3-e812-4068-af47-1631444310d1/3b8da657b99d28f1ae754294c9a8f426/dotnet-sdk-5.0.408-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/57776397-c87d-4eb8-9080-d58d180ccbe6/920afd9e178bdcd10fcfe696c1fdb88c/dotnet-sdk-5.0.408-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d20a2521-d273-4ce3-b740-f9b2c363d110/e569a7b31d816d2f04baa81bf06a59ba/dotnet-sdk-5.0.408-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/297c176d-d417-42d5-b069-41ffd703bf57/1f0b91edd391a916dd717c7208a87287/dotnet-sdk-5.0.408-win-x86.zip
