# .NET 5.0.8

.NET 5.0.8 comprises:

* .NET Runtime 5.0.8
* ASP.NET Core 5.0.8
* .NET SDK 5.0.205

See the [Release Notes][release-notes] for details about what is included in this update.

## Docker

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

## Install .NET on Linux

### Install using a Package Manager

Before installing .NET, you need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET][linux-setup] for the requirements.

The following commands don't specifically include package managers to help with readability. Here are the package managers typically used by the distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

Note:
1. Before updating to .NET 5.0, uninstall any preview versions of .NET 5.0 you have previously installed.
2. .NET 5.0 is available in the default Fedora 33+ packages feeds. Before using the default Fedora package feed, please make sure to remove any packages.microsoft.com registration first.

### Install using Snap

Snap is a system that installs applications in an isolated environment and provides for automatic updates. Many distributions that are not directly supported by .NET can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=5.0/stable --classic`

Some systems require that you restart the terminal session so the Snap install location can be added to the path. If this is the case, you will see a warning once the dotnet-sdk Snap installation is complete.

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distributions require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://docs.microsoft.com/dotnet/core/install/) for a possible resolution.

### Develop applications
To develop applications using the .NET SDK, run the following command. The .NET Core and ASP.NET Core runtimes are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-5.0
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core and ASP.NET Core runtimes are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-5.0
```
### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-5.0.8.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/5.0.8/5.0.8.md
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c887d56b-4667-4e1d-9b6c-95a32dd65622/97e3eef489af8a6950744c4f9bde73c0/dotnet-hosting-5.0.8-win.exe
