# System.Collections.Generic

``` diff
 namespace System.Collections.Generic {
-    public class HashSet<T> : ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T>
+    public class HashSet<T> : ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISerializable, ISet<T>
+    public interface IReadOnlySet<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+        bool Contains(T item);
+        bool IsProperSubsetOf(IEnumerable<T> other);
+        bool IsProperSupersetOf(IEnumerable<T> other);
+        bool IsSubsetOf(IEnumerable<T> other);
+        bool IsSupersetOf(IEnumerable<T> other);
+        bool Overlaps(IEnumerable<T> other);
+        bool SetEquals(IEnumerable<T> other);
+    }
     public sealed class LinkedListNode<T> {
+        public ref T ValueRef { get; }
     }
+    public sealed class ReferenceEqualityComparer : IEqualityComparer, IEqualityComparer<object> {
+        public static ReferenceEqualityComparer Instance { get; }
+        public new bool Equals(object x, object y);
+        public int GetHashCode(object obj);
+    }
-    public class SortedSet<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T>
+    public class SortedSet<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISerializable, ISet<T>
 }
```

