# System.Diagnostics

``` diff
 namespace System.Diagnostics {
+    public class Activity : IDisposable {
+        public Activity(string operationName);
+        public ActivityTraceFlags ActivityTraceFlags { get; set; }
+        public IEnumerable<KeyValuePair<string, string>> Baggage { get; }
+        public ActivityContext Context { get; }
+        public static Activity Current { get; set; }
+        public static ActivityIdFormat DefaultIdFormat { get; set; }
+        public string DisplayName { get; set; }
+        public TimeSpan Duration { get; }
+        public IEnumerable<ActivityEvent> Events { get; }
+        public static bool ForceDefaultIdFormat { get; set; }
+        public string Id { get; }
+        public ActivityIdFormat IdFormat { get; }
+        public bool IsAllDataRequested { get; set; }
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public string OperationName { get; }
+        public Activity Parent { get; }
+        public string ParentId { get; }
+        public ActivitySpanId ParentSpanId { get; }
+        public bool Recorded { get; }
+        public string RootId { get; }
+        public ActivitySource Source { get; }
+        public ActivitySpanId SpanId { get; }
+        public DateTime StartTimeUtc { get; }
+        public IEnumerable<KeyValuePair<string, object>> TagObjects { get; }
+        public IEnumerable<KeyValuePair<string, string>> Tags { get; }
+        public ActivityTraceId TraceId { get; }
+        public string TraceStateString { get; set; }
+        public Activity AddBaggage(string key, string value);
+        public Activity AddEvent(ActivityEvent e);
+        public Activity AddTag(string key, object value);
+        public Activity AddTag(string key, string value);
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public string GetBaggageItem(string key);
+        public object GetCustomProperty(string propertyName);
+        public void SetCustomProperty(string propertyName, object propertyValue);
+        public Activity SetEndTime(DateTime endTimeUtc);
+        public Activity SetIdFormat(ActivityIdFormat format);
+        public Activity SetParentId(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags activityTraceFlags = ActivityTraceFlags.None);
+        public Activity SetParentId(string parentId);
+        public Activity SetStartTime(DateTime startTimeUtc);
+        public Activity SetTag(string key, object value);
+        public Activity Start();
+        public void Stop();
+    }
+    public readonly struct ActivityContext : IEquatable<ActivityContext> {
+        public ActivityContext(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags traceFlags, string traceState = null, bool isRemote = false);
+        public bool IsRemote { get; }
+        public ActivitySpanId SpanId { get; }
+        public ActivityTraceFlags TraceFlags { get; }
+        public ActivityTraceId TraceId { get; }
+        public string TraceState { get; }
+        public bool Equals(ActivityContext value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityContext left, ActivityContext right);
+        public static bool operator !=(ActivityContext left, ActivityContext right);
+        public static ActivityContext Parse(string traceParent, string traceState);
+        public static bool TryParse(string traceParent, string traceState, out ActivityContext context);
+    }
+    public readonly struct ActivityCreationOptions<T> {
+        public ActivityKind Kind { get; }
+        public IEnumerable<ActivityLink> Links { get; }
+        public string Name { get; }
+        public T Parent { get; }
+        public ActivityTagsCollection SamplingTags { get; }
+        public ActivitySource Source { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public ActivityTraceId TraceId { get; }
+    }
+    public readonly struct ActivityEvent {
+        public ActivityEvent(string name);
+        public ActivityEvent(string name, DateTimeOffset timestamp = default(DateTimeOffset), ActivityTagsCollection tags = null);
+        public string Name { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public DateTimeOffset Timestamp { get; }
+    }
+    public enum ActivityIdFormat {
+        Hierarchical = 1,
+        Unknown = 0,
+        W3C = 2,
+    }
+    public enum ActivityKind {
+        Client = 2,
+        Consumer = 4,
+        Internal = 0,
+        Producer = 3,
+        Server = 1,
+    }
+    public readonly struct ActivityLink : IEquatable<ActivityLink> {
+        public ActivityLink(ActivityContext context, ActivityTagsCollection tags = null);
+        public ActivityContext Context { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
+        public bool Equals(ActivityLink value);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityLink left, ActivityLink right);
+        public static bool operator !=(ActivityLink left, ActivityLink right);
+    }
+    public sealed class ActivityListener : IDisposable {
+        public ActivityListener();
+        public Action<Activity> ActivityStarted { get; set; }
+        public Action<Activity> ActivityStopped { get; set; }
+        public SampleActivity<ActivityContext> Sample { get; set; }
+        public SampleActivity<string> SampleUsingParentId { get; set; }
+        public Func<ActivitySource, bool> ShouldListenTo { get; set; }
+        public void Dispose();
+    }
+    public enum ActivitySamplingResult {
+        AllData = 2,
+        AllDataAndRecorded = 3,
+        None = 0,
+        PropagationData = 1,
+    }
+    public sealed class ActivitySource : IDisposable {
+        public ActivitySource(string name, string version = "");
+        public string Name { get; }
+        public string Version { get; }
+        public static void AddActivityListener(ActivityListener listener);
+        public void Dispose();
+        public bool HasListeners();
+        public Activity StartActivity(string name, ActivityKind kind = ActivityKind.Internal);
+        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
+    }
+    public readonly struct ActivitySpanId : IEquatable<ActivitySpanId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivitySpanId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivitySpanId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivitySpanId CreateRandom();
+        public bool Equals(ActivitySpanId spanId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivitySpanId spanId1, ActivitySpanId spandId2);
+        public static bool operator !=(ActivitySpanId spanId1, ActivitySpanId spandId2);
+        public string ToHexString();
+        public override string ToString();
+    }
+    public class ActivityTagsCollection : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public ActivityTagsCollection();
+        public ActivityTagsCollection(IEnumerable<KeyValuePair<string, object>> list);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public ICollection<string> Keys { get; }
+        public object this[string key] { get; set; }
+        public ICollection<object> Values { get; }
+        public void Add(KeyValuePair<string, object> item);
+        public void Add(string key, object value);
+        public void Clear();
+        public bool Contains(KeyValuePair<string, object> item);
+        public bool ContainsKey(string key);
+        public void CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        public ActivityTagsCollection.Enumerator GetEnumerator();
+        public bool Remove(KeyValuePair<string, object> item);
+        public bool Remove(string key);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue(string key, out object value);
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+            public KeyValuePair<string, object> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+        }
+    }
+    public enum ActivityTraceFlags {
+        None = 0,
+        Recorded = 1,
+    }
+    public readonly struct ActivityTraceId : IEquatable<ActivityTraceId> {
+        public void CopyTo(Span<byte> destination);
+        public static ActivityTraceId CreateFromBytes(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateFromString(ReadOnlySpan<char> idData);
+        public static ActivityTraceId CreateFromUtf8String(ReadOnlySpan<byte> idData);
+        public static ActivityTraceId CreateRandom();
+        public bool Equals(ActivityTraceId traceId);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(ActivityTraceId traceId1, ActivityTraceId traceId2);
+        public static bool operator !=(ActivityTraceId traceId1, ActivityTraceId traceId2);
+        public string ToHexString();
+        public override string ToString();
+    }
+    public class ConsoleTraceListener : TextWriterTraceListener {
+        public ConsoleTraceListener();
+        public ConsoleTraceListener(bool useErrorStream);
+        public override void Close();
+    }
+    public class DiagnosticListener : DiagnosticSource, IDisposable, IObservable<KeyValuePair<string, object>> {
+        public DiagnosticListener(string name);
+        public static IObservable<DiagnosticListener> AllListeners { get; }
+        public string Name { get; }
+        public virtual void Dispose();
+        public bool IsEnabled();
+        public override bool IsEnabled(string name);
+        public override bool IsEnabled(string name, object arg1, object arg2 = null);
+        public override void OnActivityExport(Activity activity, object payload);
+        public override void OnActivityImport(Activity activity, object payload);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Func<string, object, object, bool> isEnabled);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Func<string, object, object, bool> isEnabled, Action<Activity, object> onActivityImport = null, Action<Activity, object> onActivityExport = null);
+        public virtual IDisposable Subscribe(IObserver<KeyValuePair<string, object>> observer, Predicate<string> isEnabled);
+        public override string ToString();
+        public override void Write(string name, object value);
+    }
+    public abstract class DiagnosticSource {
+        protected DiagnosticSource();
+        public abstract bool IsEnabled(string name);
+        public virtual bool IsEnabled(string name, object arg1, object arg2 = null);
+        public virtual void OnActivityExport(Activity activity, object payload);
+        public virtual void OnActivityImport(Activity activity, object payload);
+        public Activity StartActivity(Activity activity, object args);
+        public void StopActivity(Activity activity, object args);
+        public abstract void Write(string name, object value);
+    }
-    public class Process : Component {
+    public class Process : Component, IDisposable {
+        public void Kill(bool entireProcessTree);
+        public static Process Start(string fileName, IEnumerable<string> arguments);
+        public Task WaitForExitAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
+    public delegate ActivitySamplingResult SampleActivity<T>(ref ActivityCreationOptions<T> options);
     public class StackFrame {
-        public StackFrame(bool fNeedFileInfo);
+        public StackFrame(bool needFileInfo);
-        public StackFrame(int skipFrames, bool fNeedFileInfo);
+        public StackFrame(int skipFrames, bool needFileInfo);
     }
+    public class XmlWriterTraceListener : TextWriterTraceListener {
+        public XmlWriterTraceListener(Stream stream);
+        public XmlWriterTraceListener(Stream stream, string name);
+        public XmlWriterTraceListener(TextWriter writer);
+        public XmlWriterTraceListener(TextWriter writer, string name);
+        public XmlWriterTraceListener(string filename);
+        public XmlWriterTraceListener(string filename, string name);
+        public override void Close();
+        public override void Fail(string message, string detailMessage);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
+        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
+        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
+        public override void TraceTransfer(TraceEventCache eventCache, string source, int id, string message, Guid relatedActivityId);
+        public override void Write(string message);
+        public override void WriteLine(string message);
+    }
 }
```

