# System.Runtime.Loader

``` diff
+namespace System.Runtime.Loader {
+    public sealed class AssemblyDependencyResolver {
+        public AssemblyDependencyResolver(string componentAssemblyPath);
+        public string ResolveAssemblyToPath(AssemblyName assemblyName);
+        public string ResolveUnmanagedDllToPath(string unmanagedDllName);
+    }
+    public class AssemblyLoadContext {
+        protected AssemblyLoadContext();
+        protected AssemblyLoadContext(bool isCollectible);
+        public AssemblyLoadContext(string name, bool isCollectible = false);
+        public static IEnumerable<AssemblyLoadContext> All { get; }
+        public IEnumerable<Assembly> Assemblies { get; }
+        public static AssemblyLoadContext CurrentContextualReflectionContext { get; }
+        public static AssemblyLoadContext Default { get; }
+        public bool IsCollectible { get; }
+        public string Name { get; }
+        public event Func<AssemblyLoadContext, AssemblyName, Assembly> Resolving;
+        public event Func<Assembly, string, IntPtr> ResolvingUnmanagedDll;
+        public event Action<AssemblyLoadContext> Unloading;
+        public AssemblyLoadContext.ContextualReflectionScope EnterContextualReflection();
+        public static AssemblyLoadContext.ContextualReflectionScope EnterContextualReflection(Assembly activating);
+        ~AssemblyLoadContext();
+        public static AssemblyName GetAssemblyName(string assemblyPath);
+        public static AssemblyLoadContext GetLoadContext(Assembly assembly);
+        protected virtual Assembly Load(AssemblyName assemblyName);
+        public Assembly LoadFromAssemblyName(AssemblyName assemblyName);
+        public Assembly LoadFromAssemblyPath(string assemblyPath);
+        public Assembly LoadFromNativeImagePath(string nativeImagePath, string assemblyPath);
+        public Assembly LoadFromStream(Stream assembly);
+        public Assembly LoadFromStream(Stream assembly, Stream assemblySymbols);
+        protected virtual IntPtr LoadUnmanagedDll(string unmanagedDllName);
+        protected IntPtr LoadUnmanagedDllFromPath(string unmanagedDllPath);
+        public void SetProfileOptimizationRoot(string directoryPath);
+        public void StartProfileOptimization(string profile);
+        public override string ToString();
+        public void Unload();
+        public struct ContextualReflectionScope : IDisposable {
+            public void Dispose();
+        }
+    }
+}
```

