# System.Text

``` diff
 namespace System.Text {
     public class ASCIIEncoding : Encoding {
+        public override int GetByteCount(ReadOnlySpan<char> chars);
+        public override int GetBytes(ReadOnlySpan<char> chars, Span<byte> bytes);
+        public override int GetCharCount(ReadOnlySpan<byte> bytes);
+        public override int GetChars(ReadOnlySpan<byte> bytes, Span<char> chars);
     }
+    public sealed class CodePagesEncodingProvider : EncodingProvider {
+        public static EncodingProvider Instance { get; }
+        public override Encoding GetEncoding(int codepage);
+        public override Encoding GetEncoding(string name);
+        public override IEnumerable<EncodingInfo> GetEncodings();
+    }
     public abstract class Encoding : ICloneable {
+        public static Encoding Latin1 { get; }
+        public static Stream CreateTranscodingStream(Stream innerStream, Encoding innerStreamEncoding, Encoding outerStreamEncoding, bool leaveOpen = false);
     }
+    public static class EncodingExtensions {
+        public static void Convert(this Decoder decoder, in ReadOnlySequence<byte> bytes, IBufferWriter<char> writer, bool flush, out long charsUsed, out bool completed);
+        public static void Convert(this Decoder decoder, ReadOnlySpan<byte> bytes, IBufferWriter<char> writer, bool flush, out long charsUsed, out bool completed);
+        public static void Convert(this Encoder encoder, in ReadOnlySequence<char> chars, IBufferWriter<byte> writer, bool flush, out long bytesUsed, out bool completed);
+        public static void Convert(this Encoder encoder, ReadOnlySpan<char> chars, IBufferWriter<byte> writer, bool flush, out long bytesUsed, out bool completed);
+        public static byte[] GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars);
+        public static long GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars, IBufferWriter<byte> writer);
+        public static int GetBytes(this Encoding encoding, in ReadOnlySequence<char> chars, Span<byte> bytes);
+        public static long GetBytes(this Encoding encoding, ReadOnlySpan<char> chars, IBufferWriter<byte> writer);
+        public static long GetChars(this Encoding encoding, in ReadOnlySequence<byte> bytes, IBufferWriter<char> writer);
+        public static int GetChars(this Encoding encoding, in ReadOnlySequence<byte> bytes, Span<char> chars);
+        public static long GetChars(this Encoding encoding, ReadOnlySpan<byte> bytes, IBufferWriter<char> writer);
+        public static string GetString(this Encoding encoding, in ReadOnlySequence<byte> bytes);
+    }
     public sealed class EncodingInfo {
+        public EncodingInfo(EncodingProvider provider, int codePage, string name, string displayName);
     }
     public abstract class EncodingProvider {
+        public virtual IEnumerable<EncodingInfo> GetEncodings();
     }
+    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune> {
+        public Rune(char ch);
+        public Rune(char highSurrogate, char lowSurrogate);
+        public Rune(int value);
+        public Rune(uint value);
+        public bool IsAscii { get; }
+        public bool IsBmp { get; }
+        public int Plane { get; }
+        public static Rune ReplacementChar { get; }
+        public int Utf16SequenceLength { get; }
+        public int Utf8SequenceLength { get; }
+        public int Value { get; }
+        public int CompareTo(Rune other);
+        public static OperationStatus DecodeFromUtf16(ReadOnlySpan<char> source, out Rune result, out int charsConsumed);
+        public static OperationStatus DecodeFromUtf8(ReadOnlySpan<byte> source, out Rune result, out int bytesConsumed);
+        public static OperationStatus DecodeLastFromUtf16(ReadOnlySpan<char> source, out Rune result, out int charsConsumed);
+        public static OperationStatus DecodeLastFromUtf8(ReadOnlySpan<byte> source, out Rune value, out int bytesConsumed);
+        public int EncodeToUtf16(Span<char> destination);
+        public int EncodeToUtf8(Span<byte> destination);
+        public override bool Equals(object obj);
+        public bool Equals(Rune other);
+        public override int GetHashCode();
+        public static double GetNumericValue(Rune value);
+        public static Rune GetRuneAt(string input, int index);
+        public static UnicodeCategory GetUnicodeCategory(Rune value);
+        public static bool IsControl(Rune value);
+        public static bool IsDigit(Rune value);
+        public static bool IsLetter(Rune value);
+        public static bool IsLetterOrDigit(Rune value);
+        public static bool IsLower(Rune value);
+        public static bool IsNumber(Rune value);
+        public static bool IsPunctuation(Rune value);
+        public static bool IsSeparator(Rune value);
+        public static bool IsSymbol(Rune value);
+        public static bool IsUpper(Rune value);
+        public static bool IsValid(int value);
+        public static bool IsValid(uint value);
+        public static bool IsWhiteSpace(Rune value);
+        public static bool operator ==(Rune left, Rune right);
+        public static explicit operator Rune (char ch);
+        public static explicit operator Rune (int value);
+        public static explicit operator Rune (uint value);
+        public static bool operator >(Rune left, Rune right);
+        public static bool operator >=(Rune left, Rune right);
+        public static bool operator !=(Rune left, Rune right);
+        public static bool operator <(Rune left, Rune right);
+        public static bool operator <=(Rune left, Rune right);
+        int System.IComparable.CompareTo(object obj);
+        public static Rune ToLower(Rune value, CultureInfo culture);
+        public static Rune ToLowerInvariant(Rune value);
+        public override string ToString();
+        public static Rune ToUpper(Rune value, CultureInfo culture);
+        public static Rune ToUpperInvariant(Rune value);
+        public static bool TryCreate(char highSurrogate, char lowSurrogate, out Rune result);
+        public static bool TryCreate(char ch, out Rune result);
+        public static bool TryCreate(int value, out Rune result);
+        public static bool TryCreate(uint value, out Rune result);
+        public bool TryEncodeToUtf16(Span<char> destination, out int charsWritten);
+        public bool TryEncodeToUtf8(Span<byte> destination, out int bytesWritten);
+        public static bool TryGetRuneAt(string input, int index, out Rune value);
+    }
+    public ref struct SpanRuneEnumerator {
+        public Rune Current { get; }
+        public SpanRuneEnumerator GetEnumerator();
+        public bool MoveNext();
+    }
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder Append(ReadOnlyMemory<char> value);
+        public StringBuilder.ChunkEnumerator GetChunks();
+        public struct ChunkEnumerator {
+            public ReadOnlyMemory<char> Current { get; }
+            public StringBuilder.ChunkEnumerator GetEnumerator();
+            public bool MoveNext();
+        }
     }
+    public struct StringRuneEnumerator : IDisposable, IEnumerable, IEnumerable<Rune>, IEnumerator, IEnumerator<Rune> {
+        public Rune Current { get; }
+        object System.Collections.IEnumerator.Current { get; }
+        public StringRuneEnumerator GetEnumerator();
+        public bool MoveNext();
+        IEnumerator<Rune> System.Collections.Generic.IEnumerable<System.Text.Rune>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        void System.Collections.IEnumerator.Reset();
+        void System.IDisposable.Dispose();
+    }
     public class UnicodeEncoding : Encoding {
+        public override ReadOnlySpan<byte> Preamble { get; }
     }
     public sealed class UTF32Encoding : Encoding {
+        public override ReadOnlySpan<byte> Preamble { get; }
     }
     public class UTF8Encoding : Encoding {
+        public override ReadOnlySpan<byte> Preamble { get; }
+        public override int GetByteCount(ReadOnlySpan<char> chars);
+        public override int GetBytes(ReadOnlySpan<char> chars, Span<byte> bytes);
+        public override int GetCharCount(ReadOnlySpan<byte> bytes);
+        public override int GetChars(ReadOnlySpan<byte> bytes, Span<char> chars);
     }
 }
```

