# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class ByteArrayContent : HttpContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class FormUrlEncodedContent : ByteArrayContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class HttpClient : HttpMessageInvoker {
+        public Task<byte[]> GetByteArrayAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<byte[]> GetByteArrayAsync(Uri requestUri, CancellationToken cancellationToken);
+        public Task<Stream> GetStreamAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<Stream> GetStreamAsync(Uri requestUri, CancellationToken cancellationToken);
+        public Task<string> GetStringAsync(string requestUri, CancellationToken cancellationToken);
+        public Task<string> GetStringAsync(Uri requestUri, CancellationToken cancellationToken);
     }
     public abstract class HttpContent : IDisposable {
+        public Task CopyToAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
+        public Task CopyToAsync(Stream stream, CancellationToken cancellationToken);
+        protected virtual Task<Stream> CreateContentReadStreamAsync(CancellationToken cancellationToken);
+        public Task<byte[]> ReadAsByteArrayAsync(CancellationToken cancellationToken);
+        public Task<Stream> ReadAsStreamAsync(CancellationToken cancellationToken);
+        public Task<string> ReadAsStringAsync(CancellationToken cancellationToken);
+        protected virtual Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class HttpRequestException : Exception {
+        public HttpRequestException(string message, Exception inner, HttpStatusCode? statusCode);
+        public HttpStatusCode? StatusCode { get; }
     }
     public class MultipartContent : HttpContent, IEnumerable, IEnumerable<HttpContent> {
+        protected override Task<Stream> CreateContentReadStreamAsync(CancellationToken cancellationToken);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class MultipartFormDataContent : MultipartContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public sealed class ReadOnlyMemoryContent : HttpContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class StreamContent : HttpContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
     public class StringContent : ByteArrayContent {
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context, CancellationToken cancellationToken);
     }
 }
```

