# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public enum Architecture {
+        Wasm = 4,
     }
+    public static class CollectionsMarshal {
+        public static Span<T> AsSpan<T>(List<T> list);
+    }
+    public abstract class ComWrappers {
+        protected ComWrappers();
+        protected unsafe abstract ComWrappers.ComInterfaceEntry* ComputeVtables(object obj, CreateComInterfaceFlags flags, out int count);
+        protected abstract object CreateObject(IntPtr externalComObject, CreateObjectFlags flags);
+        protected static void GetIUnknownImpl(out IntPtr fpQueryInterface, out IntPtr fpAddRef, out IntPtr fpRelease);
+        public IntPtr GetOrCreateComInterfaceForObject(object instance, CreateComInterfaceFlags flags);
+        public object GetOrCreateObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags);
+        public object GetOrRegisterObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags, object wrapper);
+        public void RegisterAsGlobalInstance();
+        protected abstract void ReleaseObjects(IEnumerable objects);
+        public struct ComInterfaceDispatch {
+            public IntPtr Vtable;
+            public unsafe static T GetInstance<T>(ComWrappers.ComInterfaceDispatch* dispatchPtr) where T : class;
+        }
+        public struct ComInterfaceEntry {
+            public Guid IID;
+            public IntPtr Vtable;
+        }
+    }
+    public enum CreateComInterfaceFlags {
+        CallerDefinedIUnknown = 1,
+        None = 0,
+        TrackerSupport = 2,
+    }
+    public enum CreateObjectFlags {
+        None = 0,
+        TrackerObject = 1,
+        UniqueInstance = 2,
+    }
     public static class MemoryMarshal {
+        public static ref T GetArrayDataReference<T>(T[] array);
     }
+    public sealed class NativeCallableAttribute : Attribute {
+        public CallingConvention CallingConvention;
+        public string EntryPoint;
+        public NativeCallableAttribute();
+    }
     public readonly struct OSPlatform : IEquatable<OSPlatform> {
+        public static OSPlatform Browser { get; }
     }
     public static class RuntimeInformation {
+        public static string RuntimeIdentifier { get; }
     }
+    public sealed class SuppressGCTransitionAttribute : Attribute {
+        public SuppressGCTransitionAttribute();
+    }
 }
```

