# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public class BadHttpRequestException : IOException {
+        public BadHttpRequestException(string message);
+        public BadHttpRequestException(string message, Exception innerException);
+        public BadHttpRequestException(string message, int statusCode);
+        public BadHttpRequestException(string message, int statusCode, Exception innerException);
+        public int StatusCode { get; }
+    }
+    public static class HttpProtocol {
+        public static readonly string Http10;
+        public static readonly string Http11;
+        public static readonly string Http2;
+        public static readonly string Http3;
+        public static string GetHttpProtocol(Version version);
+        public static bool IsHttp10(string protocol);
+        public static bool IsHttp11(string protocol);
+        public static bool IsHttp2(string protocol);
+        public static bool IsHttp3(string protocol);
+    }
 }
```

