# Microsoft.AspNetCore.SignalR

``` diff
 namespace Microsoft.AspNetCore.SignalR {
     public class HubInvocationContext {
+        public HubInvocationContext(HubCallerContext context, IServiceProvider serviceProvider, Hub hub, MethodInfo hubMethod, IReadOnlyList<object> hubMethodArguments);
-        public HubInvocationContext(HubCallerContext context, Type hubType, string hubMethodName, object[] hubMethodArguments);

+        public Hub Hub { get; }
+        public MethodInfo HubMethod { get; }
-        public Type HubType { get; }

+        public IServiceProvider ServiceProvider { get; }
     }
+    public sealed class HubLifetimeContext {
+        public HubLifetimeContext(HubCallerContext context, IServiceProvider serviceProvider, Hub hub);
+        public HubCallerContext Context { get; }
+        public Hub Hub { get; }
+        public IServiceProvider ServiceProvider { get; }
+    }
+    public static class HubOptionsExtensions {
+        public static void AddFilter(this HubOptions options, IHubFilter hubFilter);
+        public static void AddFilter(this HubOptions options, Type filterType);
+        public static void AddFilter<TFilter>(this HubOptions options) where TFilter : IHubFilter;
+    }
+    public interface IHubFilter {
+        ValueTask<object> InvokeMethodAsync(HubInvocationContext invocationContext, Func<HubInvocationContext, ValueTask<object>> next);
+        Task OnConnectedAsync(HubLifetimeContext context, Func<HubLifetimeContext, Task> next);
+        Task OnDisconnectedAsync(HubLifetimeContext context, Exception exception, Func<HubLifetimeContext, Exception, Task> next);
+    }
 }
```

