# System.Threading.Tasks

``` diff
 namespace System.Threading.Tasks {
     public class Task : IAsyncResult, IDisposable {
+        public static Task<Task> WhenAny(Task task1, Task task2);
+        public static Task<Task<TResult>> WhenAny<TResult>(Task<TResult> task1, Task<TResult> task2);
     }
+    public class TaskCompletionSource {
+        public TaskCompletionSource();
+        public TaskCompletionSource(object state);
+        public TaskCompletionSource(object state, TaskCreationOptions creationOptions);
+        public TaskCompletionSource(TaskCreationOptions creationOptions);
+        public Task Task { get; }
+        public void SetCanceled();
+        public void SetCanceled(CancellationToken cancellationToken);
+        public void SetException(IEnumerable<Exception> exceptions);
+        public void SetException(Exception exception);
+        public void SetResult();
+        public bool TrySetCanceled();
+        public bool TrySetCanceled(CancellationToken cancellationToken);
+        public bool TrySetException(IEnumerable<Exception> exceptions);
+        public bool TrySetException(Exception exception);
+        public bool TrySetResult();
+    }
     public readonly struct ValueTask : IEquatable<ValueTask> {
+        public static ValueTask CompletedTask { get; }
+        public static ValueTask FromCanceled(CancellationToken cancellationToken);
+        public static ValueTask<TResult> FromCanceled<TResult>(CancellationToken cancellationToken);
+        public static ValueTask FromException(Exception exception);
+        public static ValueTask<TResult> FromException<TResult>(Exception exception);
+        public static ValueTask<TResult> FromResult<TResult>(TResult result);
     }
 }
```

