# System

``` diff
 namespace System {
     public static class Console {
+        public static (int Left, int Top) GetCursorPosition();
     }
     public static class GC {
+        public static GCMemoryInfo GetGCMemoryInfo(GCKind kind);
     }
+    public readonly struct GCGenerationInfo {
+        public long FragmentationAfterBytes { get; }
+        public long FragmentationBeforeBytes { get; }
+        public long SizeAfterBytes { get; }
+        public long SizeBeforeBytes { get; }
+    }
+    public enum GCKind {
+        Any = 0,
+        Background = 3,
+        Ephemeral = 1,
+        FullBlocking = 2,
+    }
     public readonly struct GCMemoryInfo {
+        public bool Compacted { get; }
+        public bool Concurrent { get; }
+        public long FinalizationPendingCount { get; }
+        public int Generation { get; }
+        public ReadOnlySpan<GCGenerationInfo> GenerationInfo { get; }
+        public long Index { get; }
+        public ReadOnlySpan<TimeSpan> PauseDurations { get; }
+        public double PauseTimePercentage { get; }
+        public long PinnedObjectsCount { get; }
+        public long PromotedBytes { get; }
+        public long TotalCommittedBytes { get; }
     }
+    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable {
+        public static Half Epsilon { get; }
+        public static Half MaxValue { get; }
+        public static Half MinValue { get; }
+        public static Half NaN { get; }
+        public static Half NegativeInfinity { get; }
+        public static Half PositiveInfinity { get; }
+        public int CompareTo(Half other);
+        public int CompareTo(object obj);
+        public bool Equals(Half other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool IsFinite(Half value);
+        public static bool IsInfinity(Half value);
+        public static bool IsNaN(Half value);
+        public static bool IsNegative(Half value);
+        public static bool IsNegativeInfinity(Half value);
+        public static bool IsNormal(Half value);
+        public static bool IsPositiveInfinity(Half value);
+        public static bool IsSubnormal(Half value);
+        public static bool operator ==(Half left, Half right);
+        public static explicit operator Half (double value);
+        public static explicit operator double (Half value);
+        public static explicit operator float (Half value);
+        public static explicit operator Half (float value);
+        public static bool operator >(Half left, Half right);
+        public static bool operator >=(Half left, Half right);
+        public static bool operator !=(Half left, Half right);
+        public static bool operator <(Half left, Half right);
+        public static bool operator <=(Half left, Half right);
+        public static Half Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider provider = null);
+        public static Half Parse(string s);
+        public static Half Parse(string s, NumberStyles style);
+        public static Half Parse(string s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider provider = null);
+        public static Half Parse(string s, IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Half result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Half result);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Half result);
+        public static bool TryParse(string s, out Half result);
+    }
     public static class Math {
+        public const double Tau = 6.2831853071795862;
     }
     public static class MathF {
+        public const float Tau = 6.28318548f;
     }
     public enum StringSplitOptions {
+        TrimEntries = 2,
     }
 }
```

