# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
-    public static class HttpRequestExtensions {
 {
-        public static bool HasJsonContentType(this HttpRequest request);

-    }
+    public static class HttpRequestJsonExtensions {
+        public static bool HasJsonContentType(this HttpRequest request);
+        public static ValueTask<object> ReadFromJsonAsync(this HttpRequest request, Type type, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<object> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> ReadFromJsonAsync<TValue>(this HttpRequest request, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public static class HttpResponseJsonExtensions {
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, JsonSerializerOptions options, string contentType, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object value, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions options, string contentType, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, JsonSerializerOptions options, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
+    }
 }
```

