# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public readonly struct ActivityContext : IEquatable<ActivityContext> {
+        public static ActivityContext Parse(string traceParent, string traceState);
+        public static bool TryParse(string traceParent, string traceState, out ActivityContext context);
     }
     public readonly struct ActivityCreationOptions<T> {
+        public ActivityTagsCollection SamplingTags { get; }
+        public ActivityTraceId TraceId { get; }
     }
-    public enum ActivityDataRequest {
 {
-        AllData = 2,

-        AllDataAndRecorded = 3,

-        None = 0,

-        PropagationData = 1,

-    }
     public sealed class ActivityListener : IDisposable {
-        public bool AutoGenerateRootContextTraceId { get; set; }

-        public GetRequestedData<ActivityContext> GetRequestedDataUsingContext { get; set; }

-        public GetRequestedData<string> GetRequestedDataUsingParentId { get; set; }

+        public SampleActivity<ActivityContext> Sample { get; set; }
+        public SampleActivity<string> SampleUsingParentId { get; set; }
     }
+    public enum ActivitySamplingResult {
+        AllData = 2,
+        AllDataAndRecorded = 3,
+        None = 0,
+        PropagationData = 1,
+    }
-    public delegate ActivityDataRequest GetRequestedData<T>(ref ActivityCreationOptions<T> options);

     public class Process : Component, IDisposable {
+        public static Process Start(string fileName, IEnumerable<string> arguments);
     }
+    public delegate ActivitySamplingResult SampleActivity<T>(ref ActivityCreationOptions<T> options);
     public class StackFrame {
-        public StackFrame(bool fNeedFileInfo);
+        public StackFrame(bool needFileInfo);
-        public StackFrame(int skipFrames, bool fNeedFileInfo);
+        public StackFrame(int skipFrames, bool needFileInfo);
     }
 }
```

