# .NET 6.0.0 - November 08, 2021

The .NET 6.0.0 and .NET 6.0.100 SDK releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 

.NET 6 is the next major release of .NET following .NET 5. See [What's new in .NET 6.0](https://docs.microsoft.com/dotnet/core/whats-new/dotnet-6) for more details. You can also find additional details on the following blog posts:
* [Announcing .NET 6][dotnet-blog] 
* [.NET MAUI][maui-blog]
* [ASP.NET Core Blog][aspnet-blog]

Release feature and bug lists:

* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A6.0.0+is%3Aclosed+label%3Aservicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.0+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.0+is%3Aclosed+label%3Aservicing-approved+)

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Windows SDK Updates
* TFM support for the Windows 11 SDK is available in .NET 6. To target the Windows 11 SDK (10.0.22000)  in .NET 6, set the `TargetFramework` property in your project file to `net6.0-windows10.0.22000.0`.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6881](https://github.com/dotnet/core/issues/6881) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.0/6.0.0.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
System.ServiceModel.Primitives | 4.9.0.symbols.nupkg
System.ServiceModel.Duplex | 4.9.0.symbols.nupkg
System.Web.Services.Description | 4.9.0.nupkg
System.ServiceModel.Security | 4.9.0.symbols.nupkg
System.ServiceModel.Security | 4.9.0.nupkg
System.ServiceModel.Primitives | 4.9.0.nupkg
System.ServiceModel.Http | 4.9.0.nupkg
System.ServiceModel.Duplex | 4.9.0.nupkg
System.Private.ServiceModel | 4.9.0.nupkg
System.Web.Services.Description | 4.9.0.symbols.nupkg
System.ServiceModel.NetTcp | 4.9.0.symbols.nupkg
System.ServiceModel.Federation | 4.9.0.symbols.nupkg
System.ServiceModel.Http | 4.9.0.symbols.nupkg
System.Private.ServiceModel | 4.9.0.symbols.nupkg
System.ServiceModel.NetTcp | 4.9.0.nupkg
System.ServiceModel.Federation | 4.9.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.0.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.0.nupkg
Microsoft.WindowsDesktop.App.Ref | 6.0.0.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.0.symbols.nupkg
Microsoft.WindowsDesktop.App.Ref | 6.0.0.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.0.symbols.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.0.nupkg
System.Threading.Tasks.Dataflow | 6.0.0.symbols.nupkg
System.Speech | 6.0.0.symbols.nupkg
System.Diagnostics.DiagnosticSource | 6.0.0.symbols.nupkg
System.CodeDom | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
System.Composition.AttributedModel | 6.0.0.symbols.nupkg
System.Resources.Extensions | 6.0.0.symbols.nupkg
System.Management | 6.0.0.symbols.nupkg
System.DirectoryServices.AccountManagement | 6.0.0.symbols.nupkg
System.Reflection.Context | 6.0.0.symbols.nupkg
System.IO.Ports | 6.0.0.symbols.nupkg
System.IO.Pipelines | 6.0.0.symbols.nupkg
System.Drawing.Common | 6.0.0.symbols.nupkg
System.Formats.Cbor | 6.0.0.symbols.nupkg
System.Memory.Data | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.Windows.Compatibility | 6.0.0.nupkg
Microsoft.Win32.SystemEvents | 6.0.0.nupkg
runtime.linux-arm64.runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
Microsoft.Win32.Registry.AccessControl | 6.0.0.nupkg
Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
System.Threading.Channels | 6.0.0.symbols.nupkg
System.Security.Cryptography.Xml | 6.0.0.symbols.nupkg
System.ServiceModel.Syndication | 6.0.0.symbols.nupkg
System.Threading.AccessControl | 6.0.0.symbols.nupkg
System.Security.Cryptography.Pkcs | 6.0.0.symbols.nupkg
System.Composition.TypedParts | 6.0.0.symbols.nupkg
System.Diagnostics.EventLog | 6.0.0.symbols.nupkg
System.ComponentModel.Composition | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
System.DirectoryServices | 6.0.0.symbols.nupkg
System.Security.AccessControl | 6.0.0.symbols.nupkg
System.Runtime.CompilerServices.Unsafe | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.0.nupkg
System.ComponentModel.Composition | 6.0.0.nupkg
System.ComponentModel.Composition.Registration | 6.0.0.nupkg
System.Composition | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.0.nupkg
Microsoft.Extensions.Logging.EventSource | 6.0.0.nupkg
Microsoft.Extensions.Logging.Debug | 6.0.0.nupkg
Microsoft.Extensions.Logging.Console | 6.0.0.nupkg
Microsoft.Extensions.Logging.Configuration | 6.0.0.nupkg
Microsoft.Extensions.Http | 6.0.0.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.0.nupkg
Microsoft.Extensions.FileProviders.Composite | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.0.nupkg
Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
Microsoft.XmlSerializer.Generator | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.0.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
System.Composition.Runtime | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
System.Composition.AttributedModel | 6.0.0.nupkg
System.Composition.TypedParts | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
System.Collections.Immutable | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
System.DirectoryServices | 6.0.0.nupkg
System.IO.Packaging | 6.0.0.nupkg
System.DirectoryServices.AccountManagement | 6.0.0.nupkg
System.DirectoryServices.Protocols | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.0.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.0.nupkg
Microsoft.Extensions.Logging.TraceSource | 6.0.0.nupkg
Microsoft.Extensions.Logging.EventLog | 6.0.0.nupkg
Microsoft.Extensions.Logging.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Logging | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.0.nupkg
Microsoft.Extensions.Hosting | 6.0.0.nupkg
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.win-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.Win32.Registry.AccessControl | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.0.symbols.nupkg
Microsoft.Windows.Compatibility | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.0.symbols.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Extensions.Hosting.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Bcl.AsyncInterfaces | 6.0.0.symbols.nupkg
Microsoft.IO.Redist | 6.0.0.symbols.nupkg
Microsoft.Net.HostModel.PGO | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.0.symbols.nupkg
Microsoft.NET.HostModel | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.win-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm | 6.0.0.symbols.nupkg
Microsoft.NET.Sdk.IL | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.0.symbols.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.Platforms | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 6.0.0.nupkg
Microsoft.NETCore.ILAsm | 6.0.0.nupkg
Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
System.Composition.Hosting | 6.0.0.nupkg
System.Composition.Convention | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
System.Management | 6.0.0.nupkg
System.Numerics.Tensors | 6.0.0-rtm.21522.10.nupkg
System.Data.Odbc | 6.0.0.nupkg
System.Net.Http.WinHttpHandler | 6.0.0.nupkg
System.Net.Http.Json | 6.0.0.nupkg
System.IO.Pipelines | 6.0.0.nupkg
System.Drawing.Common | 6.0.0.nupkg
System.Formats.Asn1 | 6.0.0.nupkg
System.Diagnostics.EventLog | 6.0.0.nupkg
System.Diagnostics.DiagnosticSource | 6.0.0.nupkg
System.Formats.Cbor | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
runtime.linux-x64.runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.osx-x64.runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.0.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.0.nupkg
Microsoft.NET.Sdk.IL | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.0.nupkg
Microsoft.ILVerification | 6.0.0.nupkg
Microsoft.Extensions.Primitives | 6.0.0.nupkg
Microsoft.Extensions.Options.DataAnnotations | 6.0.0.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 6.0.0.nupkg
Microsoft.Diagnostics.Tracing.EventSource.Redist | 6.0.0.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 6.0.0.nupkg
Microsoft.Extensions.Configuration.CommandLine | 6.0.0.nupkg
dotnet-ilverify | 6.0.0.nupkg
Microsoft.Extensions.Configuration | 6.0.0.nupkg
Microsoft.Bcl.AsyncInterfaces | 6.0.0.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.0.nupkg
Microsoft.Extensions.FileProviders.Physical | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.0.symbols.nupkg
System.Reflection.Metadata | 6.0.0.nupkg
System.Resources.Extensions | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
runtime.osx-arm64.runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.Debug | 6.0.0.symbols.nupkg
dotnet-pgo | 6.0.0-rtm.21522.10.symbols.nupkg
System.Windows.Extensions | 6.0.0.nupkg
System.Threading.Tasks.Dataflow | 6.0.0.nupkg
System.Threading.Channels | 6.0.0.nupkg
System.Security.Permissions | 6.0.0.nupkg
System.Runtime.Caching | 6.0.0.nupkg
System.Security.Cryptography.Xml | 6.0.0.nupkg
System.Runtime.Experimental | 6.0.0.nupkg
System.Runtime.CompilerServices.Unsafe | 6.0.0.nupkg
System.ServiceModel.Syndication | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.0.symbols.nupkg
System.Windows.Extensions | 6.0.0.symbols.nupkg
System.Text.Json | 6.0.0.symbols.nupkg
System.ServiceProcess.ServiceController | 6.0.0.symbols.nupkg
System.Text.Encodings.Web | 6.0.0.symbols.nupkg
System.Security.Permissions | 6.0.0.symbols.nupkg
System.Runtime.Experimental | 6.0.0.symbols.nupkg
System.Data.Odbc | 6.0.0.symbols.nupkg
System.Composition.Hosting | 6.0.0.symbols.nupkg
System.Configuration.ConfigurationManager | 6.0.0.symbols.nupkg
System.Composition.Runtime | 6.0.0.symbols.nupkg
System.ComponentModel.Composition.Registration | 6.0.0.symbols.nupkg
System.Diagnostics.PerformanceCounter | 6.0.0.symbols.nupkg
System.Runtime.Caching | 6.0.0.symbols.nupkg
System.Reflection.MetadataLoadContext | 6.0.0.symbols.nupkg
System.Reflection.Metadata | 6.0.0.symbols.nupkg
System.Net.Http.WinHttpHandler | 6.0.0.symbols.nupkg
System.Formats.Asn1 | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.linux-arm.runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.0.nupkg
Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
System.Data.OleDb | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.0.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.0.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.0.nupkg
Microsoft.Extensions.Configuration.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 6.0.0.nupkg
System.Reflection.Context | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.BrowserDebugHost.Transport | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-x64.runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.Xml | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.Json | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration | 6.0.0.symbols.nupkg
Microsoft.Extensions.Caching.Memory | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.Ini | 6.0.0.symbols.nupkg
Microsoft.Extensions.Hosting | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.TraceSource | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.EventSource | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.EventLog | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.Configuration | 6.0.0.symbols.nupkg
System.Speech | 6.0.0.nupkg
System.Threading.AccessControl | 6.0.0.nupkg
System.Text.Json | 6.0.0.nupkg
System.Security.Cryptography.ProtectedData | 6.0.0.nupkg
System.ServiceProcess.ServiceController | 6.0.0.nupkg
ILCompiler.Reflection.ReadyToRun.Experimental | 6.0.0-rtm.21522.10.symbols.nupkg
System.Security.Cryptography.Pkcs | 6.0.0.nupkg
System.Security.AccessControl | 6.0.0.nupkg
dotnet-ilverify | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Ref | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.win-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.0.symbols.nupkg
System.CodeDom | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
System.Configuration.ConfigurationManager | 6.0.0.nupkg
runtime.win-x86.Microsoft.NETCore.TestHost | 6.0.0.nupkg
System.Memory.Data | 6.0.0.nupkg
System.IO.Ports | 6.0.0.nupkg
runtime.osx-arm64.runtime.native.System.IO.Ports | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.TestHost | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.0.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.0.nupkg
Microsoft.IO.Redist | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Composite | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.0.nupkg
Microsoft.Extensions.Configuration.Xml | 6.0.0.nupkg
Microsoft.Extensions.DependencyInjection | 6.0.0.nupkg
Microsoft.Extensions.Configuration.Ini | 6.0.0.nupkg
Microsoft.Extensions.Configuration.Json | 6.0.0.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 6.0.0.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Configuration.Binder | 6.0.0.nupkg
Microsoft.Extensions.Caching.Memory | 6.0.0.nupkg
Microsoft.Extensions.Caching.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.DependencyModel | 6.0.0.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Options | 6.0.0.nupkg
Microsoft.Extensions.Hosting.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.FileSystemGlobbing | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.Win32.SystemEvents | 6.0.0.symbols.nupkg
Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.osx-x64.runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
Microsoft.Extensions.FileProviders.Composite | 6.0.0.symbols.nupkg
Microsoft.Extensions.FileProviders.Physical | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 6.0.0.symbols.nupkg
Microsoft.Extensions.FileSystemGlobbing | 6.0.0.symbols.nupkg
Microsoft.ILVerification | 6.0.0.symbols.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 6.0.0.symbols.nupkg
Microsoft.Extensions.HostFactoryResolver.Sources | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.Extensions.Options | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Composite | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.0.symbols.nupkg
System.Text.Encoding.CodePages | 6.0.0.symbols.nupkg
System.Security.Cryptography.ProtectedData | 6.0.0.symbols.nupkg
System.Data.OleDb | 6.0.0.symbols.nupkg
System.Composition.Convention | 6.0.0.symbols.nupkg
System.Composition | 6.0.0.symbols.nupkg
System.Collections.Immutable | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
System.DirectoryServices.Protocols | 6.0.0.symbols.nupkg
System.Numerics.Tensors | 6.0.0-rtm.21522.10.nupkg
System.Net.Http.Json | 6.0.0.symbols.nupkg
System.IO.Packaging | 6.0.0.symbols.nupkg
System.IO.Hashing | 6.0.0.symbols.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 6.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
Microsoft.NETCore.TestHost | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.0.nupkg
System.IO.Hashing | 6.0.0.nupkg
System.Diagnostics.PerformanceCounter | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.linux-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.0.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.0.nupkg
Microsoft.Extensions.Hosting.Systemd | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Ref | 6.0.0.nupkg
Microsoft.NETCore.App.Host.win-x86 | 6.0.0.nupkg
Microsoft.NETCore.App.Host.win-x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
System.Reflection.MetadataLoadContext | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.win-x64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.0.symbols.nupkg
runtime.win-arm64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.TestHost | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 6.0.0.symbols.nupkg
Microsoft.Extensions.DependencyModel | 6.0.0.symbols.nupkg
Microsoft.Extensions.DependencyInjection | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.CommandLine | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.Binder | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Extensions.Caching.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Diagnostics.Tracing.EventSource.Redist | 6.0.0.symbols.nupkg
Microsoft.Extensions.Primitives | 6.0.0.symbols.nupkg
Microsoft.Extensions.Options.DataAnnotations | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.Console | 6.0.0.symbols.nupkg
Microsoft.Extensions.Http | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging | 6.0.0.symbols.nupkg
Microsoft.Internal.Runtime.AspNetCore.Transport | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.PGO | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.0.symbols.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.XmlSerializer.Generator | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.0.symbols.nupkg
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-arm64.runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.linux-arm.runtime.native.System.IO.Ports | 6.0.0.symbols.nupkg
runtime.linux-arm64.Microsoft.CrossOsDiag.Private.CoreCLR | 6.0.0-rtm.21522.10.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.0.symbols.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.0.symbols.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 6.0.0.symbols.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.Internal.Runtime.WindowsDesktop.Transport | 6.0.0-rtm.21522.10.symbols.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 6.0.0.symbols.nupkg
Microsoft.Extensions.Hosting.Systemd | 6.0.0.symbols.nupkg
System.Text.Encoding.CodePages | 6.0.0.nupkg
System.Text.Encodings.Web | 6.0.0.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.0.symbols.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 6.0.0.symbols.nupkg
Microsoft.dotnet-openapi | 6.0.0.symbols.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.0.symbols.nupkg
Microsoft.CodeAnalysis.Razor | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.0.symbols.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.0.symbols.nupkg
Microsoft.JSInterop | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.WebView | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.Authorization | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authorization | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Metadata | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 6.0.0.symbols.nupkg
dotnet-sql-cache | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client | 6.0.0.symbols.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.0.symbols.nupkg
Microsoft.Extensions.Localization.Abstractions | 6.0.0.symbols.nupkg
Microsoft.Extensions.Localization | 6.0.0.symbols.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.Analyzers | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.DataProtection | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Owin | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Ref | 6.0.0.symbols.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.0.symbols.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.0.symbols.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.0.symbols.nupkg
Microsoft.Authentication.WebAssembly.Msal | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.TestHost | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.0.symbols.nupkg
Microsoft.Extensions.ApiDescription.Server | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Common | 6.0.0.symbols.nupkg
Microsoft.Extensions.Http.Polly | 6.0.0.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.0.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.Web | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.Forms | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Components | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Razor.Language | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.JsonPatch | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Ref | 6.0.0.nupkg
AspNetCoreRuntime.6.0.x86 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.0.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.0.nupkg
Microsoft.CodeAnalysis.Razor | 6.0.0.nupkg
Microsoft.Authentication.WebAssembly.Msal | 6.0.0.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.0.nupkg
Microsoft.Extensions.WebEncoders | 6.0.0.nupkg
Microsoft.JSInterop | 6.0.0.nupkg
Microsoft.Extensions.Localization | 6.0.0.nupkg
Microsoft.Extensions.FileProviders.Embedded | 6.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 6.0.0.nupkg
Microsoft.AspNetCore.Components.Web | 6.0.0.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.0.nupkg
Microsoft.AspNetCore.Components.Analyzers | 6.0.0.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.0.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 6.0.0.nupkg
Microsoft.AspNetCore.Authorization | 6.0.0.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 6.0.0.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.0.nupkg
Microsoft.AspNetCore.Identity.UI | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.0.symbols.nupkg
AspNetCoreRuntime.6.0.x86 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.0.symbols.nupkg
Microsoft.Extensions.ApiDescription.Client | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SpaProxy | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.0.symbols.nupkg
Microsoft.Extensions.Caching.SqlServer | 6.0.0.symbols.nupkg
Microsoft.JSInterop.WebAssembly | 6.0.0.symbols.nupkg
Microsoft.Extensions.WebEncoders | 6.0.0.symbols.nupkg
Microsoft.Extensions.ObjectPool | 6.0.0.symbols.nupkg
Microsoft.Extensions.Identity.Stores | 6.0.0.symbols.nupkg
Microsoft.Extensions.FileProviders.Embedded | 6.0.0.symbols.nupkg
Microsoft.Extensions.Identity.Core | 6.0.0.symbols.nupkg
Microsoft.Extensions.Features | 6.0.0.symbols.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Mvc.Testing | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Identity.UI | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.HeaderPropagation | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.0.nupkg
Microsoft.AspNetCore.TestHost | 6.0.0.nupkg
Microsoft.AspNetCore.SpaProxy | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.0.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Client | 6.0.0.nupkg
Microsoft.AspNetCore.Razor.Language | 6.0.0.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.0.nupkg
Microsoft.AspNetCore.Components.WebView | 6.0.0.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.0.nupkg
Microsoft.AspNetCore.Components.Authorization | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.0.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.0.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.0.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.0.nupkg
Microsoft.AspNetCore.Metadata | 6.0.0.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 6.0.0.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.0.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.Google | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.0.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.0.nupkg
AspNetCoreRuntime.6.0.x64 | 6.0.0.nupkg
dotnet-sql-cache | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.0.symbols.nupkg
Microsoft.dotnet-openapi | 6.0.0.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.Google | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.0.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.0.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.0.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.0.nupkg
Microsoft.Extensions.Identity.Core | 6.0.0.nupkg
Microsoft.Extensions.Localization.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Http.Polly | 6.0.0.nupkg
Microsoft.Extensions.Features | 6.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.0.nupkg
Microsoft.Extensions.Identity.Stores | 6.0.0.nupkg
Microsoft.AspNetCore.Mvc.Testing | 6.0.0.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.0.nupkg
Microsoft.AspNetCore.Components | 6.0.0.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.0.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 6.0.0.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.0.nupkg
Microsoft.AspNetCore.HeaderPropagation | 6.0.0.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.0.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.0.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.0.nupkg
AspNetCoreRuntime.6.0.x64 | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.0.symbols.nupkg
Microsoft.AspNetCore.SignalR.Common | 6.0.0.nupkg
Microsoft.Extensions.ApiDescription.Server | 6.0.0.nupkg
Microsoft.Extensions.ApiDescription.Client | 6.0.0.nupkg
Microsoft.JSInterop.WebAssembly | 6.0.0.nupkg
Microsoft.Extensions.ObjectPool | 6.0.0.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 6.0.0.nupkg
Microsoft.Extensions.Caching.SqlServer | 6.0.0.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.0.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.0.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.0.nupkg
Microsoft.AspNetCore.Components.Forms | 6.0.0.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.0.nupkg
Microsoft.AspNetCore.Owin | 6.0.0.nupkg
Microsoft.AspNetCore.DataProtection | 6.0.0.nupkg
Microsoft.AspNetCore.JsonPatch | 6.0.0.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.0.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.100.symbols.nupkg
Microsoft.TemplateSearch.Common | 6.0.100.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Utils | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Abstractions | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Core | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.100.nupkg
Microsoft.TemplateEngine.Utils | 6.0.100.nupkg
Microsoft.DotNet.Common.ItemTemplates | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 6.0.100.nupkg
Microsoft.TemplateEngine.Core | 6.0.100.nupkg
Microsoft.DotNet.Common.ItemTemplates | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Core.Contracts | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Edge | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.IDE | 6.0.100.symbols.nupkg
Microsoft.TemplateSearch.Common | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.100.symbols.nupkg
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.100.symbols.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 6.0.100.nupkg
Microsoft.TemplateEngine.Abstractions | 6.0.100.nupkg
Microsoft.TemplateEngine.Edge | 6.0.100.nupkg
Microsoft.TemplateEngine.Core.Contracts | 6.0.100.nupkg
Microsoft.TemplateEngine.IDE | 6.0.100.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.100.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0 | 6.0.100.nupkg
Microsoft.DotNet.Compatibility | 1.0.0-rtm.21527.8.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64 | 6.0.0.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64 | 6.0.0.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100 | 6.0.0.nupkg
System.Web.Services.Description | 4.9.0.nupkg
System.ServiceModel.Security | 4.9.0.symbols.nupkg
System.ServiceModel.Primitives | 4.9.0.symbols.nupkg
System.ServiceModel.NetTcp | 4.9.0.symbols.nupkg
System.ServiceModel.Http | 4.9.0.symbols.nupkg
System.ServiceModel.Federation | 4.9.0.symbols.nupkg
System.ServiceModel.Duplex | 4.9.0.symbols.nupkg
System.Private.ServiceModel | 4.9.0.symbols.nupkg
System.ServiceModel.Security | 4.9.0.nupkg
System.ServiceModel.Primitives | 4.9.0.nupkg
System.ServiceModel.NetTcp | 4.9.0.nupkg
System.ServiceModel.Http | 4.9.0.nupkg
System.ServiceModel.Federation | 4.9.0.nupkg
System.ServiceModel.Duplex | 4.9.0.nupkg
System.Private.ServiceModel | 4.9.0.nupkg
System.Web.Services.Description | 4.9.0.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 6.0.0.symbols.nupkg
Microsoft.Data.Sqlite.Core | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Tools | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Relational | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Design | 6.0.0.symbols.nupkg
Microsoft.Data.Sqlite | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.0.nupkg
dotnet-ef | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.InMemory | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.0.nupkg
Microsoft.EntityFrameworkCore | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 6.0.0.nupkg
Microsoft.Data.Sqlite.Core | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.InMemory | 6.0.0.nupkg
Microsoft.EntityFrameworkCore | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Proxies | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Tools | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 6.0.0.nupkg
dotnet-ef | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.0.symbols.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Proxies | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Relational | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.0.nupkg
Microsoft.EntityFrameworkCore.Design | 6.0.0.nupkg



[//]: # ( Runtime 6.0.0)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcd635a9-6caf-4958-b3df-01e1c204ca1e/b201804d05de9573a8b454bccac56482/dotnet-runtime-6.0.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e59e190b-fceb-481e-9d82-f1e0660a0a72/3961d79c2fe1e8a2ee8ff3b1bb5e8472/dotnet-runtime-6.0.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f531185-7535-4a8f-bce0-ee89dc86b5c0/979fdd2cb39e1fdf03eba60cc444b18c/dotnet-runtime-6.0.0-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17fb4f70-19be-4302-b180-32f33bd2f907/18f38ef59bcc82a3c78eba6f36ee0e76/dotnet-runtime-6.0.0-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95352809-7f41-40f3-974d-8d530321a8e4/0024d7bf0c872f176ceba7a63a34915b/dotnet-runtime-6.0.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ce1c34f-0d9e-4d9b-964e-da676c8e605a/7a6c353b36477fa84f85b2821f2350c2/dotnet-runtime-6.0.0-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1bc784af-565c-42d5-8db2-9988c8d2b65f/644cea0fe2f712ad297b6eb49147f446/dotnet-runtime-6.0.0-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/358b0203-a499-4675-9e53-220349a0a093/4265e02ca29fed442acaf5b46142c583/dotnet-runtime-6.0.0-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/03e62824-4061-45dc-8777-93e82205148d/81489074c065675bd713a9cbeb995bef/dotnet-runtime-6.0.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d88f74a5-05d2-46cb-886a-a62fd698009d/67f5f05e9c029d284c309f0f712fc99f/dotnet-runtime-6.0.0-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f1a97c74-826c-4920-b629-605b0ed7187e/45dfca473522ce4436ba002bcea4117d/dotnet-runtime-6.0.0-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d52959e1-f458-41b2-b273-acedd32c942f/0c4aa30089132acafebddc9eafa3621b/dotnet-runtime-6.0.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b9cfdb9e-d5cd-4024-b318-00390b729d2f/65690f2440f40654898020cdfffa1050/dotnet-runtime-6.0.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6b96c97d-9b8c-4141-a32a-5848d3369dbf/9972321cb7af5938fecdee2d8ebd72bb/dotnet-runtime-6.0.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/34df41d5-c813-4e30-8aa3-3603ce6600c0/976e801af82c7108abbcb736a8bc5c14/dotnet-runtime-6.0.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e6204240-04d8-4a74-bbc2-0815d6959ed9/050721f551cf2592e5bc58ee1d7fe0a3/dotnet-runtime-6.0.0-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/85cdb1b5-c57e-4986-8cf9-43f576d5487c/56ae11aff306810e3711032a19221282/windowsdesktop-runtime-6.0.0-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a865ccae-2219-4184-bcd6-0178dc580589/ba452d37e8396b7a49a9adc0e1a07e87/windowsdesktop-runtime-6.0.0-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a1ca7d0d-ce01-4878-b952-3fa1e6d9a7c6/e386db367490b631b8c013a9fb0f3794/windowsdesktop-runtime-6.0.0-win-x86.exe

[//]: # ( ASP 6.0.0)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b86e414a-929a-42a5-ba18-45ad2ebe292f/3617879c51e87fe70073006bf2d60386/aspnetcore-runtime-6.0.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d49ea48-675e-4da9-87be-18efaa99d7f6/37807ed5012ba5e0511e08ad64d6a9a4/aspnetcore-runtime-6.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32cfa097-2034-4085-a287-3afffdfec919/13e845b9a3d09049f0428a5148263ec6/aspnetcore-runtime-6.0.0-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72200217-3146-4fc3-a525-865e04a88bb3/c51b99bb6f5ede435c7ade7721468301/aspnetcore-runtime-6.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a757153c-6675-4d63-a979-de2f4fede0d4/baa9ed8b963c49d69c725b57352b051d/aspnetcore-runtime-6.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8dd1c9d-1a47-4135-8ad8-7091ff6bbe1e/6af53c3eee71038248937daf4599f06a/aspnetcore-runtime-6.0.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1bbb490-81bc-49ef-8d03-e12a4d4e84e5/d7aa3d571d82d5bc6c2095038ba0a7bb/aspnetcore-runtime-6.0.0-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27e5cf62-0d07-44cd-a057-425887434b9e/5f87e0c4d9be2151a2d0c9efc4530751/aspnetcore-runtime-6.0.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dc328d93-5123-489d-89fd-cbf517fb9268/c5052ee4f415389d1a9809be868cde95/aspnetcore-runtime-6.0.0-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3223fa10-441d-406b-af2e-94874ce38199/09347f9b4aea0ab34d6944b6b78fa29d/aspnetcore-runtime-6.0.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3cc56ba5-399e-455a-9e36-3d384e1af246/92cc0b1f002350c18262a06f5a99bbc1/aspnetcore-runtime-6.0.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7f757d80-b065-430e-ba65-7e95c3ec95e1/4d0335985f09db0650bbf9efe773f46c/aspnetcore-runtime-6.0.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/093689c2-3ebb-4513-aacd-d7050a4e9a62/556d1a63174a557bb46903945e8d7e53/aspnetcore-runtime-6.0.0-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c5971600-d95e-46b4-b99f-c75dad919237/25469268adf8be3d438355793ecb11da/dotnet-hosting-6.0.0-win.exe

[//]: # ( SDK 6.0.100)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f85b038-9917-4d0a-8485-5dc86510eec7/a7555924fe292c6c2140893f066abe65/dotnet-sdk-6.0.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/adcd9310-5072-4179-9b8b-16563b897995/15a7595966f488c74909e4a9273c0e24/dotnet-sdk-6.0.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/910901ba-4068-40a4-a6e2-2f25c82c2cdf/9ad0936c71b096bc057a3ce7fb7f3bd6/dotnet-sdk-6.0.100-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/464717f7-cd60-49d3-9658-f471262dc3b8/d5c97064d0bdd7bf82eb7b96cc2bab7d/dotnet-sdk-6.0.100-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb523fba-7eb0-49ff-8214-c78c65dae090/7e7f9798ee57bf93649ada3eb13a79ae/dotnet-sdk-6.0.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17b6759f-1af0-41bc-ab12-209ba0377779/e8d02195dbf1434b940e0f05ae086453/dotnet-sdk-6.0.100-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ed60d37e-7842-4fc2-8250-2bd66073d79e/725d486e04d27e45d2b41c687dc35f49/dotnet-sdk-6.0.100-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f1e67c2-11a4-416b-8421-786e47b82fdf/af56581d96e15ed911cf3a172f3c8802/dotnet-sdk-6.0.100-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/14a45451-4cc9-48e1-af69-0aff75891d09/ff6e83986a2a9a535015fb3104a90a1b/dotnet-sdk-6.0.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62f78047-71de-460e-85ca-254f1fa848de/ecabeefdca2902f3f06819612cd9d45c/dotnet-sdk-6.0.100-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f4962800-2c72-46e5-a1ae-84006fd0ea1a/aa43e8518fdfb97226b06c83293cf016/dotnet-sdk-6.0.100-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2d1846a9-6604-4535-9d63-39a069eac897/ecd34c29a558e25865c8ddc5bb5fcaea/dotnet-sdk-6.0.100-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f71eaf1-ce85-480b-8e11-c3e2725b763a/9044bfd1c453e2215b6f9a0c224d20fe/dotnet-sdk-6.0.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ca65b248-9750-4c2d-89e6-ef27073d5e95/05c682ca5498bfabc95985a4c72ac635/dotnet-sdk-6.0.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a95baae6-2e83-4242-af31-6ed6f9541c28/c809b854b2dc5d76476c59257319cf97/dotnet-sdk-6.0.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c91c6641-580a-4b7d-a89a-5ed0e15bc318/f35ebceebbb06374734d1c238036e504/dotnet-sdk-6.0.100-win-x86.zip


