# .NET 6.0.11 - November 08, 2022

The .NET 6.0.11, [.NET SDK 6.0.111](6.0.111.md), and [.NET SDK 6.0.306](6.0.306.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.403
```

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.11 release carries non-security fixes.

### Additional fixes in this release
* [Aspnetcore](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.11+is%3Aclosed+label%3Aservicing-approved+)
* [SDK](https://github.com/dotnet/sdk/issues?q=milestone%3A6.0.11+is%3Aclosed+label%3Aservicing-approved+)


## Visual Studio Compatibility

You need [Visual Studio 17.3](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #xxxx](https://github.com/dotnet/core/issues/xxxx) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.11/6.0.11.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.11-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.11-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/november-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.11
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.11
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.11
Microsoft.WindowsDesktop.App.Ref| 6.0.11
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.11
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.11
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.11
Microsoft.NETCore.App.Host.osx-arm64| 6.0.11
Microsoft.NETCore.App.Host.win-arm| 6.0.11
Microsoft.NETCore.App.Host.win-arm64| 6.0.11
Microsoft.NETCore.App.Host.win-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.win-x86| 6.0.11
Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.11
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.11
Microsoft.NETCore.App.Host.linux-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.win-x64| 6.0.11
Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.11
Microsoft.Windows.Compatibility| 6.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.11
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.11
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400.Msi.x86| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.11
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.11
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.11
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.11
Microsoft.Extensions.Logging.Abstractions| 6.0.3
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.11
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.11
Microsoft.NETCore.App.Host.linux-arm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.11
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.11
Microsoft.NETCore.App.Composite| 6.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.11
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.11
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.11
Microsoft.NETCore.App.Host.win-x86| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.11
Microsoft.NETCore.App.Ref| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm| 6.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
System.Text.Json| 6.0.7
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.11
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.11
Microsoft.NETCore.App.Host.linux-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.11
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.11
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.11
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.11
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.400| 6.0.11
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.11
Microsoft.NETCore.App.Host.osx-x64| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.11
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.11
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.11
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.11
Microsoft.NETCore.DotNetAppHost| 6.0.11
Microsoft.NETCore.DotNetHost| 6.0.11
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.11
Microsoft.NETCore.Platforms| 6.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.11
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.11
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.11
AspNetCoreRuntime.6.0.x86| 6.0.11
dotnet-sql-cache| 6.0.11
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.11
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.11
Microsoft.CodeAnalysis.Razor| 6.0.11
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.11
Microsoft.Extensions.ApiDescription.Client| 6.0.11
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.11
Microsoft.Extensions.Caching.SqlServer| 6.0.11
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.11
Microsoft.JSInterop| 6.0.11
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.11
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.11
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.11
AspNetCoreRuntime.6.0.x64| 6.0.11
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.11
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.11
Microsoft.AspNetCore.Authentication.Twitter| 6.0.11
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.11
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.11
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.11
Microsoft.AspNetCore.Components.Authorization| 6.0.11
Microsoft.AspNetCore.Components.WebAssembly| 6.0.11
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.11
Microsoft.AspNetCore.Components.WebView| 6.0.11
Microsoft.AspNetCore.Connections.Abstractions| 6.0.11
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.11
Microsoft.AspNetCore.Cryptography.Internal| 6.0.11
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.11
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.11
Microsoft.JSInterop.WebAssembly| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.11
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.11
Microsoft.AspNetCore.Authentication.Certificate| 6.0.11
Microsoft.AspNetCore.Authentication.Facebook| 6.0.11
Microsoft.AspNetCore.Authentication.Google| 6.0.11
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.11
Microsoft.AspNetCore.Components| 6.0.11
Microsoft.AspNetCore.Components.Analyzers| 6.0.11
Microsoft.AspNetCore.Components.Web| 6.0.11
Microsoft.AspNetCore.Components.Forms| 6.0.11
Microsoft.AspNetCore.HeaderPropagation| 6.0.11
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.11
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.11
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.11
Microsoft.AspNetCore.App.Ref| 6.0.11
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.11
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.11
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.11
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.11
Microsoft.AspNetCore.Identity.UI| 6.0.11
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.11
Microsoft.AspNetCore.Metadata| 6.0.11
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.11
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.11
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.11
Microsoft.AspNetCore.SignalR.Client| 6.0.11
Microsoft.AspNetCore.SignalR.Common| 6.0.11
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.11
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.11
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.11
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.11
Microsoft.AspNetCore.SpaProxy| 6.0.11
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.11
Microsoft.AspNetCore.TestHost| 6.0.11
Microsoft.dotnet-openapi| 6.0.11
Microsoft.Extensions.Http.Polly| 6.0.11
Microsoft.Extensions.Identity.Stores| 6.0.11
Microsoft.Extensions.Localization| 6.0.11
Microsoft.Extensions.Localization.Abstractions| 6.0.11
Microsoft.Extensions.Logging.AzureAppServices| 6.0.11
Microsoft.Extensions.ObjectPool| 6.0.11
Microsoft.Extensions.WebEncoders| 6.0.11
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.11
Microsoft.AspNetCore.Authorization| 6.0.11
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.11
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.11
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.11
Microsoft.AspNetCore.DataProtection| 6.0.11
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.11
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.11
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.11
Microsoft.AspNetCore.Http.Connections.Client| 6.0.11
Microsoft.AspNetCore.Http.Connections.Common| 6.0.11
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.11
Microsoft.AspNetCore.JsonPatch| 6.0.11
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.11
Microsoft.AspNetCore.Mvc.Testing| 6.0.11
Microsoft.AspNetCore.Owin| 6.0.11
Microsoft.AspNetCore.Razor.Language| 6.0.11
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.11
Microsoft.Authentication.WebAssembly.Msal| 6.0.11
Microsoft.Extensions.ApiDescription.Server| 6.0.11
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.11
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.11
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.11
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.11
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.11
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.11
Microsoft.Extensions.FileProviders.Embedded| 6.0.11
Microsoft.Extensions.Features| 6.0.11
Microsoft.Extensions.Identity.Core| 6.0.11
Microsoft.TemplateEngine.Edge| 6.0.111
Microsoft.TemplateEngine.IDE| 6.0.111
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.111
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.111
Microsoft.TemplateEngine.Utils| 6.0.111
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.111
Microsoft.TemplateEngine.Core| 6.0.111
Microsoft.TemplateEngine.Core.Contracts| 6.0.111
Microsoft.DotNet.Common.ItemTemplates| 6.0.111
Microsoft.TemplateEngine.Abstractions| 6.0.111
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.111
Microsoft.TemplateSearch.Common| 6.0.111
Microsoft.DotNet.Compatibility| 1.0.0-servicing.22523.21
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.arm64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x86| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400.Msi.x64| 6.0.11
Microsoft.NET.Workload.Emscripten.Manifest-6.0.400| 6.0.11
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.11
Microsoft.Data.Sqlite| 6.0.11
Microsoft.EntityFrameworkCore| 6.0.11
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.11
Microsoft.Data.Sqlite.Core| 6.0.11
Microsoft.EntityFrameworkCore.Cosmos| 6.0.11
Microsoft.EntityFrameworkCore.Abstractions| 6.0.11
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.11
Microsoft.EntityFrameworkCore.Analyzers| 6.0.11
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.11
Microsoft.EntityFrameworkCore.Design| 6.0.11
Microsoft.EntityFrameworkCore.Relational| 6.0.11
dotnet-ef| 6.0.11
Microsoft.EntityFrameworkCore.Proxies| 6.0.11
Microsoft.EntityFrameworkCore.InMemory| 6.0.11
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.11
Microsoft.EntityFrameworkCore.Tools| 6.0.11
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.11
Microsoft.EntityFrameworkCore.Sqlite| 6.0.11
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.11
Microsoft.EntityFrameworkCore.SqlServer| 6.0.11
Microsoft.TemplateEngine.Utils| 6.0.306
Microsoft.TemplateEngine.IDE| 6.0.306
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.306
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.306
Microsoft.TemplateSearch.Common| 6.0.306
Microsoft.DotNet.Common.ItemTemplates| 6.0.306
Microsoft.TemplateEngine.Core| 6.0.306
Microsoft.TemplateEngine.Abstractions| 6.0.306
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.306
Microsoft.TemplateEngine.Edge| 6.0.306
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.306
Microsoft.TemplateEngine.Core.Contracts| 6.0.306
FSharp.Compiler.Service| 41.0.5
FSharp.Core| 6.0.5
Microsoft.TemplateSearch.Common| 6.0.403
Microsoft.TemplateEngine.Utils| 6.0.403
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.403
Microsoft.TemplateEngine.Core.Contracts| 6.0.403
Microsoft.TemplateEngine.Edge| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.2.0| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.2.1| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.2.2| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.3.0| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.3.1| 6.0.403
Microsoft.TemplateEngine.Core| 6.0.403
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.403
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.403
Microsoft.DotNet.Common.ItemTemplates| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.1.x| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.5.0| 6.0.403
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.403
Microsoft.TemplateEngine.Abstractions| 6.0.403
Microsoft.TemplateEngine.IDE| 6.0.403
FSharp.Compiler.Service| 41.0.7
FSharp.Core| 6.0.7

[//]: # ( Runtime 6.0.11)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e208f394-bcb6-4ea9-8865-9fa2ed065d0a/5214d4e078744bbb3eea12c259b1d8cd/dotnet-runtime-6.0.11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b02be36b-8470-4b81-8254-1f957ce8f397/fd6aa0da17fc51c1b57b2d96aa792c1a/dotnet-runtime-6.0.11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d83b1773-36fb-49b2-a174-d58ae71ca6a7/1710ad32b6c06ac29d32ba1c4232316d/dotnet-runtime-6.0.11-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/376cf0f2-7ae0-41c5-96b2-5bc9e525b340/18a5bf90b171aa0b84f30674981e86f2/dotnet-runtime-6.0.11-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/acc2d4e9-6ee9-4d2a-a61d-0ed4fd64237a/6624c2043683bbb9a3af470634d22ce7/dotnet-runtime-6.0.11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/367108bb-8782-4f0b-839d-c98191b7729a/94185f91ef33890816a5846a374b74b7/dotnet-runtime-6.0.11-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/340274ea-9cf6-47e6-9fb5-920675a5d701/8c0acf90a29b1a7d2ce662ce66228a14/dotnet-runtime-6.0.11-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6fde4997-8628-4666-8281-6aef1322cda3/f9ead70f42ef845bbc5c17d53b174931/dotnet-runtime-6.0.11-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3acbb93d-3983-4a98-9295-0c7045cec479/1b33b6742a6bf35fd46bd88a6d56f2ee/dotnet-runtime-6.0.11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9bd7b7d-8dbd-4486-b3a6-d3bd29e9efc1/4b2debd5a8aa0812cbe19cc6cae26066/dotnet-runtime-6.0.11-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3c7b353f-a4e7-4592-9535-0077ef420e7e/334ab6dadc68e53db13d53ebdf112ba3/dotnet-runtime-6.0.11-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/566af894-00df-406a-80c1-ef41e51ae695/f402b81c3bfbb91d76587a75480e85b6/dotnet-runtime-6.0.11-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8cf88855-ed09-4002-95db-8bb0f0eff051/f9006645511830bd3b840be132423768/dotnet-runtime-6.0.11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b7ca200f-345c-4ad8-8a27-6d724aaf9c65/108b558841a28ffe45bacd2570a30c02/dotnet-runtime-6.0.11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/719bfd7c-bce2-4e73-937c-cbd7a7ace3cb/d4f570d461711d22e277f1e3487ea9c2/dotnet-runtime-6.0.11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/be0f3c66-a6b8-47eb-85fe-1085bd5bbcbc/8b095919bea25340fbddc43ed0eefef5/dotnet-runtime-6.0.11-win-x86.zip

[//]: # ( WindowsDesktop 6.0.11)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/70d9846e-7bae-496c-829d-dabfda93cddd/be9e28ef860bfc7f8f36db4af4ac7692/windowsdesktop-runtime-6.0.11-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/71c160b2-8d92-4ecd-89bc-eb1822abbb73/8593a31d4e1c60873e94a618227502fb/windowsdesktop-runtime-6.0.11-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0192a249-3ec8-4374-a827-e186dd58d55d/cec046575f3eb2247a10ba3d50f5cf6c/windowsdesktop-runtime-6.0.11-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b272a567-e03f-432a-8263-7672e9a41c5d/d4b547aaa09b72fe1e2ed081d59c33b5/windowsdesktop-runtime-6.0.11-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2a392287-fd51-4ee8-9c15-a672ab9bc55d/03d4784b3a543a0fb9ce5677ed13a9a3/windowsdesktop-runtime-6.0.11-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a08358ae-373f-40c4-88c9-732a7da52bc4/0e0bf1005fea65d0d7026306ffc539bd/windowsdesktop-runtime-6.0.11-win-x86.zip

[//]: # ( ASP 6.0.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4072393d-3350-41d2-98e2-dc46fd930fae/6f09e1d7685fbbc01f6d84b1140e1b49/aspnetcore-runtime-6.0.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e25f7ff2-9932-41dd-b549-5b4409b5a727/d00786aeabad50cd661e959a576f8777/aspnetcore-runtime-6.0.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c955c105-704f-423e-9f55-e51957c901f6/3f0361570417e8d32659993a4ff638ba/aspnetcore-runtime-6.0.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6505deb-44ce-4593-89e7-4460042ef675/3e4dcd3221be077cb71e459ed6e89362/aspnetcore-runtime-6.0.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/957274ab-b5ad-495b-947a-0db38e641e84/d089c36fa5c8d2aa76c7e7abc45f5e29/aspnetcore-runtime-6.0.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a17a9f6-7705-4b47-aead-c0b582cad317/158b62e5183281e416994d56ce81bc0c/aspnetcore-runtime-6.0.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bb8e524-4a1c-403b-adef-362e13b22fcf/6304e6772640e07412ccfb9a0a5ec58a/aspnetcore-runtime-6.0.11-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16a48ca7-a75f-48bf-a513-ce5721debde1/b55c60cfbac77c576fb0161a4d4ad8af/aspnetcore-runtime-6.0.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/efa86583-806b-44e7-9ade-45b0ea845b86/fe160dc809fbcbbace542198f1b29ea0/aspnetcore-runtime-6.0.11-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e874914f-d43d-4b61-8479-f6a5536e44b1/7043adfe896aa9f980ce23e884aae37d/aspnetcore-runtime-6.0.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/05dbe2dd-429c-4e4a-8080-9fe3027cd31b/76461b8691ada05d098efd15933bcbbd/aspnetcore-runtime-6.0.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/94504599-143a-4d53-b518-74aee0ebecca/dac4a7b1f7bdc7b4e8441d6befa4941a/aspnetcore-runtime-6.0.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cba21318-714e-4390-a4e7-10ae69a280b2/e8cb7203c321951c0acfbef160ad23d4/aspnetcore-runtime-6.0.11-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/db07eed5-297a-45b8-bea2-1e93c623a88c/6e5a8d3432e6213f071be3751ae53a08/dotnet-hosting-6.0.11-win.exe

[//]: # ( SDK 6.0.403)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10cadabb-4cb4-4cca-94db-67cb31cb6f3a/5b3d102b4198da0a25ed12d83ae5633d/dotnet-sdk-6.0.403-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67ca3f83-3769-4cd8-882a-27ab0c191784/bf631a0229827de92f5c026055218cc0/dotnet-sdk-6.0.403-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/035f9d69-66ab-4085-b821-9610b464f222/1c2ae5abba2d11dc77b2beece41c5100/dotnet-sdk-6.0.403-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8019613a-7cff-4169-a996-1d11786cd97f/62604cf6ee5171e5d97755567e9645d9/dotnet-sdk-6.0.403-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5e6c72e-457c-406c-a4a8-6a4fcdd5f50c/feaa81a666c8942064453fb3c456856b/dotnet-sdk-6.0.403-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d2007d3-da35-48ad-80cc-a39cbc726908/1f3555baa8b14c3327bb4eaa570d7d07/dotnet-sdk-6.0.403-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1d1846e3-8e51-4b83-83b5-2d00c384a8ed/62a4a23c59d97114a2156fe1736ee975/dotnet-sdk-6.0.403-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e825e710-a4ac-4bf8-9777-36aaed9ba8fc/1dbf807664c030ffe386453ed35030fb/dotnet-sdk-6.0.403-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bc5cc4ae-e1e8-43fb-9471-cf6469f8db98/0033246d9e1bbc9af3952d602af68c50/dotnet-sdk-6.0.403-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fdbd3d94-ea79-44c9-bf84-ca161871ee50/6e4b47c4926e30251a178014fe3da399/dotnet-sdk-6.0.403-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/eb2ed5a3-fdc6-434e-ac15-5280e5c0cc5e/77f60f46fc8c8167531eaa4ca3603573/dotnet-sdk-6.0.403-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c519d41-d45c-4225-886a-a7dfc9c6e289/fab8422cf174b5853246a1093b3df83f/dotnet-sdk-6.0.403-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/08ada4db-1e64-4829-b36d-5beb71f67bff/b77050cf7e0c71d3b95418651db1a9b8/dotnet-sdk-6.0.403-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e4c38e2f-07a2-4ab7-9607-369dc406f0d5/d1bef72f340bb2f3fb10e5ec92561f21/dotnet-sdk-6.0.403-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c2bf9927-2746-4126-b839-1080b360f348/17191138699683165a20fde56571f433/dotnet-sdk-6.0.403-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a763be08-256f-403b-ae11-6c831d63cc37/e792e24983079722f3f66509bbc9487e/dotnet-sdk-6.0.403-win-x86.zip
