# .NET 6.0.2 - February 8, 2022

The .NET 6.0.2 and .NET 6.0.102 SDK releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.102
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
# Microsoft Security Advisory CVE-2022-21986 | .NET Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET 5.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Denial of Service vulnerability exists in .NET 6.0 and .NET 5.0 when the Kestrel web server processes certain HTTP/2 and HTTP/3 requests.

Release feature and bug lists:

* [ASP.NET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A6.0.2+is%3Aclosed+label%3Aservicing-approved+)
* [EFCore](https://github.com/dotnet/efcore/issues?q=milestone%3A6.0.2+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.2+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.2+is%3Aclosed+label%3Aservicing-approved+)


## Visual Studio Compatibility

You need [Visual Studio 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7172](https://github.com/dotnet/core/issues/7172) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.2/6.0.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 6.0.2.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 6.0.2.nupkg
System.IO.Pipelines | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Host.osx-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.Extensions.Caching.Memory | 6.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 6.0.2.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Composite | 6.0.2.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono | 6.0.2.nupkg
Microsoft.Extensions.Hosting | 6.0.1.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 6.0.1.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 6.0.1.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk | 6.0.2.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 6.0.2.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 6.0.2.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
System.Text.Json | 6.0.2.nupkg
System.DirectoryServices.Protocols | 6.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86 | 6.0.2.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
Microsoft.NETCore.App.Ref | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 6.0.2.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 6.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 6.0.2.nupkg
System.IO.Hashing | 6.0.1.nupkg
System.Runtime.Experimental | 6.0.1.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.linux-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 6.0.2.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 6.0.2.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 6.0.2.nupkg
AspNetCoreRuntime.6.0.x86 | 6.0.2.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 6.0.2.nupkg
dotnet-sql-cache | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 6.0.2.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0 | 6.0.2.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 6.0.2.nupkg
Microsoft.CodeAnalysis.Razor | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 6.0.2.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 6.0.2.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 6.0.2.nupkg
Microsoft.Extensions.ApiDescription.Client | 6.0.2.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 6.0.2.nupkg
Microsoft.Extensions.Identity.Stores | 6.0.2.nupkg
Microsoft.Extensions.ObjectPool | 6.0.2.nupkg
Microsoft.Extensions.FileProviders.Embedded | 6.0.2.nupkg
Microsoft.Extensions.Localization | 6.0.2.nupkg
Microsoft.Extensions.Identity.Core | 6.0.2.nupkg
Microsoft.Extensions.Features | 6.0.2.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Forms | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection | 6.0.2.nupkg
Microsoft.AspNetCore.Identity.UI | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 6.0.2.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 6.0.2.nupkg
Microsoft.JSInterop.WebAssembly | 6.0.2.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 6.0.2.nupkg
Microsoft.AspNetCore.App.Ref | 6.0.2.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0 | 6.0.2.nupkg
Microsoft.AspNetCore.SpaProxy | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Common | 6.0.2.nupkg
Microsoft.Extensions.WebEncoders | 6.0.2.nupkg
Microsoft.JSInterop | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Web | 6.0.2.nupkg
Microsoft.AspNetCore.Authorization | 6.0.2.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 6.0.2.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.Metadata | 6.0.2.nupkg
Microsoft.AspNetCore.HeaderPropagation | 6.0.2.nupkg
Microsoft.AspNetCore.JsonPatch | 6.0.2.nupkg
AspNetCoreRuntime.6.0.x64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.Google | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 6.0.2.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 6.0.2.nupkg
Microsoft.dotnet-openapi | 6.0.2.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 6.0.2.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0 | 6.0.2.nupkg
Microsoft.AspNetCore.TestHost | 6.0.2.nupkg
Microsoft.Authentication.WebAssembly.Msal | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 6.0.2.nupkg
Microsoft.AspNetCore.SignalR.Client | 6.0.2.nupkg
Microsoft.Extensions.ApiDescription.Server | 6.0.2.nupkg
Microsoft.Extensions.Caching.SqlServer | 6.0.2.nupkg
Microsoft.Extensions.Http.Polly | 6.0.2.nupkg
Microsoft.Extensions.Localization.Abstractions | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 6.0.2.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 6.0.2.nupkg
Microsoft.AspNetCore.Razor.Language | 6.0.2.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 6.0.2.nupkg
Microsoft.AspNetCore.Components.WebView | 6.0.2.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 6.0.2.nupkg
Microsoft.AspNetCore.Components | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Authorization | 6.0.2.nupkg
Microsoft.AspNetCore.Components.Analyzers | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Testing | 6.0.2.nupkg
Microsoft.AspNetCore.Owin | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 6.0.2.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 6.0.2.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 6.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 6.0.2.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 6.0.2.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 6.0.2.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 6.0.2.nupkg
Microsoft.TemplateEngine.IDE | 6.0.102.nupkg
Microsoft.TemplateEngine.Core | 6.0.102.nupkg
Microsoft.TemplateSearch.Common | 6.0.102.nupkg
Microsoft.TemplateEngine.Utils | 6.0.102.nupkg
Microsoft.TemplateEngine.Core.Contracts | 6.0.102.nupkg
Microsoft.TemplateEngine.TemplateLocalizer | 6.0.102.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 6.0.102.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core | 6.0.102.nupkg
Microsoft.DotNet.Common.ItemTemplates | 6.0.102.nupkg
Microsoft.TemplateEngine.Abstractions | 6.0.102.nupkg
Microsoft.TemplateEngine.Edge | 6.0.102.nupkg
Microsoft.DotNet.Compatibility|1.0.0-servicing.22069.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Tools | 6.0.2.nupkg
dotnet-ef | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Design | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Proxies | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.InMemory | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 6.0.2.nupkg
Microsoft.Data.Sqlite | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 6.0.2.nupkg
Microsoft.Data.Sqlite.Core | 6.0.2.nupkg
Microsoft.EntityFrameworkCore | 6.0.2.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 6.0.2.nupkg






[//]: # ( Runtime 6.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbc7f55f-9a43-498c-a7f0-ad589c64d7d4/e48b95570140a2d9ba460ef9c98f6b1c/dotnet-runtime-6.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8555e038-2eb9-4042-a3dc-7453ec204a56/bb90dd8837905df3c4351ea2e9ee313d/dotnet-runtime-6.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/596ee18d-ca60-4f8c-9911-b1e8b719d8fc/cf5e9e0e7a19eee8d7c552a820b36610/dotnet-runtime-6.0.2-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79cd34f1-f6ac-4221-a9bc-eebcbc1dc841/c3947f70db237e28a803e32ea251495b/dotnet-runtime-6.0.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5909f754-76d2-4035-b3f9-e38e584701a4/8a5393e487d19a13e5f627e97220d1f1/dotnet-runtime-6.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eec7db31-0187-4751-88ec-53ea526d4d35/d183e3973cc9a4b988cd4d1184db433f/dotnet-runtime-6.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5394003a-5562-49f6-b3ae-10c4a7c24a2b/842e6bf147bfe393c6b1abe668762f91/dotnet-runtime-6.0.2-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08eec5d9-8351-4fe2-a72d-e07e8d47dee3/eed47ab0aff7727bd6e9dab00f82ac55/dotnet-runtime-6.0.2-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/26d5913f-8f8b-4894-a548-f9612b34f669/4765d40fddb545a7437812ae4d6efe12/dotnet-runtime-6.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/80757dcc-b60f-4889-b57f-6c26e52e1083/7aca1905ea34bc25eddf676ba90c8206/dotnet-runtime-6.0.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f121418a-ccef-43a6-b3dd-bcff9c88d55a/e81d8ae35ba77d4123807a47d3d1cfa5/dotnet-runtime-6.0.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2eb18952-6661-4492-bbfb-3413305558fe/2892dfa468ddb50887bad1949d24c0f3/dotnet-runtime-6.0.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0b3e8ad9-7914-4489-8d02-58b551c2efea/fdc3f3a171bf0b7bb90c01f5faa59fc4/dotnet-runtime-6.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/440412ac-a97b-41ef-82e5-d94b37faaca8/aea4a8e256bf1a302009600acb7b4f78/dotnet-runtime-6.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2c266f64-4c86-4209-8113-0146a9c93bef/f771275c8cb0df884dcfc290569fba3a/dotnet-runtime-6.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/00b9a13e-2510-43bc-9a42-5790cff4c488/953da2cc952fa0147b2269c4fa099e7f/dotnet-runtime-6.0.2-win-x86.zip

[//]: # ( WindowsDesktop 6.0.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/477d9d58-a6b5-41b9-8ce9-bb1791aa54d3/8a3f2a2f843b2198b5d9cdd279dc2051/windowsdesktop-runtime-6.0.2-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7fbe3ce3-4082-4995-93de-674038ac919b/56d3fa94d78dc3f39fc70d73ef174c93/windowsdesktop-runtime-6.0.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f5f7ed62-0973-400b-9772-4cf0eef96801/87959c77e1fceeafc40c867f9c238bbc/windowsdesktop-runtime-6.0.2-win-x86.exe

[//]: # ( ASP 6.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7e77f1a-db9d-403f-a611-f925cea0e6f3/af5baacfa05d023671f08bf14f98bcb2/aspnetcore-runtime-6.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51b8de3c-7f68-46cd-96dd-de822855d744/cd8ed6f4342d294df04720006d0eba61/aspnetcore-runtime-6.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2868e1e3-2c17-4e9e-9061-544b91b2a5fb/183bf6cd4c953d4364a23a69c586d962/aspnetcore-runtime-6.0.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76f3bb77-ca89-40a9-a183-27ec34b404e0/c4e0d6a04184a1e68cdd98af72cd32e6/aspnetcore-runtime-6.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34c656ac-3a46-4bcf-98c9-72011cc58446/44069e0768a03136483fbe6cd5ac6832/aspnetcore-runtime-6.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26078483-7a4c-4113-8c39-eab5ee24f10f/3c2d24a5c71179af652cc92e8b57eb5f/aspnetcore-runtime-6.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e546f64b-b7f9-44f4-ab6e-ca66cbe6fd70/e96aec59c429914c850c22cdc96582f8/aspnetcore-runtime-6.0.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4c3fc11-b8c5-4e5f-91e7-ee47be5737ca/35f7c55f53d8bb2e8f950b00078f57e4/aspnetcore-runtime-6.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/98d90c10-c156-4fe5-93c3-109da0e7f55a/41953df9f595e9bcfbd5eba2ca4e433e/aspnetcore-runtime-6.0.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef70aabf-e945-4a82-8303-7675e84a183c/a1ef3d32b8572842684974747eee034b/aspnetcore-runtime-6.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9f160a60-8393-4d8a-a05d-5b2276bb9b17/8bde8c2366c2afb86d30716064153b9f/aspnetcore-runtime-6.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ad7d20a7-debf-4399-b59b-04419ae7adfe/73918e15d0bde4431546d8f659ed7381/aspnetcore-runtime-6.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8ea53d4b-faf7-4f3a-8c24-604be00078da/92e107f6c8928eb2fd3cec48fa59ce55/aspnetcore-runtime-6.0.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/e77fd80d-b12b-4d8c-9dc2-a22007f44cc8/ad05622589430ca580b7309513f139fe/dotnet-hosting-6.0.2-win.exe

[//]: # ( SDK 6.0.102)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2509d293-6a9f-4108-8fe1-10e78341c5df/18f693729320bdbb5e8d936460dd0e2b/dotnet-sdk-6.0.102-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93dd8d1e-f2af-45b1-8e86-9b8c3d58f4d2/b3fc3ef9da1db691043387fcb56f4d6f/dotnet-sdk-6.0.102-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43fcff14-e581-444b-a1a7-c37f3a3fc791/d7c2cede186c84320f69c81de66dcd99/dotnet-sdk-6.0.102-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb6336ef-498e-4338-beab-221630859aff/379e00a136ce163a9093c90c02ef1201/dotnet-sdk-6.0.102-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b2ba63e0-46ae-44e5-b68d-ae95ae605761/1b909af283b455ee1c4cd54d2704ddae/dotnet-sdk-6.0.102-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7acb87d-ab08-4620-9050-b3e80f688d36/e93bbadc19b12f81e3a6761719f28b47/dotnet-sdk-6.0.102-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cc2a94b1-7f3c-44f8-a842-f288a0cff04e/32446a93655522a1f933d4afb5e15836/dotnet-sdk-6.0.102-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ff10ff8-5986-4b45-a9e8-a32942f03d61/d9a5301523ad1134b7c175be1fca42b5/dotnet-sdk-6.0.102-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8509554d-61b4-43b8-b934-ad2e679ce18f/aa565a52b909b3133ef6763bb2868a49/dotnet-sdk-6.0.102-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17115de2-6099-4c24-9a66-d89d25f52968/9f55035d1a43a5d133c6a0bd35230d69/dotnet-sdk-6.0.102-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/05d08766-81a8-4561-8392-6ab88675c6e5/46a0f5a95be3fa7e5c4204503334cbe7/dotnet-sdk-6.0.102-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0217e9f0-f218-41ac-995c-300aaf05db26/9b9e2fa1f4bc4270c00aa1882c4b9605/dotnet-sdk-6.0.102-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fb14ba65-a9c9-49ce-9106-d0388b35ae1b/7bbfe92fb68e0c9330c9106b5c55869d/dotnet-sdk-6.0.102-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/302ca2e5-96d3-4792-a213-ab71d50577b0/9a9c160c69a3fdca8473e43c2510dbef/dotnet-sdk-6.0.102-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c1b52d02-1b8a-4a10-81de-65ccd6d7a226/fee3322b6047e170ed2505059cfd1815/dotnet-sdk-6.0.102-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/39e89851-1d41-4330-9bfd-2fa71bfed68b/2c4ae78e73779c925f9c0f9a13cb8fc8/dotnet-sdk-6.0.102-win-x86.zip
