# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity : IDisposable {
+        public ActivityStatusCode Status { get; }
+        public string StatusDescription { get; }
+        public static Func<ActivityTraceId> TraceIdGenerator { get; set; }
+        public object GetTagItem(string key);
+        public Activity SetBaggage(string key, string value);
+        public Activity SetStatus(ActivityStatusCode code, string description = null);
     }
     public sealed class ActivitySource : IDisposable {
+        public Activity CreateActivity(string name, ActivityKind kind);
+        public Activity CreateActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
+        public Activity CreateActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, ActivityIdFormat idFormat = ActivityIdFormat.Unknown);
+        public Activity StartActivity(ActivityKind kind, ActivityContext parentContext = default(ActivityContext), IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset), string name = "");
-        public Activity StartActivity(string name, ActivityKind kind = ActivityKind.Internal);
+        public Activity StartActivity(string name = "", ActivityKind kind = ActivityKind.Internal);
     }
+    public enum ActivityStatusCode {
+        Error = 2,
+        Ok = 1,
+        Unset = 0,
+    }
     public static class Debug {
+        public static void Assert(bool condition, ref Debug.AssertInterpolatedStringHandler message);
+        public static void Assert(bool condition, ref Debug.AssertInterpolatedStringHandler message, ref Debug.AssertInterpolatedStringHandler detailMessage);
+        public static void WriteIf(bool condition, ref Debug.WriteIfInterpolatedStringHandler message);
+        public static void WriteIf(bool condition, ref Debug.WriteIfInterpolatedStringHandler message, string category);
+        public static void WriteLineIf(bool condition, ref Debug.WriteIfInterpolatedStringHandler message);
+        public static void WriteLineIf(bool condition, ref Debug.WriteIfInterpolatedStringHandler message, string category);
+        public struct AssertInterpolatedStringHandler {
+            public AssertInterpolatedStringHandler(int literalLength, int formattedCount, bool condition, out bool shouldAppend);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
+        public struct WriteIfInterpolatedStringHandler {
+            public WriteIfInterpolatedStringHandler(int literalLength, int formattedCount, bool condition, out bool shouldAppend);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
     }
+    public abstract class DistributedContextPropagator {
+        protected DistributedContextPropagator();
+        public static DistributedContextPropagator Current { get; set; }
+        public abstract IReadOnlyCollection<string> Fields { get; }
+        public static DistributedContextPropagator CreateDefaultPropagator();
+        public static DistributedContextPropagator CreateNoOutputPropagator();
+        public static DistributedContextPropagator CreatePassThroughPropagator();
+        public abstract IEnumerable<KeyValuePair<string, string>> ExtractBaggage(object carrier, DistributedContextPropagator.PropagatorGetterCallback getter);
+        public abstract void ExtractTraceIdAndState(object carrier, DistributedContextPropagator.PropagatorGetterCallback getter, out string traceId, out string traceState);
+        public abstract void Inject(Activity activity, object carrier, DistributedContextPropagator.PropagatorSetterCallback setter);
+        public delegate void PropagatorGetterCallback(object carrier, string fieldName, out string fieldValue, out IEnumerable<string> fieldValues);
+        public delegate void PropagatorSetterCallback(object carrier, string fieldName, string fieldValue);
+    }
+    public sealed class StackTraceHiddenAttribute : Attribute {
+        public StackTraceHiddenAttribute();
+    }
+    public struct TagList : ICollection<KeyValuePair<string, object>>, IEnumerable, IEnumerable<KeyValuePair<string, object>>, IList<KeyValuePair<string, object>>, IReadOnlyCollection<KeyValuePair<string, object>>, IReadOnlyList<KeyValuePair<string, object>> {
+        public TagList(ReadOnlySpan<KeyValuePair<string, object>> tagList);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public KeyValuePair<string, object> this[int index] { get; set; }
+        public void Add(KeyValuePair<string, object> tag);
+        public void Add(string key, object value);
+        public void Clear();
+        public bool Contains(KeyValuePair<string, object> item);
+        public void CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        public void CopyTo(Span<KeyValuePair<string, object>> tags);
+        public IEnumerator<KeyValuePair<string, object>> GetEnumerator();
+        public int IndexOf(KeyValuePair<string, object> item);
+        public void Insert(int index, KeyValuePair<string, object> item);
+        public bool Remove(KeyValuePair<string, object> item);
+        public void RemoveAt(int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+            public KeyValuePair<string, object> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            public void Reset();
+        }
+    }
 }
```

