# System.IO.Pipes

``` diff
 namespace System.IO.Pipes {
+    public static class AnonymousPipeServerStreamAcl {
+        public static AnonymousPipeServerStream Create(PipeDirection direction, HandleInheritability inheritability, int bufferSize, PipeSecurity pipeSecurity);
+    }
+    public static class NamedPipeServerStreamAcl {
+        public static NamedPipeServerStream Create(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options, int inBufferSize, int outBufferSize, PipeSecurity pipeSecurity, HandleInheritability inheritability = HandleInheritability.None, PipeAccessRights additionalAccessRights = );
+    }
+    public enum PipeAccessRights {
+        AccessSystemSecurity = 16777216,
+        ChangePermissions = 262144,
+        CreateNewInstance = 4,
+        Delete = 65536,
+        FullControl = 2032031,
+        Read = 131209,
+        ReadAttributes = 128,
+        ReadData = 1,
+        ReadExtendedAttributes = 8,
+        ReadPermissions = 131072,
+        ReadWrite = 131483,
+        Synchronize = 1048576,
+        TakeOwnership = 524288,
+        Write = 274,
+        WriteAttributes = 256,
+        WriteData = 2,
+        WriteExtendedAttributes = 16,
+    }
+    public sealed class PipeAccessRule : AccessRule {
+        public PipeAccessRule(IdentityReference identity, PipeAccessRights rights, AccessControlType type);
+        public PipeAccessRule(string identity, PipeAccessRights rights, AccessControlType type);
+        public PipeAccessRights PipeAccessRights { get; }
+    }
+    public sealed class PipeAuditRule : AuditRule {
+        public PipeAuditRule(IdentityReference identity, PipeAccessRights rights, AuditFlags flags);
+        public PipeAuditRule(string identity, PipeAccessRights rights, AuditFlags flags);
+        public PipeAccessRights PipeAccessRights { get; }
+    }
+    public static class PipesAclExtensions {
+        public static PipeSecurity GetAccessControl(this PipeStream stream);
+        public static void SetAccessControl(this PipeStream stream, PipeSecurity pipeSecurity);
+    }
+    public class PipeSecurity : NativeObjectSecurity {
+        public PipeSecurity();
+        public override Type AccessRightType { get; }
+        public override Type AccessRuleType { get; }
+        public override Type AuditRuleType { get; }
+        public override AccessRule AccessRuleFactory(IdentityReference identityReference, int accessMask, bool isInherited, InheritanceFlags inheritanceFlags, PropagationFlags propagationFlags, AccessControlType type);
+        public void AddAccessRule(PipeAccessRule rule);
+        public void AddAuditRule(PipeAuditRule rule);
+        public sealed override AuditRule AuditRuleFactory(IdentityReference identityReference, int accessMask, bool isInherited, InheritanceFlags inheritanceFlags, PropagationFlags propagationFlags, AuditFlags flags);
+        protected internal void Persist(SafeHandle handle);
+        protected internal void Persist(string name);
+        public bool RemoveAccessRule(PipeAccessRule rule);
+        public void RemoveAccessRuleSpecific(PipeAccessRule rule);
+        public bool RemoveAuditRule(PipeAuditRule rule);
+        public void RemoveAuditRuleAll(PipeAuditRule rule);
+        public void RemoveAuditRuleSpecific(PipeAuditRule rule);
+        public void ResetAccessRule(PipeAccessRule rule);
+        public void SetAccessRule(PipeAccessRule rule);
+        public void SetAuditRule(PipeAuditRule rule);
+    }
 }
```

