# System.Security.Policy

``` diff
+namespace System.Security.Policy {
+    public sealed class Evidence : ICollection, IEnumerable {
+        public Evidence();
+        public Evidence(object[] hostEvidence, object[] assemblyEvidence);
+        public Evidence(Evidence evidence);
+        public Evidence(EvidenceBase[] hostEvidence, EvidenceBase[] assemblyEvidence);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public bool IsSynchronized { get; }
+        public bool Locked { get; set; }
+        public object SyncRoot { get; }
+        public void AddAssembly(object id);
+        public void AddAssemblyEvidence<T>(T evidence) where T : EvidenceBase;
+        public void AddHost(object id);
+        public void AddHostEvidence<T>(T evidence) where T : EvidenceBase;
+        public void Clear();
+        public Evidence Clone();
+        public void CopyTo(Array array, int index);
+        public IEnumerator GetAssemblyEnumerator();
+        public T GetAssemblyEvidence<T>() where T : EvidenceBase;
+        public IEnumerator GetEnumerator();
+        public IEnumerator GetHostEnumerator();
+        public T GetHostEvidence<T>() where T : EvidenceBase;
+        public void Merge(Evidence evidence);
+        public void RemoveType(Type t);
+    }
+    public abstract class EvidenceBase {
+        protected EvidenceBase();
+        public virtual EvidenceBase Clone();
+    }
+}
```

