# System

``` diff
 namespace System {
     public class ArgumentNullException : ArgumentException {
+        public static void ThrowIfNull(object argument, string paramName = null);
     }
     public abstract class Array : ICloneable, ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
+        public static int MaxLength { get; }
+        public static void Clear(Array array);
     }
     public abstract class Attribute {
-        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type attributeType);
-        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type attributeType, bool inherit);
     }
     public static class BitConverter {
+        public static ulong DoubleToUInt64Bits(double value);
+        public static byte[] GetBytes(Half value);
+        public static short HalfToInt16Bits(Half value);
+        public static ushort HalfToUInt16Bits(Half value);
+        public static Half Int16BitsToHalf(short value);
+        public static uint SingleToUInt32Bits(float value);
+        public static Half ToHalf(byte[] value, int startIndex);
+        public static Half ToHalf(ReadOnlySpan<byte> value);
+        public static bool TryWriteBytes(Span<byte> destination, Half value);
+        public static Half UInt16BitsToHalf(ushort value);
+        public static float UInt32BitsToSingle(uint value);
+        public static double UInt64BitsToDouble(ulong value);
     }
-    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable
+    public readonly struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable, ISpanFormattable
-    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
+    public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char>, IFormattable, ISpanFormattable {
+        public static bool IsAscii(Char c);
+        string System.IFormattable.ToString(string format, IFormatProvider formatProvider);
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, ISpanFormattable {
+        public DateOnly(int year, int month, int day);
+        public DateOnly(int year, int month, int day, Calendar calendar);
+        public int Day { get; }
+        public int DayNumber { get; }
+        public DayOfWeek DayOfWeek { get; }
+        public int DayOfYear { get; }
+        public static DateOnly MaxValue { get; }
+        public static DateOnly MinValue { get; }
+        public int Month { get; }
+        public int Year { get; }
+        public DateOnly AddDays(int value);
+        public DateOnly AddMonths(int value);
+        public DateOnly AddYears(int value);
+        public int CompareTo(DateOnly value);
+        public int CompareTo(object value);
+        public bool Equals(DateOnly value);
+        public override bool Equals(object value);
+        public static DateOnly FromDateTime(DateTime dateTime);
+        public static DateOnly FromDayNumber(int dayNumber);
+        public override int GetHashCode();
+        public static bool operator ==(DateOnly left, DateOnly right);
+        public static bool operator >(DateOnly left, DateOnly right);
+        public static bool operator >=(DateOnly left, DateOnly right);
+        public static bool operator !=(DateOnly left, DateOnly right);
+        public static bool operator <(DateOnly left, DateOnly right);
+        public static bool operator <=(DateOnly left, DateOnly right);
+        public static DateOnly Parse(ReadOnlySpan<char> s, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly Parse(string s);
+        public static DateOnly Parse(string s, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static DateOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, string format);
+        public static DateOnly ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static DateOnly ParseExact(string s, string[] formats);
+        public static DateOnly ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public DateTime ToDateTime(TimeOnly time);
+        public DateTime ToDateTime(TimeOnly time, DateTimeKind kind);
+        public string ToLongDateString();
+        public string ToShortDateString();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, out DateOnly result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParse(string s, out DateOnly result);
+        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, out DateOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(string s, string format, out DateOnly result);
+        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+        public static bool TryParseExact(string s, string[] formats, out DateOnly result);
+        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateOnly result);
+    }
-    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable
+    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable
+    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable
+    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable, ISpanFormattable
-    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable
+    public readonly struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable, ISpanFormattable
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+        public static object Parse(Type enumType, ReadOnlySpan<char> value);
+        public static object Parse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase);
+        public static TEnum Parse<TEnum>(ReadOnlySpan<char> value) where TEnum : struct;
+        public static TEnum Parse<TEnum>(ReadOnlySpan<char> value, bool ignoreCase) where TEnum : struct;
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, bool ignoreCase, out object result);
+        public static bool TryParse(Type enumType, ReadOnlySpan<char> value, out object result);
+        public static bool TryParse<TEnum>(ReadOnlySpan<char> value, bool ignoreCase, out TEnum result) where TEnum : struct;
+        public static bool TryParse<TEnum>(ReadOnlySpan<char> value, out TEnum result) where TEnum : struct;
     }
     public static class Environment {
+        public static string ProcessPath { get; }
     }
-    public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
+    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, ISpanFormattable {
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
-    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable
+    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable, ISpanFormattable
     public struct HashCode {
+        public void AddBytes(ReadOnlySpan<byte> value);
     }
-    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable
+    public readonly struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable, ISpanFormattable
-    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable
+    public readonly struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable, ISpanFormattable
-    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable
+    public readonly struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable, ISpanFormattable
-    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable {
+    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable, ISpanFormattable {
+        public static IntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out IntPtr result);
+        public static bool TryParse(ReadOnlySpan<char> s, out IntPtr result);
     }
+    public interface ISpanFormattable : IFormattable {
+        bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+    }
     public static class Math {
+        public static IntPtr Abs(IntPtr value);
+        public static IntPtr Clamp(IntPtr value, IntPtr min, IntPtr max);
+        public static UIntPtr Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        public static (byte Quotient, byte Remainder) DivRem(byte left, byte right);
+        public static (short Quotient, short Remainder) DivRem(short left, short right);
+        public static (int Quotient, int Remainder) DivRem(int left, int right);
+        public static (long Quotient, long Remainder) DivRem(long left, long right);
+        public static (IntPtr Quotient, IntPtr Remainder) DivRem(IntPtr left, IntPtr right);
+        public static (sbyte Quotient, sbyte Remainder) DivRem(sbyte left, sbyte right);
+        public static (ushort Quotient, ushort Remainder) DivRem(ushort left, ushort right);
+        public static (uint Quotient, uint Remainder) DivRem(uint left, uint right);
+        public static (ulong Quotient, ulong Remainder) DivRem(ulong left, ulong right);
+        public static (UIntPtr Quotient, UIntPtr Remainder) DivRem(UIntPtr left, UIntPtr right);
+        public static IntPtr Max(IntPtr val1, IntPtr val2);
+        public static UIntPtr Max(UIntPtr val1, UIntPtr val2);
+        public static IntPtr Min(IntPtr val1, IntPtr val2);
+        public static UIntPtr Min(UIntPtr val1, UIntPtr val2);
+        public static double ReciprocalEstimate(double d);
+        public static double ReciprocalSqrtEstimate(double d);
+        public static int Sign(IntPtr value);
+        public static (double Sin, double Cos) SinCos(double x);
     }
     public static class MathF {
+        public static float ReciprocalEstimate(float x);
+        public static float ReciprocalSqrtEstimate(float x);
+        public static (float Sin, float Cos) SinCos(float x);
     }
     public static class MemoryExtensions {
+        public static SpanLineEnumerator EnumerateLines(this ReadOnlySpan<char> span);
+        public static SpanLineEnumerator EnumerateLines(this Span<char> span);
+        public static bool SequenceEqual<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> other, IEqualityComparer<T> comparer = null);
+        public static bool SequenceEqual<T>(this Span<T> span, ReadOnlySpan<T> other, IEqualityComparer<T> comparer = null);
+        public static bool TryWrite(this Span<char> destination, IFormatProvider provider, ref MemoryExtensions.TryWriteInterpolatedStringHandler handler, out int charsWritten);
+        public static bool TryWrite(this Span<char> destination, ref MemoryExtensions.TryWriteInterpolatedStringHandler handler, out int charsWritten);
+        public ref struct TryWriteInterpolatedStringHandler {
+            public TryWriteInterpolatedStringHandler(int literalLength, int formattedCount, Span<char> destination, out bool shouldAppend);
+            public TryWriteInterpolatedStringHandler(int literalLength, int formattedCount, Span<char> destination, IFormatProvider provider, out bool shouldAppend);
+            public bool AppendFormatted(object value, int alignment = 0, string format = null);
+            public bool AppendFormatted(ReadOnlySpan<char> value);
+            public bool AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public bool AppendFormatted(string value);
+            public bool AppendFormatted(string value, int alignment = 0, string format = null);
+            public bool AppendFormatted<T>(T value);
+            public bool AppendFormatted<T>(T value, int alignment);
+            public bool AppendFormatted<T>(T value, int alignment, string format);
+            public bool AppendFormatted<T>(T value, string format);
+            public bool AppendLiteral(string value);
+        }
     }
     public sealed class OperatingSystem : ICloneable, ISerializable {
+        public static bool IsMacCatalyst();
+        public static bool IsMacCatalystVersionAtLeast(int major, int minor = 0, int build = 0);
     }
     public class Random {
+        public static Random Shared { get; }
+        public virtual long NextInt64();
+        public virtual long NextInt64(long maxValue);
+        public virtual long NextInt64(long minValue, long maxValue);
+        public virtual float NextSingle();
     }
-    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable
+    public readonly struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable, ISpanFormattable
-    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable
+    public readonly struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable, ISpanFormattable
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public void CopyTo(Span<char> destination);
+        public static String Create(IFormatProvider provider, ref DefaultInterpolatedStringHandler handler);
+        public static String Create(IFormatProvider provider, Span<char> initialBuffer, ref DefaultInterpolatedStringHandler handler);
+        public String ReplaceLineEndings();
+        public String ReplaceLineEndings(String replacementText);
+        public bool TryCopyTo(Span<char> destination);
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
+        public static bool IsWellKnownCultureAwareComparer(IEqualityComparer<string> comparer, out CompareInfo compareInfo, out CompareOptions compareOptions);
+        public static bool IsWellKnownOrdinalComparer(IEqualityComparer<string> comparer, out bool ignoreCase);
     }
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, ISpanFormattable {
+        public TimeOnly(int hour, int minute);
+        public TimeOnly(int hour, int minute, int second);
+        public TimeOnly(int hour, int minute, int second, int millisecond);
+        public TimeOnly(long ticks);
+        public int Hour { get; }
+        public static TimeOnly MaxValue { get; }
+        public int Millisecond { get; }
+        public int Minute { get; }
+        public static TimeOnly MinValue { get; }
+        public int Second { get; }
+        public long Ticks { get; }
+        public TimeOnly Add(TimeSpan value);
+        public TimeOnly Add(TimeSpan value, out int wrappedDays);
+        public TimeOnly AddHours(double value);
+        public TimeOnly AddHours(double value, out int wrappedDays);
+        public TimeOnly AddMinutes(double value);
+        public TimeOnly AddMinutes(double value, out int wrappedDays);
+        public int CompareTo(object value);
+        public int CompareTo(TimeOnly value);
+        public override bool Equals(object value);
+        public bool Equals(TimeOnly value);
+        public static TimeOnly FromDateTime(DateTime dateTime);
+        public static TimeOnly FromTimeSpan(TimeSpan timeSpan);
+        public override int GetHashCode();
+        public bool IsBetween(TimeOnly start, TimeOnly end);
+        public static bool operator ==(TimeOnly left, TimeOnly right);
+        public static bool operator >(TimeOnly left, TimeOnly right);
+        public static bool operator >=(TimeOnly left, TimeOnly right);
+        public static bool operator !=(TimeOnly left, TimeOnly right);
+        public static bool operator <(TimeOnly left, TimeOnly right);
+        public static bool operator <=(TimeOnly left, TimeOnly right);
+        public static TimeSpan operator -(TimeOnly t1, TimeOnly t2);
+        public static TimeOnly Parse(ReadOnlySpan<char> s, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly Parse(string s);
+        public static TimeOnly Parse(string s, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider = null, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats);
+        public static TimeOnly ParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, string format);
+        public static TimeOnly ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public static TimeOnly ParseExact(string s, string[] formats);
+        public static TimeOnly ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style = DateTimeStyles.None);
+        public string ToLongTimeString();
+        public string ToShortTimeString();
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public TimeSpan ToTimeSpan();
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParse(ReadOnlySpan<char> s, out TimeOnly result);
+        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParse(string s, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, ReadOnlySpan<char> format, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(ReadOnlySpan<char> s, string[] formats, out TimeOnly result);
+        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(string s, string format, out TimeOnly result);
+        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out TimeOnly result);
+        public static bool TryParseExact(string s, string[] formats, out TimeOnly result);
+    }
-    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable
+    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, ISpanFormattable
     public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo>, ISerializable {
+        public bool HasIanaId { get; }
+        public static bool TryConvertIanaIdToWindowsId(string ianaId, out string windowsId);
+        public static bool TryConvertWindowsIdToIanaId(string windowsId, out string ianaId);
+        public static bool TryConvertWindowsIdToIanaId(string windowsId, string region, out string ianaId);
         public sealed class AdjustmentRule : IDeserializationCallback, IEquatable<TimeZoneInfo.AdjustmentRule>, ISerializable {
+            public TimeSpan BaseUtcOffsetDelta { get; }
+            public static TimeZoneInfo.AdjustmentRule CreateAdjustmentRule(DateTime dateStart, DateTime dateEnd, TimeSpan daylightDelta, TimeZoneInfo.TransitionTime daylightTransitionStart, TimeZoneInfo.TransitionTime daylightTransitionEnd, TimeSpan baseUtcOffsetDelta);
         }
     }
     public abstract class Type : MemberInfo, IReflect {
+        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Type[] types);
+        public virtual MemberInfo GetMemberWithSameMetadataDefinitionAs(MemberInfo member);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Type[] types);
     }
-    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable
+    public readonly struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable, ISpanFormattable
-    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable
+    public readonly struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable, ISpanFormattable
-    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable
+    public readonly struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable, ISpanFormattable
-    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable {
+    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable, ISpanFormattable {
+        public static UIntPtr Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider provider = null);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out UIntPtr result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UIntPtr result);
     }
     public class Uri : ISerializable {
+        public static readonly string UriSchemeFtps;
+        public static readonly string UriSchemeSftp;
+        public static readonly string UriSchemeSsh;
+        public static readonly string UriSchemeTelnet;
+        public static readonly string UriSchemeWs;
+        public static readonly string UriSchemeWss;
+        public Uri(string uriString, in UriCreationOptions creationOptions);
+        public static bool TryCreate(string uriString, in UriCreationOptions creationOptions, out Uri result);
     }
+    public struct UriCreationOptions {
+        public bool DangerousDisablePathAndQueryCanonicalization { get; set; }
+    }
-    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version> {
+    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version>, IFormattable, ISpanFormattable {
+        string System.IFormattable.ToString(string format, IFormatProvider formatProvider);
+        bool System.ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
 }
```

