# Microsoft.AspNetCore.Components.Forms

``` diff
 namespace Microsoft.AspNetCore.Components.Forms {
     public static class BrowserFileExtensions {
-        public static ValueTask<IBrowserFile> RequestImageFileAsync(this IBrowserFile browserFile, string format, int maxWith, int maxHeight);
+        public static ValueTask<IBrowserFile> RequestImageFileAsync(this IBrowserFile browserFile, string format, int maxWidth, int maxHeight);
     }
-    public class DataAnnotationsValidator : ComponentBase {
+    public class DataAnnotationsValidator : ComponentBase, IDisposable {
+        protected virtual void Dispose(bool disposing);
+        protected override void OnParametersSet();
+        void System.IDisposable.Dispose();
     }
     public static class EditContextDataAnnotationsExtensions {
+        public static IDisposable EnableDataAnnotationsValidation(this EditContext editContext);
     }
     public class InputCheckbox : InputBase<bool> {
+        public ElementReference? Element { get; protected set; }
     }
     public class InputDate<TValue> : InputBase<TValue> {
+        public ElementReference? Element { get; protected set; }
+        public InputDateType Type { get; set; }
+        protected override void OnParametersSet();
     }
+    public enum InputDateType {
+        Date = 0,
+        DateTimeLocal = 1,
+        Month = 2,
+        Time = 3,
+    }
     public class InputFile : ComponentBase, IDisposable, IInputFileJsCallbacks {
+        public ElementReference? Element { get; protected set; }
     }
     public class InputNumber<TValue> : InputBase<TValue> {
+        public ElementReference? Element { get; protected set; }
     }
     public class InputSelect<TValue> : InputBase<TValue> {
+        public ElementReference? Element { get; protected set; }
+        protected override string FormatValueAsString(TValue value);
     }
     public class InputText : InputBase<string> {
+        public ElementReference? Element { get; protected set; }
     }
     public class InputTextArea : InputBase<string> {
+        public ElementReference? Element { get; protected set; }
     }
 }
```

