# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
     public abstract class Renderer : IAsyncDisposable, IDisposable {
+        public Type GetEventArgsType(ulong eventHandlerId);
+        protected internal void RemoveRootComponent(int componentId);
-        protected Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);
+        protected internal Task RenderRootComponentAsync(int componentId, ParameterView initialParameters);
     }
     public sealed class WebEventDescriptor {
-        public int BrowserRendererId { get; set; }

-        public string EventArgsType { get; set; }

+        public string EventName { get; set; }
     }
+    public abstract class WebRenderer : Renderer {
+        public WebRenderer(IServiceProvider serviceProvider, ILoggerFactory loggerFactory, JsonSerializerOptions jsonOptions, JSComponentInterop jsComponentInterop);
+        protected int RendererId { get; set; }
+        protected internal int AddRootComponent(Type componentType, string domElementSelector);
+        protected abstract void AttachRootComponentToBrowser(int componentId, string domElementSelector);
+        protected override void Dispose(bool disposing);
+    }
 }
```

