# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public static class BindConverter {
+        public static string FormatValue(DateOnly value, CultureInfo culture = null);
+        public static string FormatValue(DateOnly value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly value, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly value, string format, CultureInfo culture = null);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, out DateOnly value);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, string format, out DateOnly value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, out DateOnly? value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, string format, out DateOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, out TimeOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly? value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, out TimeOnly value);
     }
+    public sealed class CascadingTypeParameterAttribute : Attribute {
+        public CascadingTypeParameterAttribute(string name);
+        public string Name { get; }
+    }
+    public class DynamicComponent : IComponent {
+        public DynamicComponent();
+        public object Instance { get; }
+        public IDictionary<string, object> Parameters { get; set; }
+        public Type Type { get; set; }
+        public void Attach(RenderHandle renderHandle);
+        public Task SetParametersAsync(ParameterView parameters);
+    }
+    public sealed class EditorRequiredAttribute : Attribute {
+        public EditorRequiredAttribute();
+    }
     public static class ElementReferenceExtensions {
+        public static ValueTask FocusAsync(this ElementReference elementReference, bool preventScroll);
     }
+    public abstract class ErrorBoundaryBase : ComponentBase, IErrorBoundary {
+        protected ErrorBoundaryBase();
+        public RenderFragment ChildContent { get; set; }
+        protected Exception CurrentException { get; }
+        public RenderFragment<Exception> ErrorContent { get; set; }
+        public int MaximumErrorCount { get; set; }
+        protected abstract Task OnErrorAsync(Exception exception);
+        public void Recover();
+    }
     public static class EventCallbackFactoryBinderExtensions {
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly> setter, DateOnly existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly> setter, DateOnly existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly?> setter, DateOnly? existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly?> setter, DateOnly? existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly?> setter, TimeOnly? existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly?> setter, TimeOnly? existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly> setter, TimeOnly existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly> setter, TimeOnly existingValue, string format, CultureInfo culture = null);
     }
+    public interface IPersistentComponentStateStore {
+        Task<IDictionary<string, byte[]>> GetPersistedStateAsync();
+        Task PersistStateAsync(IReadOnlyDictionary<string, byte[]> state);
+    }
     public abstract class LayoutComponentBase : ComponentBase {
+        public override Task SetParametersAsync(ParameterView parameters);
     }
     public abstract class NavigationManager {
+        public void NavigateTo(string uri, NavigationOptions options);
-        public void NavigateTo(string uri, bool forceLoad = false);
+        public void NavigateTo(string uri, bool forceLoad);
+        public void NavigateTo(string uri, bool forceLoad = false, bool replace = false);
+        protected virtual void NavigateToCore(string uri, NavigationOptions options);
-        protected abstract void NavigateToCore(string uri, bool forceLoad);
+        protected virtual void NavigateToCore(string uri, bool forceLoad);
     }
+    public static class NavigationManagerExtensions {
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, bool value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateOnly value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateTime value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, decimal value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, double value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, Guid value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, int value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, long value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, bool? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateOnly? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateTime? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, decimal? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, double? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, Guid? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, int? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, long? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, float? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, TimeOnly? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, float value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, string value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, TimeOnly value);
+        public static string GetUriWithQueryParameters(this NavigationManager navigationManager, IReadOnlyDictionary<string, object> parameters);
+        public static string GetUriWithQueryParameters(this NavigationManager navigationManager, string uri, IReadOnlyDictionary<string, object> parameters);
+    }
+    public readonly struct NavigationOptions {
+        public bool ForceLoad { get; set; }
+        public bool ReplaceHistoryEntry { get; set; }
+    }
+    public class PersistentComponentState {
+        public void PersistAsJson<TValue>(string key, TValue instance);
+        public PersistingComponentStateSubscription RegisterOnPersisting(Func<Task> callback);
+        public bool TryTakeFromJson<TValue>(string key, out TValue instance);
+    }
+    public readonly struct PersistingComponentStateSubscription : IDisposable {
+        public void Dispose();
+    }
     public readonly struct RenderHandle {
+        public bool IsRenderingOnMetadataUpdate { get; }
     }
+    public sealed class SupplyParameterFromQueryAttribute : Attribute {
+        public SupplyParameterFromQueryAttribute();
+        public string Name { get; set; }
+    }
 }
```

