# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public abstract class ConnectionInfo {
+        public virtual void RequestClose();
     }
-    public class HttpContextFactory : IHttpContextFactory {
 {
-        public HttpContextFactory(IOptions<FormOptions> formOptions);

-        public HttpContextFactory(IOptions<FormOptions> formOptions, IHttpContextAccessor httpContextAccessor);

-        public HttpContextFactory(IOptions<FormOptions> formOptions, IServiceScopeFactory serviceScopeFactory);

-        public HttpContextFactory(IOptions<FormOptions> formOptions, IServiceScopeFactory serviceScopeFactory, IHttpContextAccessor httpContextAccessor);

-        public HttpContext Create(IFeatureCollection featureCollection);

-        public void Dispose(HttpContext httpContext);

-    }
     public static class HttpProtocol {
+        public static readonly string Http09;
+        public static bool IsHttp09(string protocol);
     }
+    public class HttpValidationProblemDetails : ProblemDetails {
+        public HttpValidationProblemDetails();
+        public HttpValidationProblemDetails(IDictionary<string, string[]> errors);
+        public IDictionary<string, string[]> Errors { get; }
+    }
     public interface IHeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>> {
+        StringValues Accept { get; set; }
+        StringValues AcceptCharset { get; set; }
+        StringValues AcceptEncoding { get; set; }
+        StringValues AcceptLanguage { get; set; }
+        StringValues AcceptRanges { get; set; }
+        StringValues AccessControlAllowCredentials { get; set; }
+        StringValues AccessControlAllowHeaders { get; set; }
+        StringValues AccessControlAllowMethods { get; set; }
+        StringValues AccessControlAllowOrigin { get; set; }
+        StringValues AccessControlExposeHeaders { get; set; }
+        StringValues AccessControlMaxAge { get; set; }
+        StringValues AccessControlRequestHeaders { get; set; }
+        StringValues AccessControlRequestMethod { get; set; }
+        StringValues Age { get; set; }
+        StringValues Allow { get; set; }
+        StringValues AltSvc { get; set; }
+        StringValues Authorization { get; set; }
+        StringValues Baggage { get; set; }
+        StringValues CacheControl { get; set; }
+        StringValues Connection { get; set; }
+        StringValues ContentDisposition { get; set; }
+        StringValues ContentEncoding { get; set; }
+        StringValues ContentLanguage { get; set; }
+        StringValues ContentLocation { get; set; }
+        StringValues ContentMD5 { get; set; }
+        StringValues ContentRange { get; set; }
+        StringValues ContentSecurityPolicy { get; set; }
+        StringValues ContentSecurityPolicyReportOnly { get; set; }
+        StringValues ContentType { get; set; }
+        StringValues Cookie { get; set; }
+        StringValues CorrelationContext { get; set; }
+        StringValues Date { get; set; }
+        StringValues ETag { get; set; }
+        StringValues Expect { get; set; }
+        StringValues Expires { get; set; }
+        StringValues From { get; set; }
+        StringValues GrpcAcceptEncoding { get; set; }
+        StringValues GrpcEncoding { get; set; }
+        StringValues GrpcMessage { get; set; }
+        StringValues GrpcStatus { get; set; }
+        StringValues GrpcTimeout { get; set; }
+        StringValues Host { get; set; }
+        StringValues IfMatch { get; set; }
+        StringValues IfModifiedSince { get; set; }
+        StringValues IfNoneMatch { get; set; }
+        StringValues IfRange { get; set; }
+        StringValues IfUnmodifiedSince { get; set; }
+        StringValues KeepAlive { get; set; }
+        StringValues LastModified { get; set; }
+        StringValues Link { get; set; }
+        StringValues Location { get; set; }
+        StringValues MaxForwards { get; set; }
+        StringValues Origin { get; set; }
+        StringValues Pragma { get; set; }
+        StringValues ProxyAuthenticate { get; set; }
+        StringValues ProxyAuthorization { get; set; }
+        StringValues ProxyConnection { get; set; }
+        StringValues Range { get; set; }
+        StringValues Referer { get; set; }
+        StringValues RequestId { get; set; }
+        StringValues RetryAfter { get; set; }
+        StringValues SecWebSocketAccept { get; set; }
+        StringValues SecWebSocketExtensions { get; set; }
+        StringValues SecWebSocketKey { get; set; }
+        StringValues SecWebSocketProtocol { get; set; }
+        StringValues SecWebSocketVersion { get; set; }
+        StringValues Server { get; set; }
+        StringValues SetCookie { get; set; }
+        StringValues StrictTransportSecurity { get; set; }
+        StringValues TE { get; set; }
+        StringValues TraceParent { get; set; }
+        StringValues TraceState { get; set; }
+        StringValues Trailer { get; set; }
+        StringValues TransferEncoding { get; set; }
+        StringValues Translate { get; set; }
+        StringValues Upgrade { get; set; }
+        StringValues UpgradeInsecureRequests { get; set; }
+        StringValues UserAgent { get; set; }
+        StringValues Vary { get; set; }
+        StringValues Via { get; set; }
+        StringValues Warning { get; set; }
+        StringValues WebSocketSubProtocols { get; set; }
+        StringValues WWWAuthenticate { get; set; }
+        StringValues XContentTypeOptions { get; set; }
+        StringValues XFrameOptions { get; set; }
+        StringValues XPoweredBy { get; set; }
+        StringValues XRequestedWith { get; set; }
+        StringValues XUACompatible { get; set; }
+        StringValues XXSSProtection { get; set; }
     }
     public interface IResponseCookies {
+        void Append(ReadOnlySpan<KeyValuePair<string, string>> keyValuePairs, CookieOptions options);
     }
+    public interface IResult {
+        Task ExecuteAsync(HttpContext httpContext);
+    }
+    public interface IResultExtensions
+    public static class OpenApiRouteHandlerBuilderExtensions {
+        public static RouteHandlerBuilder Accepts(this RouteHandlerBuilder builder, Type requestType, bool isOptional, string contentType, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder Accepts(this RouteHandlerBuilder builder, Type requestType, string contentType, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder Accepts<TRequest>(this RouteHandlerBuilder builder, bool isOptional, string contentType, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder Accepts<TRequest>(this RouteHandlerBuilder builder, string contentType, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder ExcludeFromDescription(this RouteHandlerBuilder builder);
+        public static RouteHandlerBuilder Produces(this RouteHandlerBuilder builder, int statusCode, Type responseType = null, string contentType = null, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder Produces<TResponse>(this RouteHandlerBuilder builder, int statusCode = 200, string contentType = null, params string[] additionalContentTypes);
+        public static RouteHandlerBuilder ProducesProblem(this RouteHandlerBuilder builder, int statusCode, string contentType = null);
+        public static RouteHandlerBuilder ProducesValidationProblem(this RouteHandlerBuilder builder, int statusCode = 400, string contentType = null);
+        public static RouteHandlerBuilder WithTags(this RouteHandlerBuilder builder, params string[] tags);
+    }
+    public static class RequestDelegateFactory {
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions options = null);
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object> targetFactory = null, RequestDelegateFactoryOptions options = null);
+    }
+    public sealed class RequestDelegateFactoryOptions {
+        public RequestDelegateFactoryOptions();
+        public bool DisableInferBodyFromParameters { get; set; }
+        public IEnumerable<string> RouteParameterNames { get; set; }
+        public IServiceProvider ServiceProvider { get; set; }
+        public bool ThrowOnBadRequest { get; set; }
+    }
+    public sealed class RequestDelegateResult {
+        public RequestDelegateResult(RequestDelegate requestDelegate, IReadOnlyList<object> metadata);
+        public IReadOnlyList<object> EndpointMetadata { get; }
+        public RequestDelegate RequestDelegate { get; }
+    }
+    public static class Results {
+        public static IResultExtensions Extensions { get; }
+        public static IResult Accepted(string uri = null, object value = null);
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult BadRequest(object error = null);
+        public static IResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Challenge(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult Conflict(object error = null);
+        public static IResult Content(string content, MediaTypeHeaderValue contentType);
+        public static IResult Content(string content, string contentType = null, Encoding contentEncoding = null);
+        public static IResult Created(string uri, object value);
+        public static IResult Created(Uri uri, object value);
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Forbid(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static IResult NoContent();
+        public static IResult NotFound(object value = null);
+        public static IResult Ok(object value = null);
+        public static IResult Problem(ProblemDetails problemDetails);
+        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object> extensions = null);
+        public static IResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        public static IResult SignIn(ClaimsPrincipal principal, AuthenticationProperties properties = null, string authenticationScheme = null);
+        public static IResult SignOut(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult StatusCode(int statusCode);
+        public static IResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Text(string content, string contentType = null, Encoding contentEncoding = null);
+        public static IResult Unauthorized();
+        public static IResult UnprocessableEntity(object error = null);
+        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null, IDictionary<string, object> extensions = null);
+    }
+    public sealed class TagsAttribute : Attribute, ITagsMetadata {
+        public TagsAttribute(params string[] tags);
+        public IReadOnlyList<string> Tags { get; }
+    }
     public class WebSocketAcceptContext {
+        public bool DangerousEnableCompression { get; set; }
+        public bool DisableServerContextTakeover { get; set; }
+        public virtual TimeSpan? KeepAliveInterval { get; set; }
+        public int ServerMaxWindowBits { get; set; }
     }
     public abstract class WebSocketManager {
+        public virtual Task<WebSocket> AcceptWebSocketAsync(WebSocketAcceptContext acceptContext);
     }
 }
```

