# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
+    public readonly struct AsyncServiceScope : IAsyncDisposable, IDisposable, IServiceScope {
+        public AsyncServiceScope(IServiceScope serviceScope);
+        public IServiceProvider ServiceProvider { get; }
+        public void Dispose();
+        public ValueTask DisposeAsync();
+    }
+    public static class EndpointMetadataApiExplorerServiceCollectionExtensions {
+        public static IServiceCollection AddEndpointsApiExplorer(this IServiceCollection services);
+    }
+    public static class HttpLoggingServicesExtensions {
+        public static IServiceCollection AddHttpLogging(this IServiceCollection services, Action<HttpLoggingOptions> configureOptions);
+        public static IServiceCollection AddW3CLogging(this IServiceCollection services, Action<W3CLoggerOptions> configureOptions);
+    }
+    public interface IServiceProviderIsService {
+        bool IsService(Type serviceType);
+    }
+    public static class OptionsBuilderExtensions {
+        public static OptionsBuilder<TOptions> ValidateOnStart<TOptions>(this OptionsBuilder<TOptions> optionsBuilder) where TOptions : class;
+    }
     public static class ServiceProviderServiceExtensions {
+        public static AsyncServiceScope CreateAsyncScope(this IServiceScopeFactory serviceScopeFactory);
+        public static AsyncServiceScope CreateAsyncScope(this IServiceProvider provider);
     }
 }
```

