# .NET 6.0.0 Preview 2 - March 11, 2021

The .NET 6.0.0 Preview 2 and .NET SDK 6.0.100-preview.2.21155.3 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 2

.NET 6 is the next major release of .NET following .NET 5.0. You can see some of the new features available with .NET 6 Preview 2 at [dotnet/core #5889](https://github.com/dotnet/core/issues/5889).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 2.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](6.0.0-preview.2-install-instructions.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.2.21155.3
```

### .NET Multi-Platform App UI Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET Multi-platform App UI](https://github.com/dotnet/maui). See [dotnet/net6-mobile-samples](https://github.com/dotnet/net6-mobile-samples) for additional setup instructions and sample projects you can run today.

|           | Android SDK Installer                        | iOS SDK Installer                 | Mac Catalyst SDK Installer                 |
| --------- | :------------------------------------------:     | :----------------------:                 | :----------------------:                 |
| Windows   | [x64][android-win] | [x64][ios-win]  | |
| macOS   | [x64][android-mac] | [x64][ios-mac]  | [x64][maccatalyst-mac]  |

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.9 Preview 4](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 9.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6057](https://github.com/dotnet/core/issues/6057) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-2/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-2
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-6-0-preview-2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: 6.0.0-preview.2-install-instructions.md


[//]: # ( Runtime 6.0.0-preview.2.21154.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b73c053-23f8-4d2f-9566-04bca14c6dcb/7aea2327f5a57e552c82443746a2693b/dotnet-runtime-6.0.0-preview.2.21154.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8015ee86-0721-4efc-86ea-f906898084d6/68bc54d347db3f4f9e016c8a32ba11ea/dotnet-runtime-6.0.0-preview.2.21154.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f90b01ae-16b8-4635-98e5-2c5fd37f2a5f/5cdd644c60eb2aba19e302c1e6c9b7aa/dotnet-runtime-6.0.0-preview.2.21154.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4e3f21d-1057-4610-aeaf-dfa219d424f8/2f6d98e193d3d08b50c5fbce3d4c4ad6/dotnet-runtime-6.0.0-preview.2.21154.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c88db43-4d92-433d-b95f-81bc9118a67e/08ec34f28dca0af4e8cf551299aa4367/dotnet-runtime-6.0.0-preview.2.21154.6-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3de6add5-a77c-4621-bf77-1722073ac0a7/4535dfffd67bbbf59b06c1b59c0b2f29/dotnet-runtime-6.0.0-preview.2.21154.6-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb98c2ee-cca5-4218-bfff-f7a809557e3e/4beba22c9a0c68729b5b26a1bb284323/dotnet-runtime-6.0.0-preview.2.21154.6-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/51cb50a7-c2e6-49f9-a172-e1dd0dd0f40f/d3cd57a2fc52ff8e85d8f52ba27f2e2f/dotnet-runtime-6.0.0-preview.2.21154.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/915ecb99-2324-4dcc-a69d-01c4cd52e119/32ade9437306585ea2656fd8bdaef5d4/dotnet-runtime-6.0.0-preview.2.21154.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3d6eb088-7e93-47e0-a60b-4126c2f52a35/ec3cee12fba7464c31043da34408a87e/dotnet-runtime-6.0.0-preview.2.21154.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/72e707fa-8bc1-424f-b588-8e2d75c29680/d0e128b706c27ec1a43803332beb74cc/dotnet-runtime-6.0.0-preview.2.21154.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8e797f52-3308-4b2a-befc-ff1f0c58f0d8/65f18aaea3a58537efbfdf98e1939d35/dotnet-runtime-6.0.0-preview.2.21154.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cebc9139-b042-46ec-b8bd-98b432536a00/d56de26bfdd627d5e6f2f88ae6c58c8a/dotnet-runtime-6.0.0-preview.2.21154.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5a094930-41b4-4f04-967f-9a3d33b8b6fa/af9b3d71c2ca497940d05765e55f07e1/dotnet-runtime-6.0.0-preview.2.21154.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e76ec995-5d51-4bd2-983f-ce1ad0f3605c/ea7fd63e7272ce7b482ec2e7ed9c6510/dotnet-runtime-6.0.0-preview.2.21154.6-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.2.21154.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3abda7f1-e93b-4aa5-ae35-9cfc09e1257a/f92e63d978f22d480adc74570112c074/windowsdesktop-runtime-6.0.0-preview.2.21154.2-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/487e7b8f-bd02-4403-8032-27ae2dad9e8e/f959e79463be4ccc69b24c5754ca980e/windowsdesktop-runtime-6.0.0-preview.2.21154.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/343d8b74-b7d8-439c-9d7e-42cb15313f62/c5e2a3d0d3fa0d12347fb445b9640b79/windowsdesktop-runtime-6.0.0-preview.2.21154.2-win-x86.exe

[//]: # ( ASP 6.0.0-preview.2.21154.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/471390d6-e308-41d7-8727-57ff3878bd28/306c3671d0129187e5f82d63058820d8/aspnetcore-runtime-6.0.0-preview.2.21154.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2439a067-d1e8-4f01-b0eb-fc36e2024eef/9ac2ce92d3465b6e0a4981014b098619/aspnetcore-runtime-6.0.0-preview.2.21154.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88056730-b112-4b37-b9c9-2a28274499d4/640e171ccdf76103ef284d83cdea95e8/aspnetcore-runtime-6.0.0-preview.2.21154.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d992937e-43f3-4f26-9c3c-39dd6e94c9e8/b8d49e845722a84e93178a383bf96e48/aspnetcore-runtime-6.0.0-preview.2.21154.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49e8a9d0-78a5-4045-8813-924e1bf99372/da066c42bf329b46359c1bfefdda462d/aspnetcore-runtime-6.0.0-preview.2.21154.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/36ae4114-cd59-4107-97e5-85b337c4969b/44dd3dcb76d158b1dbb39fdd51db3dd9/aspnetcore-runtime-6.0.0-preview.2.21154.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/caa6644e-34b6-49ba-8c2d-4a0767d0763c/185c1925693b6028cd54d7e1b3c3c018/aspnetcore-runtime-6.0.0-preview.2.21154.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3290547f-1fff-4f3d-a4ff-188ef8c09d1c/0b1734a65f4e839ac7c1ca48ea456791/aspnetcore-runtime-6.0.0-preview.2.21154.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/65c5f480-ee27-49fe-9402-c4bf16c5543b/8eb03f9c1530e079fd3475da0bcd5b88/aspnetcore-runtime-6.0.0-preview.2.21154.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4e958603-2934-4a0c-8867-060a09ce8d10/460f1ff233ba7511b74751d3df82111a/aspnetcore-runtime-6.0.0-preview.2.21154.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8a1e869b-4b6d-4127-97cb-d1d5a3814e94/aa7415b512d9ae37ecf88943f318eb60/aspnetcore-runtime-6.0.0-preview.2.21154.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d844044f-6a74-4ae7-950e-7a36296305fc/266a39da931e196d4fe2b2ba88f32ccd/aspnetcore-runtime-6.0.0-preview.2.21154.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8f7df454-eea2-4b8c-9194-910fb611679f/8fa8d8415b488668b2d2c6a68e1c63d5/dotnet-hosting-6.0.0-preview.2.21154.6-win.exe

[//]: # ( SDK w.2.21155 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c9dc65d-e004-4fe3-8327-4ba4c235095c/d16e99faf79b817b846f5734e94830de/dotnet-sdk-6.0.100-preview.2.21155.3-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d639275-6a89-45e9-a337-725c3ce49439/aa35a5e06539c6ffe1f81e74e45784e9/dotnet-sdk-6.0.100-preview.2.21155.3-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cdc62c8d-ccf3-4296-a6e1-88db75ad0805/33648a6a493ad507671d01776abbfd76/dotnet-sdk-6.0.100-preview.2.21155.3-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae5c17cb-7e03-4564-85cc-c53abc3827b6/30b8f35934437db6f4b5a9624faaf872/dotnet-sdk-6.0.100-preview.2.21155.3-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25c7e38e-0a6a-4d66-ac4e-b550a44b8a98/49128be84b903799259e7bebe8e9d969/dotnet-sdk-6.0.100-preview.2.21155.3-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e5cbc909-e705-4bc1-9327-15c9f905a149/6da57e95a58cef98444698fa72378e23/dotnet-sdk-6.0.100-preview.2.21155.3-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37b33b92-1f3e-4f72-a636-d82fd01bb725/792c44980047c5c77a8a07916db87783/dotnet-sdk-6.0.100-preview.2.21155.3-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5e10dc75-294e-49f4-972e-218ae86191a3/e46d3533c30c8a864252a334820263a9/dotnet-sdk-6.0.100-preview.2.21155.3-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da2b7ceb-4248-4d0b-ba7f-7f60c3e704b6/fa7a19c67639e0bff34cdd93e303d431/dotnet-sdk-6.0.100-preview.2.21155.3-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a8c2e17e-fdd4-4f7f-ad2b-a1a7d05b49c9/cc664a6b59e1f585a71bf9f19c4728ea/dotnet-sdk-6.0.100-preview.2.21155.3-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f54929fa-5fca-46ec-87b3-6e8338e0794a/1741b333fd0bc6771d628e2ab8317d61/dotnet-sdk-6.0.100-preview.2.21155.3-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2290b039-85d8-4d95-85f7-edbd9fcd118d/a64bef89625bc61db2a6832878610214/dotnet-sdk-6.0.100-preview.2.21155.3-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5b31ca8e-f684-4de7-9889-c53ce6cf9a3c/e85b1ef8dc6004c5f5bd0019771b21c5/dotnet-sdk-6.0.100-preview.2.21155.3-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/867f39f5-2b26-4eb0-8924-d55de52cd3f3/6cec1d027f099d69ba335ec309d87529/dotnet-sdk-6.0.100-preview.2.21155.3-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f0adbca-2b5e-435c-91f0-48873304ab7d/4bcbacd1506ac33b62c439cd5ebed32a/dotnet-sdk-6.0.100-preview.2.21155.3-win-x86.zip

[//]: # ( MAUI )
[ios-win]:  https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/Microsoft.NET.Workload.iOS.14.4.100-ci.main.1192.msi
[ios-mac]: https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/notarized/Microsoft.iOS.Bundle.14.4.100-ci.main.1192.pkg
[maccatalyst-mac]: https://bosstoragemirror.azureedge.net/wrench/main/98c8649d0c7d1e3c4c8d8d09e022befa853fb1e7/4541181/package/notarized/Microsoft.MacCatalyst.Bundle.14.3.100-ci.main.337.pkg
[android-win]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4534967/main/f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2/Microsoft.NET.Workload.Android.11.0.200.148.msi
[android-mac]: https://dl.internalx.com/vsts-devdiv/Xamarin.Android/public/net6/4534967/main/f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2/Microsoft.NET.Workload.Android-11.0.200-ci.f4d8fe238b15eadfc7842749bf13e5fca3e2f2d2.148.pkg

[//]: # ( Symbols )
