# .NET 6.0.0 Preview 7 - August 10, 2021

The .NET 6.0.0 Preview 7 and .NET SDK 6.0.100-preview.7.21379.14 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 Preview 7

.NET 6 is the next major release of .NET following .NET 5. You can see some of the new features available with .NET 6 Preview 7 at [dotnet/core #6444](https://github.com/dotnet/core/issues/6444).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 7. 

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-preview.7.21379.14
```

### .NET Multi-Platform App UI (MAUI) Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install microsoft-android-sdk-full
$ dotnet workload install microsoft-ios-sdk-full
$ dotnet workload install microsoft-maccatalyst-sdk-full
$ dotnet workload install microsoft-macos-sdk-full
$ dotnet workload install microsoft-tvos-sdk-full
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 2022 version 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. 


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6554](https://github.com/dotnet/core/issues/6554) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-preview.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-preview.7-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-preview-7/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-preview-7
[maui-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-maui-preview-7/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview7+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-preview7+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview7+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-preview7+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 6.0.0-preview.7.21377.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77e5acf3-f3df-450d-b848-73acdfd3fda5/580b861eabc20364fab611d2ed32318b/dotnet-runtime-6.0.0-preview.7.21377.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20ba65e6-c2df-4e33-8063-23e38802e580/3ead68d5d697c99b0b4a3f001ee8c21f/dotnet-runtime-6.0.0-preview.7.21377.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aff6eed7-ba7f-4e2e-ad49-fa95d1512aab/94ab7499dfea134a5d4c81da24162db1/dotnet-runtime-6.0.0-preview.7.21377.19-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34ef3cc6-b21c-4f80-a0ab-403ea43c9b2c/d65fc4e5547801b0d74c1698026ed101/dotnet-runtime-6.0.0-preview.7.21377.19-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8886b87d-4c03-4648-807f-63cf9ba5ffb2/3d88acc45536428ec4c57fcd7cdc269b/dotnet-runtime-6.0.0-preview.7.21377.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ae201ab-bd0b-471d-beab-2e33350be9da/358a49e4f1bdbaeaccedd7c139c55c45/dotnet-runtime-6.0.0-preview.7.21377.19-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/291e415b-c521-45b9-b817-710c342d2eb8/d05ca09bec35d4fbb31a07d700e9f416/dotnet-runtime-6.0.0-preview.7.21377.19-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/398a5746-b48d-4550-896b-445538b95458/aa025a02a656f69775efd346ccde38e9/dotnet-runtime-6.0.0-preview.7.21377.19-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f3f28827-7599-4d5e-a218-348e3988e27f/cbc1fe0c1d29f48f9b75591e95823d42/dotnet-runtime-6.0.0-preview.7.21377.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5943bf4-646f-49a3-8ef2-e2ec8eb25dd7/db3d9c2251a24e27d04c0f4d2828243c/dotnet-runtime-6.0.0-preview.7.21377.19-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/26a4b5f9-0491-4932-98a4-e51e0ce38fec/93418cd2b3e475c04e4ab427412e292d/dotnet-runtime-6.0.0-preview.7.21377.19-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c4e1d78a-23ce-4050-ac0c-03ce2dc6e64c/9f43a348c5cd3d60de14813483188de3/dotnet-runtime-6.0.0-preview.7.21377.19-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/87a80dee-7444-4c27-9590-fbe88d87bb36/3ce69dcc1dedd1f961a14c25df3c0e41/dotnet-runtime-6.0.0-preview.7.21377.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/49b581e8-cf2d-4cb4-83c5-5eb0f5d25729/2f0a34c9ca5f9ab73cfd264b1991c019/dotnet-runtime-6.0.0-preview.7.21377.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/56ee5a69-87ea-48a3-afb9-cc5f3df7c7f4/57cb23ae8a0de4f72118614307e9c3f2/dotnet-runtime-6.0.0-preview.7.21377.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/553f0b1b-36d2-446a-9e95-d730cec95443/f3c21cfcf61547b828958036b2de0ce5/dotnet-runtime-6.0.0-preview.7.21377.19-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-preview.7.21378.9)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9902ad9e-9909-4917-a028-f0892d38e522/3583908aae7a76dd0a9939910c899051/windowsdesktop-runtime-6.0.0-preview.7.21378.9-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fe844509-712f-4a5f-b2d6-f445d36199b2/26d1e19f0ae549a65598e8207920b4f3/windowsdesktop-runtime-6.0.0-preview.7.21378.9-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c0616dbd-ae8f-41d0-8ce4-5eeb2b987ff2/9f8ac0e92db2572ad954b22da86879a9/windowsdesktop-runtime-6.0.0-preview.7.21378.9-win-x86.exe

[//]: # ( ASP 6.0.0-preview.7.21378.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f9e4e9b-2561-4585-b7d6-090db274c5c2/86a95aedacb9351bbcea71cd559d2217/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0682a6bb-4fa1-498d-bfb1-e811587743cf/fa0e704d71b407e38cafe43bc146efaf/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7841c16b-835a-4243-8a3c-72d0a0c2b4f6/a5b37ca66b909b7ad0943769b853c803/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae1a1566-cd50-4833-9398-54cfe5d92b22/c3b84d339a7e4962e5a4a8f011f52081/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0da262b9-b8cc-434d-ac12-324d1eaff794/39d9da39b6dc52b4aa4e89cefe81005b/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/898bd961-c1fe-4e22-8692-d488ee838afd/315180a646a83063ceaae7a8ab9804cf/aspnetcore-runtime-6.0.0-preview.7.21378.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bcbe268e-e685-442c-a8d0-259c2ea6a09a/f815d1d4c58aaa654be87189ba2b6bca/aspnetcore-runtime-6.0.0-preview.7.21378.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/629234db-ff5f-4e82-a824-713936f04165/dc8ed7dac6fea4980e561ff8b89404be/aspnetcore-runtime-6.0.0-preview.7.21378.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7e5659b5-fe1c-426c-8b3f-64666d55e175/ca56dc910057e0893c041caa5f5530be/aspnetcore-runtime-6.0.0-preview.7.21378.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6970f61f-4282-4f56-bb9e-de2e50330183/2945e05fd51895bd48d75039ecf4004e/aspnetcore-runtime-6.0.0-preview.7.21378.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9a772ee7-45f6-43da-9ffb-741be2cb43c5/42ed070d0e80e569fb8f58c72beb94e2/aspnetcore-runtime-6.0.0-preview.7.21378.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/12d5cc40-8e4f-42f5-9179-2c40b5a0ebc7/daa966478a5e633fb7f004ab192fd9b2/aspnetcore-runtime-6.0.0-preview.7.21378.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f87f174f-9351-4962-8547-3f65f1cc56c6/b85a74694ad707014cbedd5ca418014e/aspnetcore-runtime-6.0.0-preview.7.21378.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/8d8e1b9b-bb55-475b-a83e-818a950c6bef/dccb7b079aaa0653519f32c1a6593d7f/dotnet-hosting-6.0.0-preview.7.21378.6-win.exe

[//]: # ( SDK 6.0.100-preview.7.21379.14)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/501903b0-5e47-4b76-a965-fabafcd95ff5/d6f197c99957b356ee8f0c6e2304ff09/dotnet-sdk-6.0.100-preview.7.21379.14-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/084d5037-7dee-4654-b91a-fe303fa62d74/553744c6fcf2ed1128e40fa9f6cd4516/dotnet-sdk-6.0.100-preview.7.21379.14-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f9ef409-03fd-4f5d-aeaf-872997b20ca4/ff72dbc6c7745003c37f2e35509711b4/dotnet-sdk-6.0.100-preview.7.21379.14-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/880fcf31-58f6-43c5-8ec4-6ce7496b3802/53fa60569cd9eee4916525e99767a3b0/dotnet-sdk-6.0.100-preview.7.21379.14-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb0cd830-ab5d-4a67-9c43-02e79423e2d1/c8b059f073cb676faf67dcdbe8101635/dotnet-sdk-6.0.100-preview.7.21379.14-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce3fd989-b69d-439a-9cac-09ad40597db8/2848d49480b6e7b1b2a18cfa46d724e2/dotnet-sdk-6.0.100-preview.7.21379.14-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a19468f5-793a-446a-81f5-a4d45830f531/6f217399f0ec499f4c76c5faa1ab3edb/dotnet-sdk-6.0.100-preview.7.21379.14-linux-x64.zip
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/01d92318-8db9-40f2-b9b8-20586d7e8f40/37d13083ff512e2b10bc2fd0fdbb9358/dotnet-sdk-6.0.100-preview.7.21379.14-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97e7dc57-24e3-4c5b-8c30-c9112c8e6f78/497423126e47e546f13cd06cc480b392/dotnet-sdk-6.0.100-preview.7.21379.14-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9e02abfd-b421-4c43-8541-482f037ed19c/f61bd4f35c444710016db8b5a7206a97/dotnet-sdk-6.0.100-preview.7.21379.14-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79fa35ba-fd6c-4ef2-b4b5-72064a442b0c/796467309b20640da189703101f7d0f5/dotnet-sdk-6.0.100-preview.7.21379.14-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2242858d-039d-4274-9196-bd6160db5cee/79daef596c45e73bb553a21335f8a1cf/dotnet-sdk-6.0.100-preview.7.21379.14-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/136011e8-7dd4-4729-b4b5-1c121ef71b17/df519750f0943fc0b079ba5f5798efa4/dotnet-sdk-6.0.100-preview.7.21379.14-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f8aa43e2-7a3b-437a-9b4c-704c2751db47/d431153e27a23b62f2002140eb6ecc00/dotnet-sdk-6.0.100-preview.7.21379.14-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c974c8da-7693-41c9-a874-712918a8964e/1d9223b00447537fef5f863cfa88cf80/dotnet-sdk-6.0.100-preview.7.21379.14-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/67126e71-b778-45ca-b01e-4b1409b63071/f62427f9c9dda820971d89bce3490f2e/dotnet-sdk-6.0.100-preview.7.21379.14-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3d4300c5-740a-4467-bd57-6291feed6930/bac27a00db49518ab79a31625bf6928b/dotnet-sdk-6.0.100-preview.7.21379.14-win-x86.zip
