# .NET 6.0.0 RC 1 - September 14, 2021

The .NET 6.0.0 RC 1 and .NET SDK 6.0.100-rc.1.21463.6 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## Update
During the hot reload compilation, tag helpers from references were not being resolved which resulted in component tags being treated as plain html. The fix for this issue has been made to the Razor Source Generator. As a result we have updated the .NET 6 RC1 SDK to 6.0.100-rc.1.21463.6.

## What's new in .NET 6 RC 1

.NET 6 is the next major release of .NET following .NET 5. You can see some of the new features available with .NET 6 RC 1 at [dotnet/core #6569](https://github.com/dotnet/core/issues/6569).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in RC 1. 

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-rc.1.21458.32
```
### .NET 6.0 RC1 Support and Servicing
 
.NET 6 RC1 is supported for use in production, which means you can build an app using .NET 6 RC1, deploy this app to a production environment, and expect the level of support and servicing you would normally get for a stable (non-preview) release such as .NET 5. We will continue to support RC1 for 30 days after RC2 ships and support RC2 for 30 days after .NET 6 GA ships.

You can contact the team directly at dotnet@microsoft.com if you run into challenges in your production environment.
 
.NET 6 RC1 will not be updated after it is released. You will need to update your environment to .NET 6 RC2 and .NET 6 GA for future improvements, including security updates.


### .NET Multi-Platform App UI (MAUI) Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install microsoft-android-sdk-full
$ dotnet workload install microsoft-ios-sdk-full
$ dotnet workload install microsoft-maccatalyst-sdk-full
$ dotnet workload install microsoft-macos-sdk-full
$ dotnet workload install microsoft-tvos-sdk-full
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples


## Visual Studio Compatibility

Visual Studio users must use [Visual Studio 2022](https://visualstudio.microsoft.com) and MSBuild 17 to use .NET 6.  Visual Studio 2019 and MSBuild 16 are not supported with .NET 6.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6688](https://github.com/dotnet/core/issues/6688) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-rc.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-rc.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-rc.1-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-rc1/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-rc-1
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-rc1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-rc1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-rc1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-rc1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 6.0.0-rc.1.21451.13)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a48f1cb-e22c-4e80-8f29-3f7e5bd48dcb/e747a6268462ab0bc999210d99f8cb16/dotnet-runtime-6.0.0-rc.1.21451.13-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fccf0b2b-847f-4d10-922c-d10e48188bb7/0e3e03d3573f4e07337d9f7469e5fb3a/dotnet-runtime-6.0.0-rc.1.21451.13-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cdbbb1b6-9e9a-4bf8-8e31-709b6892422d/a8ff88abfdd6055ab21c497ee0ba5645/dotnet-runtime-6.0.0-rc.1.21451.13-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e210ff92-a285-46d6-84c3-b65cbfd98d1b/581915718d78dd1c4d049e191e5fa917/dotnet-runtime-6.0.0-rc.1.21451.13-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43f0420f-eace-4bac-845d-7ba41344c45e/d3e66c06444609aff096add39b2f5148/dotnet-runtime-6.0.0-rc.1.21451.13-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/24c9c4a7-03a8-42ed-9b83-1fcc7dd85e16/eb36df3559cc7ee3500c4b38f9949fa9/dotnet-runtime-6.0.0-rc.1.21451.13-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/882caec9-4114-41d9-8f50-18d09591ac72/a8f682edb8f7db4624df9e435628e761/dotnet-runtime-6.0.0-rc.1.21451.13-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee2f49da-82d5-4aa0-8ca5-b4f69e5c2632/80dda33cc2beef778af12c150e66e118/dotnet-runtime-6.0.0-rc.1.21451.13-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a8608d51-2363-4352-9102-f76d360deeea/d1c289e36f88b8eaa2e1464ae11d25c9/dotnet-runtime-6.0.0-rc.1.21451.13-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/662c0cee-18f8-42da-b476-7111bda7cf9a/89a2b71cd00c12ec6158541e0dabfdcd/dotnet-runtime-6.0.0-rc.1.21451.13-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f9c758f-c41e-457d-b549-ba796d759b36/1295dbb5f9480b92805803ef6db82b8d/dotnet-runtime-6.0.0-rc.1.21451.13-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/efddc729-e811-484e-b94c-0b834dfe5cdb/59e9fff8ae904b12aa6db5a6fa7b801b/dotnet-runtime-6.0.0-rc.1.21451.13-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/76fe5506-77bb-4d63-bdf0-ca7df0e53602/25d6641885253ec8427345438728d324/dotnet-runtime-6.0.0-rc.1.21451.13-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/49e82f9b-976e-4930-965e-fa04dedef039/bf732bbeb65dbc4f8db9c456da98b7fb/dotnet-runtime-6.0.0-rc.1.21451.13-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/78a2bfc7-837e-4bee-ad69-09a49f9c8dbe/56e0884d46ed8009b4d13ea94b6750a6/dotnet-runtime-6.0.0-rc.1.21451.13-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4686929-8c0a-46d1-bf40-6454d5e0825d/9c377b25edbe8afcd8a78b0b9f6baa3c/dotnet-runtime-6.0.0-rc.1.21451.13-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-rc.1.21451.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/417f9150-053b-4091-8513-b16dd67815af/32c0251c6add0e92b259dd34fa4bf199/windowsdesktop-runtime-6.0.0-rc.1.21451.3-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d680e227-d8e3-4e14-ad37-8e3256b7a94b/5c77d6166d48cac837dd0625c1b9518d/windowsdesktop-runtime-6.0.0-rc.1.21451.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c2fc2d0-82bf-48ce-94cb-bcf0d7ccbc70/2f957898b09f3dd784bdb504b543b0c8/windowsdesktop-runtime-6.0.0-rc.1.21451.3-win-x86.exe

[//]: # ( ASP 6.0.0-rc.1.21452.15)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/00b59131-805d-4b49-8871-642613806e37/eec5b92bab33c0bb12d526c70d5a94ec/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/038f4d5d-8e6e-47ef-8fe7-522ff8dc5c42/d34d25c006ac6b13f8edf5fa5899ccd9/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/062c9a0a-2afb-4baa-be96-865482b340db/d806b8fa25b796952d7adaee6444f9ed/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5edd04eb-062e-4669-8bff-5949431c5c87/3866a55a973852c1b92c853aa2540df9/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/223a5980-5610-47eb-a983-059110f9826c/ab708db6cdd837af5cd685493bdbea0c/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c88d8dbc-bcd2-4400-b0ef-03e362c49068/c0048366f3c44d2b49a59acc28f79647/aspnetcore-runtime-6.0.0-rc.1.21452.15-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23d484eb-a685-495c-92a7-72903cf2d690/6d13b4f78811a50a62853269e371aa51/aspnetcore-runtime-6.0.0-rc.1.21452.15-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa322eb2-04fc-455a-9a18-416502c25e9b/1eaecb29e7b05fcb70ccc0aae964f2af/aspnetcore-runtime-6.0.0-rc.1.21452.15-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/843da093-3f3e-42a1-95d4-e1a37e5b93d0/5dfebb0aaa073f2a10dbecde2b529e83/aspnetcore-runtime-6.0.0-rc.1.21452.15-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c08c9070-7538-4792-9a55-6cce32bff933/52bc9bfc52f38f7723191f00d3e85143/aspnetcore-runtime-6.0.0-rc.1.21452.15-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c2d29ac-07a7-4c79-bf1e-ca5185d9906e/f756deb9df37e23740ce6c416408e9c1/aspnetcore-runtime-6.0.0-rc.1.21452.15-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/418ac220-fd7a-4b76-bcb8-2ed514dfa002/0599b94b48bf971567f599b70e9aeafb/aspnetcore-runtime-6.0.0-rc.1.21452.15-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8ba3d9ea-1258-4421-91e1-8774e53a3d3b/58600398adbf68a9cf630958fba026fe/aspnetcore-runtime-6.0.0-rc.1.21452.15-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/aef4eaa9-2214-4e24-bd87-af7c4643ac4d/00fad9e518498beb5807f9064a0a2433/dotnet-hosting-6.0.0-rc.1.21452.15-win.exe

[//]: # ( SDK 6.0.100-rc.1.21463.6)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a31e2042-c0fb-47e1-a1a6-9e925bf33182/1479d388ef3ece7e1048a9423486b821/dotnet-sdk-6.0.100-rc.1.21463.6-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c56c49ce-176e-4472-bd0c-5667475790f2/018c2de72f984826afe4b1b87715f1c0/dotnet-sdk-6.0.100-rc.1.21463.6-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88014120-b5e4-4cc4-986e-8e9290ad59e7/0e778995d305ebe7cea9ebf303edcdfb/dotnet-sdk-6.0.100-rc.1.21463.6-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a137fa2c-57c8-465d-855a-9039e50adbfe/077f89f3eb22f23b19158bb7eb698aed/dotnet-sdk-6.0.100-rc.1.21463.6-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ddb6b148-6882-46dd-9885-a803b460a66d/7e773236a05890fd2799045b96a85526/dotnet-sdk-6.0.100-rc.1.21463.6-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fcb98bb-21e1-47a5-bb8e-bb25f41a3e52/04811d5d05b7e694f040d2a13c1aae4c/dotnet-sdk-6.0.100-rc.1.21463.6-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/80b891ce-2814-4368-b255-04513b5a3743/f08abf896b03124744c32a2e86749a75/dotnet-sdk-6.0.100-rc.1.21463.6-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a869ee27-5a92-4aba-8b23-8424743c6e0f/dd515a1c3a86349727b8543148a3d607/dotnet-sdk-6.0.100-rc.1.21463.6-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4ca60318-1905-4b5a-90ad-060bc5357857/a129beb791b78a034e5e6453273dcd84/dotnet-sdk-6.0.100-rc.1.21463.6-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ee10a55-7afe-4036-abfa-1d1821ccfd87/395cd9032a535f8b55c4dbce088a8189/dotnet-sdk-6.0.100-rc.1.21463.6-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/73e35032-5d20-408d-aae6-ea5a78b789c0/01842a950be338c03e282fce537906d4/dotnet-sdk-6.0.100-rc.1.21463.6-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/da7bac83-8479-49b3-b0ae-60847f051879/e6bd3f58e3c5a9e017bd1329bdc03e3c/dotnet-sdk-6.0.100-rc.1.21463.6-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d214c16c-4485-441b-b4e8-50867f370ff9/159f2e1223b494b909ce2288fc2bc6c5/dotnet-sdk-6.0.100-rc.1.21463.6-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c50149b6-4e1f-4278-869a-742aa2c7cfe5/bc936112cb6f6215b456c6c1e77d8826/dotnet-sdk-6.0.100-rc.1.21463.6-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0cc5e1ae-c744-4a5e-a950-28bd3149da86/8f2db99d1aa77594928356fde7467586/dotnet-sdk-6.0.100-rc.1.21463.6-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/408d9e77-ed5b-47c0-a2ae-5d7e76e174a3/321fedf9069aa8b0794913b1aa2e7f94/dotnet-sdk-6.0.100-rc.1.21463.6-win-x86.zip
