# .NET 6.0.0 RC 2 - October 12, 2021

The .NET 6.0.0 RC 2 and .NET SDK 6.0.100-rc.2.21505.57 releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

## What's new in .NET 6 RC 2

.NET 6 is the next major release of .NET following .NET 5. You can see some of the new features available with .NET 6 RC 2 at [dotnet/core #6570](https://github.com/dotnet/core/issues/6570).

See the [.NET][dotnet-blog], [ASP.NET Core][aspnet-blog] and [.NET MAUI][maui-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in RC 2. 

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-Arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [Arm64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz]  \| [Arm64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [Arm64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [Arm64][dotnet-runtime-osx-arm64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [Arm64][aspnetcore-runtime-osx-arm64.tar.gz]  | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md) | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz] \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup>  \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.100-rc.2.21505.57
```
### .NET 6.0 RC2 Support and Servicing
 
.NET 6 RC2 is supported for use in production, which means you can build an app using .NET 6 RC2, deploy this app to a production environment, and expect the level of support and servicing you would normally get for a stable (non-preview) release such as .NET 5. We will continue to support RC2 for 30 days after .NET 6 GA ships.

You can contact the team directly at dotnet@microsoft.com if you run into challenges in your production environment.
 
.NET 6 RC2 will not be updated after it is released. You will need to update your environment to .NET 6 GA for future improvements, including security updates.


### .NET Multi-Platform App UI (MAUI) Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.


## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples


## Visual Studio Compatibility

You need [Visual Studio 2022 version 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. 


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6795](https://github.com/dotnet/core/issues/6795) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/preview/6.0.0-rc.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-rc.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.0-rc.2-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-net-6-release-candidate-2/
[aspnet-blog]:  https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-6-rc-2
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-rc2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A6.0.0-rc2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-rc2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A6.0.0-rc2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A6.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A6.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A6.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 6.0.0-rc.2.21480.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75a148a1-507f-4326-91e1-b562a0990635/ad935a37d84122c960a2f7536b2040d6/dotnet-runtime-6.0.0-rc.2.21480.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31052246-e923-4d07-ab90-1085aae662fc/b9b557f933b22b4f1a6dbed4f139aad9/dotnet-runtime-6.0.0-rc.2.21480.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f8cb367-c5aa-4842-ad92-2e497a91c973/44709bce119348112dd29000f00679dd/dotnet-runtime-6.0.0-rc.2.21480.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c09f3bf-a327-4f6c-b035-0699a0e46671/dc774eaddb613c5498bb90fe7f0d26e2/dotnet-runtime-6.0.0-rc.2.21480.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97b42e79-a640-46d6-a674-aeb6c1145ea2/20487a02e9d60df7a6479b122874a724/dotnet-runtime-6.0.0-rc.2.21480.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c18f20e-854f-4883-af1f-5b72c0839758/708c2cc48696ed4d4fe0568944228101/dotnet-runtime-6.0.0-rc.2.21480.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2ac2aeec-4262-41e1-9544-8fc21579952c/8bfe416a0ce0b43b354481cacaa57f35/dotnet-runtime-6.0.0-rc.2.21480.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4554bca6-38e0-440e-9f7d-86e03246624d/7b86fb61e08cd1830b73f01475e4fa02/dotnet-runtime-6.0.0-rc.2.21480.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/39fb50be-17b9-45b2-9f3e-eb03e31b8219/3f67fc8d06a1d163ac817cd116fd4719/dotnet-runtime-6.0.0-rc.2.21480.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83a16229-2ada-42e3-8661-b0ef9c693ed9/a1a5df9af178df25061f79d252365755/dotnet-runtime-6.0.0-rc.2.21480.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/8e7f12ea-5510-483e-b554-42bb30c64491/a37040abd96e05a58564c4b2160250fb/dotnet-runtime-6.0.0-rc.2.21480.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b72fa07b-6151-4829-9a37-6d5bb40e29c3/dce60a0340da1372590e6cc81ce919e9/dotnet-runtime-6.0.0-rc.2.21480.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4ff12e63-5c77-440d-b338-6ef6bd29998b/3fa16424a3b462781921fda8b8c4693e/dotnet-runtime-6.0.0-rc.2.21480.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/457d6654-6d7d-40c4-8094-4b6e9d41eb5c/0f73560c3a7fc8e16920d3fbfd720b67/dotnet-runtime-6.0.0-rc.2.21480.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5d12cc9a-faa8-4765-9f27-770cf015a3e4/52183872e3415e9e3d50958ed56f08fe/dotnet-runtime-6.0.0-rc.2.21480.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b1d7475f-fa66-4125-a667-3133cfade23f/ead5f6c7874f00ffcecf2b0bace6d1ff/dotnet-runtime-6.0.0-rc.2.21480.5-win-x86.zip

[//]: # ( WindowsDesktop 6.0.0-rc.2.21501.6)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/24d0cdfe-c2a1-4f8e-b22f-05dcb3e82eae/aa1c44d9a66a098cbe087efa11a57bb1/windowsdesktop-runtime-6.0.0-rc.2.21501.6-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ae678751-3c1a-4f8b-a37b-e2e327af191e/3383ed7040b9f0184ff36c93ab129659/windowsdesktop-runtime-6.0.0-rc.2.21501.6-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c58ffd6-cdfc-4cae-a163-247bb22c4e24/93601cca92711d2d03fdb7f7dab88bc2/windowsdesktop-runtime-6.0.0-rc.2.21501.6-win-x86.exe

[//]: # ( ASP 6.0.0-rc.2.21480.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/647129b7-ec5a-43a0-be8d-a5c72c05839b/d365e15419aef47fb63a9f7ef671634c/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09772ed2-2c44-4b18-bae1-3b6c5067ddd1/10aac7ee29b60c45b672c5fd7067ffa8/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4dc9cd6-34a0-423b-b8ca-c00a3dcfd5e4/58b1a3be9ad1f6cbf97b36402623e4fa/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c81a9e1-9317-4df6-b252-dcd894ecbe0f/b21611bbf676149ebadcfe118a61eea9/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68926ebe-0d0f-4640-a875-64cd07cd38ab/445073d3c36b8a1e6bd48f5b1028ae6c/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a38f03ab-cab1-4dc9-9632-ac8f3ce4541a/af681d66907ead1d52c7187e50bccf0f/aspnetcore-runtime-6.0.0-rc.2.21480.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95d06c98-4d67-4936-be3a-8a23e778afa3/2909216332838572c8e2b819ef1defc7/aspnetcore-runtime-6.0.0-rc.2.21480.10-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b6452d1-ac6b-43bf-9cd3-4d15c2058b6f/3bf52f1b54969072d36d7e4f0fe41520/aspnetcore-runtime-6.0.0-rc.2.21480.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e7bd7895-4180-4a31-b5c3-ab70818b4590/2a8318f79ab077b940557ac725109817/aspnetcore-runtime-6.0.0-rc.2.21480.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e70876a6-776a-4e2c-a81c-22c372c982d2/d9751bfe3d236ab2ae04eb26f216b085/aspnetcore-runtime-6.0.0-rc.2.21480.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2ede1a24-864e-4d74-bb11-46d36db7a1ec/4e7962d64336275fa3677cdafa788cec/aspnetcore-runtime-6.0.0-rc.2.21480.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e91991b0-2890-44eb-975b-88640458865b/030f37099df8b9fe6779002992e928d6/aspnetcore-runtime-6.0.0-rc.2.21480.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/29ae2241-2a93-4c09-b4d4-e4965d2506d9/ace8eb599bedf0e6d6993cb9ae87fea7/aspnetcore-runtime-6.0.0-rc.2.21480.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/96ff4231-c2fc-438f-8ceb-e08cb3a06cf0/8f0ee2420be78c3c87bb32cc990fe7ad/dotnet-hosting-6.0.0-rc.2.21480.10-win.exe

[//]: # ( SDK 6.0.100-rc.2.21505.57)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fdc5aa4-bfcf-43fc-ae61-968f65d78f36/aac677054f246740f4d761d6e519da08/dotnet-sdk-6.0.100-rc.2.21505.57-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e7a9f1f-6128-4581-9d72-edfe196320d3/ad3b26879ddaca8b76e16ddddd091d5d/dotnet-sdk-6.0.100-rc.2.21505.57-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6e130999-27bb-4eba-83f1-f353f97ff3e5/8e55992b4491d4ac4f395dfd6f779dfa/dotnet-sdk-6.0.100-rc.2.21505.57-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6a13d4d-9102-4fc9-896d-1ecf080669e4/ba5be57e008f0862ca239bdb98286543/dotnet-sdk-6.0.100-rc.2.21505.57-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f2fb894-af90-49a7-bee0-8959844e78e9/c24eba454d3820721bc51dca99c8976c/dotnet-sdk-6.0.100-rc.2.21505.57-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20283373-1d83-4879-8278-0afb7fd4035e/56f204f174743b29a656499ad0fc93c3/dotnet-sdk-6.0.100-rc.2.21505.57-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3336b6fe-1f40-4c66-a1ef-81cabd3df46c/dd56dc201e5c0a95b86f41c1cf36df17/dotnet-sdk-6.0.100-rc.2.21505.57-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad5e2408-9804-4a47-83a2-a23c11dc5400/8dae5a982d6ed29d53781bc8a6c147cc/dotnet-sdk-6.0.100-rc.2.21505.57-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c5dd0b51-0059-442b-9456-b03cb7ee277d/6d78d81224db93247ff6ae0bdb929712/dotnet-sdk-6.0.100-rc.2.21505.57-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35655ed6-3e37-4fa3-8990-5c1827469ce5/f9f920ff05b0aa5961a8b30e2824de7d/dotnet-sdk-6.0.100-rc.2.21505.57-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fea7d77a-8ed3-4304-951e-08a4c3229981/3da26e2a51725378ec8dad621d2f433e/dotnet-sdk-6.0.100-rc.2.21505.57-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cf04062d-d660-4db0-9286-64d58172f0ff/2515f1f22d8ce7559cd9069959b415da/dotnet-sdk-6.0.100-rc.2.21505.57-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5bc3c525-d6d5-4370-8468-e44a1b948c03/fe758c9942966b88b52d92ce2823f6c0/dotnet-sdk-6.0.100-rc.2.21505.57-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/abbdf8c4-cf89-4d7c-972e-398aad2b56ac/b4c6204cc2c7e667e3fe72b6be090252/dotnet-sdk-6.0.100-rc.2.21505.57-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3ed039eb-0a53-4b0e-89a9-d76b5db07016/cbad4e20634ede6b8b575dceb3d1de90/dotnet-sdk-6.0.100-rc.2.21505.57-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9ee1045b-30f0-40d2-83c9-72e594cabb1e/e8e7dd0d4f9937f06254dab87719040c/dotnet-sdk-6.0.100-rc.2.21505.57-win-x86.zip
