# System.Net.Quic

``` diff
+namespace System.Net.Quic {
+    public class QuicClientConnectionOptions {
+        public QuicClientConnectionOptions();
+        public SslClientAuthenticationOptions ClientAuthenticationOptions { get; set; }
+        public TimeSpan IdleTimeout { get; set; }
+        public IPEndPoint LocalEndPoint { get; set; }
+        public long MaxBidirectionalStreams { get; set; }
+        public long MaxUnidirectionalStreams { get; set; }
+        public EndPoint RemoteEndPoint { get; set; }
+    }
+    public sealed class QuicConnection : IDisposable {
+        public QuicConnection(EndPoint remoteEndPoint, SslClientAuthenticationOptions sslClientAuthenticationOptions, IPEndPoint localEndPoint = null);
+        public QuicConnection(QuicImplementationProvider implementationProvider, EndPoint remoteEndPoint, SslClientAuthenticationOptions sslClientAuthenticationOptions, IPEndPoint localEndPoint = null);
+        public QuicConnection(QuicImplementationProvider implementationProvider, QuicClientConnectionOptions options);
+        public QuicConnection(QuicClientConnectionOptions options);
+        public bool Connected { get; }
+        public IPEndPoint LocalEndPoint { get; }
+        public SslApplicationProtocol NegotiatedApplicationProtocol { get; }
+        public EndPoint RemoteEndPoint { get; }
+        public ValueTask<QuicStream> AcceptStreamAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask CloseAsync(long errorCode, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask ConnectAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public void Dispose();
+        public long GetRemoteAvailableBidirectionalStreamCount();
+        public long GetRemoteAvailableUnidirectionalStreamCount();
+        public QuicStream OpenBidirectionalStream();
+        public QuicStream OpenUnidirectionalStream();
+    }
+    public class QuicConnectionAbortedException : QuicException {
+        public QuicConnectionAbortedException(string message, long errorCode);
+        public long ErrorCode { get; }
+    }
+    public class QuicException : Exception {
+        public QuicException(string message);
+        public QuicException(string message, Exception innerException);
+    }
+    public static class QuicImplementationProviders {
+        public static QuicImplementationProvider Default { get; }
+        public static QuicImplementationProvider Mock { get; }
+        public static QuicImplementationProvider MsQuic { get; }
+    }
+    public sealed class QuicListener : IDisposable {
+        public QuicListener(IPEndPoint listenEndPoint, SslServerAuthenticationOptions sslServerAuthenticationOptions);
+        public QuicListener(QuicImplementationProvider implementationProvider, IPEndPoint listenEndPoint, SslServerAuthenticationOptions sslServerAuthenticationOptions);
+        public QuicListener(QuicImplementationProvider implementationProvider, QuicListenerOptions options);
+        public QuicListener(QuicListenerOptions options);
+        public IPEndPoint ListenEndPoint { get; }
+        public ValueTask<QuicConnection> AcceptConnectionAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public void Close();
+        public void Dispose();
+        public void Start();
+    }
+    public class QuicListenerOptions {
+        public QuicListenerOptions();
+        public string CertificateFilePath { get; set; }
+        public TimeSpan IdleTimeout { get; set; }
+        public int ListenBacklog { get; set; }
+        public IPEndPoint ListenEndPoint { get; set; }
+        public long MaxBidirectionalStreams { get; set; }
+        public long MaxUnidirectionalStreams { get; set; }
+        public string PrivateKeyFilePath { get; set; }
+        public SslServerAuthenticationOptions ServerAuthenticationOptions { get; set; }
+    }
+    public class QuicOperationAbortedException : QuicException {
+        public QuicOperationAbortedException(string message);
+    }
+    public sealed class QuicStream : Stream {
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanWrite { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public long StreamId { get; }
+        public void AbortRead(long errorCode);
+        public void AbortWrite(long errorCode);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
+        public override void Flush();
+        public override Task FlushAsync(CancellationToken cancellationToken);
+        public override int Read(byte[] buffer, int offset, int count);
+        public override int Read(Span<byte> buffer);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public void Shutdown();
+        public ValueTask ShutdownWriteCompleted(CancellationToken cancellationToken = default(CancellationToken));
+        public override void Write(byte[] buffer, int offset, int count);
+        public override void Write(ReadOnlySpan<byte> buffer);
+        public ValueTask WriteAsync(ReadOnlySequence<byte> buffers, bool endStream, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask WriteAsync(ReadOnlySequence<byte> buffers, CancellationToken cancellationToken = default(CancellationToken));
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
+        public ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, bool endStream, CancellationToken cancellationToken = default(CancellationToken));
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask WriteAsync(ReadOnlyMemory<ReadOnlyMemory<byte>> buffers, bool endStream, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask WriteAsync(ReadOnlyMemory<ReadOnlyMemory<byte>> buffers, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public class QuicStreamAbortedException : QuicException {
+        public QuicStreamAbortedException(string message, long errorCode);
+        public long ErrorCode { get; }
+    }
+}
```

