# System

``` diff
 namespace System {
     public abstract class Attribute {
-        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type attributeType);
-        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type, bool inherit);
+        public static Attribute[] GetCustomAttributes(MemberInfo element, Type attributeType, bool inherit);
     }
     public static class BitConverter {
+        public static byte[] GetBytes(Half value);
+        public static short HalfToInt16Bits(Half value);
+        public static Half Int16BitsToHalf(short value);
+        public static Half ToHalf(byte[] value, int startIndex);
+        public static Half ToHalf(ReadOnlySpan<byte> value);
+        public static bool TryWriteBytes(Span<byte> destination, Half value);
     }
     public readonly struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
+        public static bool IsAscii(Char c);
     }
     public static class Environment {
+        public static string ProcessPath { get; }
     }
-    public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable
+    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable
     public static class Math {
+        public static IntPtr Abs(IntPtr value);
+        public static IntPtr Clamp(IntPtr value, IntPtr min, IntPtr max);
+        public static UIntPtr Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        public static (byte Quotient, byte Remainder) DivRem(byte left, byte right);
+        public static (short Quotient, short Remainder) DivRem(short left, short right);
+        public static (int Quotient, int Remainder) DivRem(int left, int right);
+        public static (long Quotient, long Remainder) DivRem(long left, long right);
+        public static (IntPtr Quotient, IntPtr Remainder) DivRem(IntPtr left, IntPtr right);
+        public static (sbyte Quotient, sbyte Remainder) DivRem(sbyte left, sbyte right);
+        public static (ushort Quotient, ushort Remainder) DivRem(ushort left, ushort right);
+        public static (uint Quotient, uint Remainder) DivRem(uint left, uint right);
+        public static (ulong Quotient, ulong Remainder) DivRem(ulong left, ulong right);
+        public static (UIntPtr Quotient, UIntPtr Remainder) DivRem(UIntPtr left, UIntPtr right);
+        public static IntPtr Max(IntPtr val1, IntPtr val2);
+        public static UIntPtr Max(UIntPtr val1, UIntPtr val2);
+        public static IntPtr Min(IntPtr val1, IntPtr val2);
+        public static UIntPtr Min(UIntPtr val1, UIntPtr val2);
+        public static double ReciprocalEstimate(double d);
+        public static double ReciprocalSqrtEstimate(double d);
+        public static int Sign(IntPtr value);
+        public static (double Sin, double Cos) SinCos(double x);
     }
     public static class MathF {
+        public static float ReciprocalEstimate(float x);
+        public static float ReciprocalSqrtEstimate(float x);
+        public static (float Sin, float Cos) SinCos(float x);
     }
     public class Random {
+        public virtual long NextInt64();
+        public virtual long NextInt64(long maxValue);
+        public virtual long NextInt64(long minValue, long maxValue);
+        public virtual float NextSingle();
     }
     public abstract class Type : MemberInfo, IReflect {
+        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Type[] types);
+        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Type[] types);
     }
     public class Uri : ISerializable {
+        public static readonly string UriSchemeFtps;
+        public static readonly string UriSchemeSftp;
+        public static readonly string UriSchemeSsh;
+        public static readonly string UriSchemeTelnet;
+        public static readonly string UriSchemeWs;
+        public static readonly string UriSchemeWss;
     }
 }
```

