# Microsoft.AspNetCore.Components.Lifetime

``` diff
+namespace Microsoft.AspNetCore.Components.Lifetime {
+    public class ComponentApplicationLifetime {
+        public ComponentApplicationLifetime(ILogger<ComponentApplicationLifetime> logger);
+        public ComponentApplicationState State { get; }
+        public Task PersistStateAsync(IComponentApplicationStateStore store, Renderer renderer);
+        public Task RestoreStateAsync(IComponentApplicationStateStore store);
+    }
+    public interface IComponentApplicationStateStore {
+        Task<IDictionary<string, byte[]>> GetPersistedStateAsync();
+        Task PersistStateAsync(IReadOnlyDictionary<string, byte[]> state);
+    }
+}
```

