# System.Net.WebSockets

``` diff
 namespace System.Net.WebSockets {
     public sealed class ClientWebSocketOptions {
+        public WebSocketDeflateOptions DangerousDeflateOptions { get; set; }
     }
     public abstract class WebSocket : IDisposable {
+        public static WebSocket CreateFromStream(Stream stream, WebSocketCreationOptions options);
+        public virtual ValueTask SendAsync(ReadOnlyMemory<byte> buffer, WebSocketMessageType messageType, WebSocketMessageFlags messageFlags, CancellationToken cancellationToken);
     }
+    public sealed class WebSocketCreationOptions {
+        public WebSocketCreationOptions();
+        public WebSocketDeflateOptions DangerousDeflateOptions { get; set; }
+        public bool IsServer { get; set; }
+        public TimeSpan KeepAliveInterval { get; set; }
+        public string SubProtocol { get; set; }
+    }
+    public sealed class WebSocketDeflateOptions {
+        public WebSocketDeflateOptions();
+        public bool ClientContextTakeover { get; set; }
+        public int ClientMaxWindowBits { get; set; }
+        public bool ServerContextTakeover { get; set; }
+        public int ServerMaxWindowBits { get; set; }
+    }
+    public enum WebSocketMessageFlags {
+        DisableCompression = 2,
+        EndOfMessage = 1,
+        None = 0,
+    }
 }
```

