# System.Text.Json.Nodes

``` diff
+namespace System.Text.Json.Nodes {
+    public sealed class JsonArray : JsonNode, ICollection<JsonNode>, IEnumerable, IEnumerable<JsonNode>, IList<JsonNode> {
+        public JsonArray(JsonNodeOptions? options = default(JsonNodeOptions?));
+        public JsonArray(JsonNodeOptions options, params JsonNode[] items);
+        public JsonArray(params JsonNode[] items);
+        public int Count { get; }
+        bool System.Collections.Generic.ICollection<System.Text.Json.Nodes.JsonNode>.IsReadOnly { get; }
+        public void Add(JsonNode item);
+        public void Add<T>(T value);
+        public void Clear();
+        public bool Contains(JsonNode item);
+        public static JsonArray Create(JsonElement element, JsonNodeOptions? options = default(JsonNodeOptions?));
+        public IEnumerator<JsonNode> GetEnumerator();
+        public int IndexOf(JsonNode item);
+        public void Insert(int index, JsonNode item);
+        public bool Remove(JsonNode item);
+        public void RemoveAt(int index);
+        void System.Collections.Generic.ICollection<System.Text.Json.Nodes.JsonNode>.CopyTo(JsonNode[] array, int index);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override void WriteTo(Utf8JsonWriter writer, JsonSerializerOptions options = null);
+    }
+    public abstract class JsonNode : IDynamicMetaObjectProvider {
+        public JsonNodeOptions? Options { get; }
+        public JsonNode Parent { get; }
+        public JsonNode Root { get; }
+        public JsonNode this[int index] { get; set; }
+        public JsonNode this[string propertyName] { get; set; }
+        public JsonArray AsArray();
+        public JsonObject AsObject();
+        public JsonValue AsValue();
+        public string GetPath();
+        public virtual TValue GetValue<TValue>();
+        public static explicit operator bool (JsonNode value);
+        public static explicit operator byte (JsonNode value);
+        public static explicit operator char (JsonNode value);
+        public static explicit operator DateTime (JsonNode value);
+        public static explicit operator DateTimeOffset (JsonNode value);
+        public static explicit operator decimal (JsonNode value);
+        public static explicit operator double (JsonNode value);
+        public static explicit operator Guid (JsonNode value);
+        public static explicit operator short (JsonNode value);
+        public static explicit operator int (JsonNode value);
+        public static explicit operator long (JsonNode value);
+        public static explicit operator bool? (JsonNode value);
+        public static explicit operator byte? (JsonNode value);
+        public static explicit operator char? (JsonNode value);
+        public static explicit operator DateTimeOffset? (JsonNode value);
+        public static explicit operator DateTime? (JsonNode value);
+        public static explicit operator decimal? (JsonNode value);
+        public static explicit operator double? (JsonNode value);
+        public static explicit operator Guid? (JsonNode value);
+        public static explicit operator short? (JsonNode value);
+        public static explicit operator int? (JsonNode value);
+        public static explicit operator long? (JsonNode value);
+        public static explicit operator sbyte? (JsonNode value);
+        public static explicit operator float? (JsonNode value);
+        public static explicit operator ushort? (JsonNode value);
+        public static explicit operator uint? (JsonNode value);
+        public static explicit operator ulong? (JsonNode value);
+        public static explicit operator sbyte (JsonNode value);
+        public static explicit operator float (JsonNode value);
+        public static explicit operator string (JsonNode value);
+        public static explicit operator ushort (JsonNode value);
+        public static explicit operator uint (JsonNode value);
+        public static explicit operator ulong (JsonNode value);
+        public static implicit operator JsonNode (bool value);
+        public static implicit operator JsonNode (byte value);
+        public static implicit operator JsonNode (char value);
+        public static implicit operator JsonNode (DateTime value);
+        public static implicit operator JsonNode (DateTimeOffset value);
+        public static implicit operator JsonNode (decimal value);
+        public static implicit operator JsonNode (double value);
+        public static implicit operator JsonNode (Guid value);
+        public static implicit operator JsonNode (short value);
+        public static implicit operator JsonNode (int value);
+        public static implicit operator JsonNode (long value);
+        public static implicit operator JsonNode (bool? value);
+        public static implicit operator JsonNode (byte? value);
+        public static implicit operator JsonNode (char? value);
+        public static implicit operator JsonNode (DateTime? value);
+        public static implicit operator JsonNode (DateTimeOffset? value);
+        public static implicit operator JsonNode (decimal? value);
+        public static implicit operator JsonNode (double? value);
+        public static implicit operator JsonNode (Guid? value);
+        public static implicit operator JsonNode (short? value);
+        public static implicit operator JsonNode (int? value);
+        public static implicit operator JsonNode (long? value);
+        public static implicit operator JsonNode (sbyte? value);
+        public static implicit operator JsonNode (float? value);
+        public static implicit operator JsonNode (ushort? value);
+        public static implicit operator JsonNode (uint? value);
+        public static implicit operator JsonNode (ulong? value);
+        public static implicit operator JsonNode (sbyte value);
+        public static implicit operator JsonNode (float value);
+        public static implicit operator JsonNode (string value);
+        public static implicit operator JsonNode (ushort value);
+        public static implicit operator JsonNode (uint value);
+        public static implicit operator JsonNode (ulong value);
+        public static JsonNode Parse(Stream utf8Json, JsonNodeOptions? nodeOptions = default(JsonNodeOptions?), JsonDocumentOptions documentOptions = default(JsonDocumentOptions));
+        public static JsonNode Parse(ReadOnlySpan<byte> utf8Json, JsonNodeOptions? nodeOptions = default(JsonNodeOptions?), JsonDocumentOptions documentOptions = default(JsonDocumentOptions));
+        public static JsonNode Parse(string json, JsonNodeOptions? nodeOptions = default(JsonNodeOptions?), JsonDocumentOptions documentOptions = default(JsonDocumentOptions));
+        public static JsonNode Parse(ref Utf8JsonReader reader, JsonNodeOptions? nodeOptions = default(JsonNodeOptions?));
+        DynamicMetaObject System.Dynamic.IDynamicMetaObjectProvider.GetMetaObject(Expression parameter);
+        public string ToJsonString(JsonSerializerOptions options = null);
+        public override string ToString();
+        public abstract void WriteTo(Utf8JsonWriter writer, JsonSerializerOptions options = null);
+    }
+    public struct JsonNodeOptions {
+        public bool PropertyNameCaseInsensitive { get; set; }
+    }
+    public sealed class JsonObject : JsonNode, ICollection<KeyValuePair<string, JsonNode>>, IDictionary<string, JsonNode>, IEnumerable, IEnumerable<KeyValuePair<string, JsonNode>> {
+        public JsonObject(IEnumerable<KeyValuePair<string, JsonNode>> properties, JsonNodeOptions? options = default(JsonNodeOptions?));
+        public JsonObject(JsonNodeOptions? options = default(JsonNodeOptions?));
+        public int Count { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Text.Json.Nodes.JsonNode>>.IsReadOnly { get; }
+        ICollection<string> System.Collections.Generic.IDictionary<System.String,System.Text.Json.Nodes.JsonNode>.Keys { get; }
+        ICollection<JsonNode> System.Collections.Generic.IDictionary<System.String,System.Text.Json.Nodes.JsonNode>.Values { get; }
+        public void Add(KeyValuePair<string, JsonNode> property);
+        public void Add(string propertyName, JsonNode value);
+        public void Clear();
+        public bool ContainsKey(string propertyName);
+        public static JsonObject Create(JsonElement element, JsonNodeOptions? options = default(JsonNodeOptions?));
+        public IEnumerator<KeyValuePair<string, JsonNode>> GetEnumerator();
+        public bool Remove(string propertyName);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Text.Json.Nodes.JsonNode>>.Contains(KeyValuePair<string, JsonNode> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Text.Json.Nodes.JsonNode>>.CopyTo(KeyValuePair<string, JsonNode>[] array, int index);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Text.Json.Nodes.JsonNode>>.Remove(KeyValuePair<string, JsonNode> item);
+        bool System.Collections.Generic.IDictionary<System.String,System.Text.Json.Nodes.JsonNode>.TryGetValue(string propertyName, out JsonNode jsonNode);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetPropertyValue(string propertyName, out JsonNode jsonNode);
+        public override void WriteTo(Utf8JsonWriter writer, JsonSerializerOptions options = null);
+    }
+    public abstract class JsonValue : JsonNode {
+        public static JsonValue Create<T>(T value, JsonNodeOptions? options = default(JsonNodeOptions?));
+        public abstract bool TryGetValue<T>(out T value);
+    }
+}
```

