# System.IO

``` diff
 namespace System.IO {
     public static class Directory {
+        public static FileSystemInfo CreateSymbolicLink(string path, string pathToTarget);
+        public static FileSystemInfo ResolveLinkTarget(string linkPath, bool returnFinalTarget);
     }
     public static class File {
+        public static FileSystemInfo CreateSymbolicLink(string path, string pathToTarget);
+        public static FileSystemInfo ResolveLinkTarget(string linkPath, bool returnFinalTarget);
     }
     public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        public string LinkTarget { get; }
+        public void CreateAsSymbolicLink(string pathToTarget);
+        public FileSystemInfo ResolveLinkTarget(bool returnFinalTarget);
     }
     public static class RandomAccess {
-        public static long Write(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset);
+        public static void Write(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset);
-        public static int Write(SafeFileHandle handle, ReadOnlySpan<byte> buffer, long fileOffset);
+        public static void Write(SafeFileHandle handle, ReadOnlySpan<byte> buffer, long fileOffset);
-        public static ValueTask<long> WriteAsync(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask WriteAsync(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
-        public static ValueTask<int> WriteAsync(SafeFileHandle handle, ReadOnlyMemory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask WriteAsync(SafeFileHandle handle, ReadOnlyMemory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

