# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public static class CollectionsMarshal {
+        public static ref TValue GetValueRefOrAddDefault<TKey, TValue>(Dictionary<TKey, TValue> dictionary, TKey key, out bool exists);
     }
+    public static class NativeMemory {
+        public unsafe static void* AlignedAlloc(UIntPtr byteCount, UIntPtr alignment);
+        public unsafe static void AlignedFree(void* ptr);
+        public unsafe static void* AlignedRealloc(void* ptr, UIntPtr byteCount, UIntPtr alignment);
+        public unsafe static void* Alloc(UIntPtr byteCount);
+        public unsafe static void* Alloc(UIntPtr elementCount, UIntPtr elementSize);
+        public unsafe static void* AllocZeroed(UIntPtr byteCount);
+        public unsafe static void* AllocZeroed(UIntPtr elementCount, UIntPtr elementSize);
+        public unsafe static void Free(void* ptr);
+        public unsafe static void* Realloc(void* ptr, UIntPtr byteCount);
+    }
+    public enum PosixSignal {
+        SIGCHLD = -5,
+        SIGCONT = -6,
+        SIGHUP = -1,
+        SIGINT = -2,
+        SIGQUIT = -3,
+        SIGTERM = -4,
+        SIGTSTP = -10,
+        SIGTTIN = -8,
+        SIGTTOU = -9,
+        SIGWINCH = -7,
+    }
+    public sealed class PosixSignalContext {
+        public PosixSignalContext(PosixSignal signal);
+        public bool Cancel { get; set; }
+        public PosixSignal Signal { get; }
+    }
+    public sealed class PosixSignalRegistration : IDisposable {
+        public static PosixSignalRegistration Create(PosixSignal signal, Action<PosixSignalContext> handler);
+        public void Dispose();
+        ~PosixSignalRegistration();
+    }
 }
```

