# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public interface IJsonOnDeserialized {
+        void OnDeserialized();
+    }
+    public interface IJsonOnDeserializing {
+        void OnDeserializing();
+    }
+    public interface IJsonOnSerialized {
+        void OnSerialized();
+    }
+    public interface IJsonOnSerializing {
+        void OnSerializing();
+    }
     public enum JsonKnownNamingPolicy {
-        BuiltInCamelCase = 1,

+        CamelCase = 1,
     }
+    public sealed class JsonPropertyOrderAttribute : JsonAttribute {
+        public JsonPropertyOrderAttribute(int order);
+        public int Order { get; }
+    }
-    public class JsonSerializerOptionsAttribute : JsonAttribute {
 {
-        public JsonSerializerOptionsAttribute();

-        public JsonIgnoreCondition DefaultIgnoreCondition { get; set; }

-        public bool IgnoreReadOnlyFields { get; set; }

-        public bool IgnoreReadOnlyProperties { get; set; }

-        public bool IgnoreRuntimeCustomConverters { get; set; }

-        public bool IncludeFields { get; set; }

-        public JsonKnownNamingPolicy NamingPolicy { get; set; }

-        public bool WriteIndented { get; set; }

-    }
     public enum JsonSourceGenerationMode {
+        Default = 0,
-        MetadataAndSerialization = 0,

     }
+    public class JsonSourceGenerationOptionsAttribute : JsonAttribute {
+        public JsonSourceGenerationOptionsAttribute();
+        public JsonIgnoreCondition DefaultIgnoreCondition { get; set; }
+        public JsonSourceGenerationMode GenerationMode { get; set; }
+        public bool IgnoreReadOnlyFields { get; set; }
+        public bool IgnoreReadOnlyProperties { get; set; }
+        public bool IgnoreRuntimeCustomConverters { get; set; }
+        public bool IncludeFields { get; set; }
+        public JsonKnownNamingPolicy PropertyNamingPolicy { get; set; }
+        public bool WriteIndented { get; set; }
+    }
-    public sealed class JsonStringEnumConverter : JsonConverterFactory {
+    public class JsonStringEnumConverter : JsonConverterFactory {
-        public override bool CanConvert(Type typeToConvert);
+        public sealed override bool CanConvert(Type typeToConvert);
-        public override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+        public sealed override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
     }
 }
```

