# System.Text

``` diff
 namespace System.Text {
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder Append(ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder Append(IFormatProvider provider, ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder AppendLine(ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public StringBuilder AppendLine(IFormatProvider provider, ref StringBuilder.AppendInterpolatedStringHandler handler);
+        public struct AppendInterpolatedStringHandler {
+            public AppendInterpolatedStringHandler(int literalLength, int formattedCount, StringBuilder stringBuilder);
+            public AppendInterpolatedStringHandler(int literalLength, int formattedCount, StringBuilder stringBuilder, IFormatProvider provider);
+            public void AppendFormatted(object value, int alignment = 0, string format = null);
+            public void AppendFormatted(ReadOnlySpan<char> value);
+            public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+            public void AppendFormatted(string value);
+            public void AppendFormatted(string value, int alignment = 0, string format = null);
+            public void AppendFormatted<T>(T value);
+            public void AppendFormatted<T>(T value, int alignment);
+            public void AppendFormatted<T>(T value, int alignment, string format);
+            public void AppendFormatted<T>(T value, string format);
+            public void AppendLiteral(string value);
+        }
     }
 }
```

