# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public static class RequestDelegateFactory {
+        public static RequestDelegate Create(Delegate action, RequestDelegateFactoryOptions options = null);
-        public static RequestDelegate Create(Delegate action, IServiceProvider serviceProvider);

+        public static RequestDelegate Create(MethodInfo methodInfo, Func<HttpContext, object> targetFactory = null, RequestDelegateFactoryOptions options = null);
-        public static RequestDelegate Create(MethodInfo methodInfo, IServiceProvider serviceProvider);

-        public static RequestDelegate Create(MethodInfo methodInfo, IServiceProvider serviceProvider, Func<HttpContext, object> targetFactory);

     }
+    public sealed class RequestDelegateFactoryOptions {
+        public RequestDelegateFactoryOptions();
+        public IEnumerable<string> RouteParameterNames { get; set; }
+        public IServiceProvider ServiceProvider { get; set; }
+    }
+    public static class Results {
+        public static IResult Accepted(string uri = null, object value = null);
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult BadRequest(object error = null);
+        public static IResult Bytes(byte[] contents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult Challenge(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult Conflict(object error = null);
+        public static IResult Content(string content, MediaTypeHeaderValue contentType);
+        public static IResult Content(string content, string contentType = null, Encoding contentEncoding = null);
+        public static IResult Created(string uri, object value);
+        public static IResult Created(Uri uri, object value);
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult File(byte[] fileContents, string contentType = null, string fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null);
+        public static IResult File(Stream fileStream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult File(string path, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Forbid(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static IResult NoContent();
+        public static IResult NotFound(object value = null);
+        public static IResult Ok(object value = null);
+        public static IResult Problem(string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null);
+        public static IResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        public static IResult SignIn(ClaimsPrincipal principal, AuthenticationProperties properties = null, string authenticationScheme = null);
+        public static IResult SignOut(AuthenticationProperties properties = null, IList<string> authenticationSchemes = null);
+        public static IResult StatusCode(int statusCode);
+        public static IResult Stream(Stream stream, string contentType = null, string fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue entityTag = null, bool enableRangeProcessing = false);
+        public static IResult Text(string content, string contentType = null, Encoding contentEncoding = null);
+        public static IResult Unauthorized();
+        public static IResult UnprocessableEntity(object error = null);
+        public static IResult ValidationProblem(IDictionary<string, string[]> errors, string detail = null, string instance = null, int? statusCode = default(int?), string title = null, string type = null);
+    }
 }
```

